/*
    Module allowing methods to be asserted (and retracted).
*/
#include <stdlib.h>
#include <stdio.h>
#include "concon.h"
#include "manager.h"
#include "symbol.h"
#include "manager.fdf"
#include "service.fdf"
#include "methods.fdf"
#include "global.h"

Descr *methDescrP = NULL;

void proMeth_init( void )
    {
    List new;

    cc_newDescr( &methDescrP, NULL );
    cc_clearLElm( &new );
    cc_makeSubList( &new, NULL );
    cc_copyAndInsert( methDescrP, &new, FALSE );
    }

void proMeth_exit( void )
    {
    cc_freeDescr( &methDescrP );
    }


Inherit proMeth_assertMethod( List *methP )
    {
    List *toExecP;
    Descr *procDescrP;
    long precedence;

/* get the relevant data from the original list. */
    toExecP = cc_binding( methP );
    if (toExecP == NULL)
        return FALSE;
    if (toExecP->u.p.type != INTEGER)
        return FALSE;
    precedence = toExecP->data.integer;
    toExecP = cc_binding( toExecP );

/* get the procedure definition for the operator. */
    procDescrP = cc_assoc( methP, methDescrP->nextP );
    if (procDescrP->nextP == NULL)
        {
        cc_freeDescr( &procDescrP );
        return FALSE;
        }
/* insert the new method. */
    proMeth_insert( procDescrP, precedence, toExecP );

    cc_freeDescr( &procDescrP );

    return TRUE;
    }

void proMeth_insert( Descr *procDescrP, long precedence, List *toExecP )
    {
    Descr *descrP;
    Inherit searching;
    long place = 0, i;
    long count = 0;
    List *traverserP, *keepP;
    List new;

/* get the number of methods given. */
    traverserP = toExecP;
    while (traverserP != NULL)
        {
        count++;
        traverserP = traverserP->nextP;
        }
    if (count == 0)
        return;

/* get the precedence list. */
    cc_newDescr( &descrP,
        cc_getSub(
            cc_binding(
                cc_getSub( cc_binding( procDescrP ) )   ) ) );

/* now traverse it, find the place and insert the new precedence. */
    traverserP = descrP;
    searching = (traverserP->nextP == NULL) ? FALSE : TRUE;
    while (searching)
        if ( ((List *)traverserP->nextP)->data.integer > precedence)
            searching = FALSE;
        else
            if (traverserP->nextP == NULL)
                searching = FALSE;
            else
                {
                place++;
                traverserP = traverserP->nextP;
                }
    cc_clearLElm( &new );
    cc_makeInteger( &new, precedence );
    for (i=0;i<count;i++)
        {
        new.nextP = traverserP->nextP;
        traverserP->nextP = proMem_getAvailAndCopy( &new );
        }

    cc_binding( cc_getSub( cc_binding( procDescrP ) ) )->data.dataP =
            descrP->nextP;
    cc_freeDescr( &descrP );

/* insert the new method. */
    traverserP =
        cc_getSub(
            cc_binding(
                cc_binding(
                    cc_getSub( cc_binding( procDescrP ) ) ) ) );

    for (i=0;i<place;i++)
        traverserP = traverserP->nextP;

    keepP = traverserP->nextP;
    traverserP->nextP = toExecP;
    while (traverserP->nextP != NULL) traverserP = traverserP->nextP;
    traverserP->nextP = keepP;
    }

Inherit proMeth_assertProcedure( List *defP )
    {
    List new;
    Descr *coreDescrP, *d1P;
    List  *paramListP = cc_binding( defP );

    if (paramListP == NULL)
        return FALSE;
    d1P = cc_assoc( defP, methDescrP->nextP );
    if (d1P->nextP != NULL)
        {
        cc_freeDescr( &d1P );
        return FALSE;
        }
    cc_freeDescr( &d1P );


/* The core, to be referenced twice. */
    cc_clearLElm( &new );
    cc_makeAtom( &new, "cond" );
    cc_newDescr( &coreDescrP, NULL );
    cc_copyAndInsert( coreDescrP, &new, FALSE );
    cc_makeSubList( &new, coreDescrP->nextP );
    cc_copyAndInsert( coreDescrP, &new, FALSE );
    ((List *)coreDescrP->nextP)->nextP = NULL;

/* appending to the method list. */
    cc_newDescr( &d1P, coreDescrP->nextP );
    cc_makeSubList( &new, NULL );
    cc_copyAndInsert( d1P, &new, FALSE );
    new = *defP;
    new.nextP = NULL;
    cc_copyAndInsert( d1P, &new, FALSE );
    cc_clearLElm( &new );
    cc_makeSubList( &new, d1P->nextP );
    cc_copyAndInsert( d1P, &new, FALSE );
    ((List *)d1P->nextP)->nextP =
        ((List *)methDescrP->nextP)->data.dataP;
    ((List *)methDescrP->nextP)->data.dataP = d1P->nextP;

/* building a lambda expression to use the procedure. */
    d1P->nextP = coreDescrP->nextP;
    new = *paramListP;
    new.nextP = NULL;
    cc_copyAndInsert( d1P, &new, FALSE );
    cc_makeAtom( &new, "lambda");
    cc_copyAndInsert( d1P, &new, FALSE );
    cc_makeSubList( &new, d1P->nextP );
    cc_copyAndInsert( d1P, &new, FALSE );
    ((List *)d1P->nextP)->nextP = NULL;
    new = *defP;
    new.nextP = NULL;
    cc_copyAndInsert( d1P, &new, FALSE );
    cc_set( FALSE, d1P->nextP, stateP );
    cc_freeDescr( &d1P );
    cc_freeDescr( &coreDescrP );

    return TRUE;
    }


List *proMeth_removeMethod( List *defP )
    {
    List *nextP = cc_binding( defP );
    long precedence;
    long count = 0;
    Descr *procDescrP;
    Descr *descrP;
    Inherit searching;
    long place = 0, i;
    List *traverserP, *keepP, *retListP;


    if (nextP == NULL)
        return NULL;
    if (nextP->u.p.type != INTEGER)
        return NULL;
    precedence = nextP->data.integer;

/* get the procedure definition for the operator. */
    procDescrP = cc_assoc( defP, methDescrP->nextP );
    if (procDescrP->nextP == NULL)
        {
        cc_freeDescr( &procDescrP );
        return NULL;
        }

/* get the precedence list. */
    cc_newDescr( &descrP,
        cc_getSub(
            cc_binding(
                cc_getSub( cc_binding( procDescrP ) )   ) ) );

/* now traverse it, find the place and count the number of occurences. */
    traverserP = descrP;
    searching = (traverserP->nextP == NULL) ? FALSE : TRUE;
    while (searching)
        if ( ((List *)traverserP->nextP)->data.integer == precedence)
            searching = FALSE;
        else
            if (traverserP->nextP == NULL)
                {
                place = -1L;
                searching = FALSE;
                }
            else
                {
                place++;
                traverserP = traverserP->nextP;
                }
    if (place == -1L)
        {
        cc_freeDescr( &procDescrP );
        cc_freeDescr( &descrP );
        return NULL;
        }
    keepP = traverserP;
    searching = TRUE;
    while (searching)
        if (traverserP->nextP == NULL)
            searching = FALSE;
        else
            if (((List *)traverserP->nextP)->data.integer == precedence)
                {
                count++;
                traverserP = traverserP->nextP;
                }
            else
                searching = FALSE;
    keepP->nextP = traverserP->nextP;

    cc_binding( cc_getSub( cc_binding( procDescrP ) ) )->data.dataP =
            descrP->nextP;
    cc_freeDescr( &descrP );

/* now remove the methods themselves, returning them. */
    traverserP =
        cc_getSub(
            cc_binding(
                cc_binding(
                    cc_getSub( cc_binding( procDescrP ) ) ) ) );

    for (i=0;i<place;i++)
        traverserP = traverserP->nextP;
    keepP = traverserP;
    for (i=0;i<count;i++)
        traverserP = traverserP->nextP;
    retListP = keepP->nextP;
    keepP->nextP = traverserP->nextP;
    traverserP->nextP = NULL;
    cc_freeDescr( &procDescrP );
    return retListP;
    }


