# $Id: Makefile.cpp,v 1.67 1992/07/08 22:09:12 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Use the current directory as the default master cache
DESTDIR	= ELISYS

# Just about everything lives in Tool except odin.
SUBDIR= odin Tool

# Do not re-run Tex
NOTEX	= true

# File set definitions
AUX	= *.cpp Configure README dg.specs elilink version.dg odin
TIDY	= *.o a.out core ERRS RLOG FILES INFO LOCAL ELI
CLEAN	= $(TIDY) bin Cmd odin.exe local.dg.tab

all:	dg.specs Configure elilink README bin Cmd
	@for i in $(SUBDIR); do echo; echo Making $$i; \
		DESTDIR=$(DESTDIR) export; (cd $$i; \
		make NOTEX=$(NOTEX) DESTDIR=$$DESTDIR CC="$(CC)"); \
		done

install:
	@if test ! -d $(DESTDIR); \
		then umask 002; mkdir $(DESTDIR); \
		else :; \
		fi
	@for d in bin Cmd Tool manl; do \
		if test ! -d $(DESTDIR)/$$d; \
			then umask 002; mkdir $(DESTDIR)/$$d; \
			else :; \
			fi; \
		done
	@for i in $(SUBDIR); do echo; echo Installing $$i; \
		DESTDIR=$(DESTDIR) export; \
		(cd $$i; make DESTDIR=$$DESTDIR NOTEX=$(NOTEX) install); \
		done
	@for i in manl/*; do echo; echo Installing $$i; \
		rm -rf $(DESTDIR)/$$i; \
		cp $$i $(DESTDIR)/$$i; \
		chmod 644 $(DESTDIR)/$$i; \
		done

executable:
	@for i in Tool; do echo; echo Making $$i executable; \
		(cd $$i; make executable); done
	rm -rf $(TIDY) $(AUX) Makefile include sysdata sysdata.sh

tidy:
	rm -rf $(TIDY)
	@for i in $(SUBDIR); do echo; echo Tidying $$i; \
		(cd $$i; make tidy); done

clean:
	rm -rf $(CLEAN)
	@for i in $(SUBDIR); do echo; echo Cleaning $$i; \
		(cd $$i; make clean); done

bin Cmd:
	umask 002; mkdir $@
