/***************************************************************************/
/* filename : high_optim.c                         first edit  : 10.01.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 20.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: high_optim.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

typedef struct rp *rptype[];


#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "clearing.h"

#include "errors.h"

#include "high.h"

#include "build_paths.h"


/****************************** FUNCTIONS **********************************/





static char *DGD_RR_MP_Opti( quick_data,user_data,red_paths,nred_paths,min_push,
                             n_red,extra_info )




   readtype    *quick_data;  /* interface vector to optimization           */
   struct user  *user_data;  /* structure which saves information entered
				by the user                                */
   struct ptrp  *red_paths,  /* a representation of the reduction paths    */
               *nred_paths;
   char          *min_push,  /* vector which stores if a state is a push -
				state or not                               */
                     n_red,  /* N table reduction situation are investi-
                                gated                                      */
		extra_info;  /* if extra_info == 1, then extra information
				about begin and end of function is printed
				out                                        */

/* This function determines, for all reduction situations, if the following
   optimization techniques are applicable:
      (1) Direct goto determination
      (2) Right - recursive rule optimization
      (3) Minimal push optimization
   For these examinations I use the same data structure discribed in module
   Build_Paths  ( see function Build_Reduce_Paths ).
   If (1) is applicable then bit number 14 of the current state will be
   set.  For (2) no extra information must be saved.  For (3) I need a
   vector of states in which each state is marked to show which are
   push states, and which are not.
*/


   {
     short            *redp,  /* pointer to the actual reduction situation */
			nop,  /* number of productions                     */
		       prod,  /* loop index                                */
		      state,  /* loop index                                */
			crp,  /* loop index                                */
                        pos,
                       loop,
              semantic_prod,
                 nred_count,
		state_count,  /* saves the number of states in which a
				 reduction of the actual production should
				 take place                                */
		   state_nr,  /* saves the current state number of the
				 actual reduction situation                */
		 count_redp,  /* saves the number of reduction paths of the
				 actual reduction situation                */
		    eq_test,  /* saves the first continuation state of a
				 given reduction situation to test if the
				 other continuation states are equal to it */
		   semantic;  /* saves if the actual production is semantic
				 or not                                    */
     char             go_on;  /* decides if the while loop, which tests if
				 direct goto determination is possible,
				 is executed or not                        */

     struct rp    *help_ptr,  /* pointer to all reduction situations of
				 a given production                        */
                  *nred_ptr;






     if( extra_info )
	printf("begin of function DGD_RR_MP_Opti()\n");
     nop = *((*quick_data)[5]);

     for( prod=0;prod<nop;prod++ )
	{
	  semantic    = IS_ABS( (*quick_data)[8][prod] );
	  help_ptr    = red_paths[prod].pointer;
	  state_count = red_paths[prod].number_of_states;

	  for( state=0;state<state_count;state++ )
	     if( !(IS_DEL( help_ptr[state].state )) )
		{
		  if( user_data->direct_goto_determination                 &&
                      ( !(IS_DGD_NOT_ALLOWED( help_ptr[state].state )) ||
                       user_data->individual_reduce_code               )    )       
		     {
		       /* Direct - Goto - Determination   */
		       state_nr   = OPERAND( help_ptr[state].state );
		       redp       = help_ptr[state].rep.pt_rp;
		       count_redp = *redp;
		       go_on      = TRUE;
		       redp      += 3;
		       count_redp--;
		       eq_test = *redp;
                       if( (IS_SHRED_NTACT( *redp ))   &&
                           (count_redp>0)               )
                            go_on = FALSE;
		       while( (count_redp > 0) && go_on )
			  {
			    count_redp--;
			    redp += 2;
			    if( eq_test != *redp )
		               go_on = FALSE;
			  } /* end of while( (count_r... */
                      if( go_on && user_data->individual_reduce_code )
                         help_ptr[state].rep.pt_rp[0] = 1;
		      if( go_on && !(IS_DGD_NOT_ALLOWED( help_ptr[state].state )) )
                         {
		           help_ptr[state].state =
			      SET_DGD( help_ptr[state].state );
		           /* bit number 14 will be set */
                           redp = help_ptr[state].rep.pt_rp;
                           if( IS_SHRED_NTACT( redp[3] ) )
                              {
                                pos = 0;
                                crp = 0;
                                nred_ptr = nred_paths[OPERAND( redp[3] )].pointer;
                                nred_count = nred_paths[OPERAND( redp[3] )].
                                              number_of_states;
                                semantic_prod = IS_ABS( (*quick_data)[8][
                                                OPERAND( redp[3] )] );
                                while( (pos<redp[0]) &&
                                       (crp<nred_count) )
                                   {
                                     if( redp[2+2*pos] ==
                                         OPERAND( nred_ptr[crp].state ) )
                                        {
                                          if( !(IS_DEL( nred_ptr[crp].state )) )
                                             {
                                               if( IS_DGD( nred_ptr[crp].state ) ) 
                                                  nred_ptr[crp].state = 
                                                     SET_NO_DGD( nred_ptr[crp].
                                                                 state );
                                               if( !(IS_DGD_NOT_ALLOWED( 
                                                      nred_ptr[crp].state )) )
                                                  {
                                                    nred_ptr[crp].state =
                                                       SET_DGD_NOT_ALLOWED(
                                                        nred_ptr[crp].state );
if( semantic_prod || !user_data->chain_rule_elimination  ||
    ((*quick_data)[7][OPERAND( redp[3] )] != 1) ||
    ( (nred_ptr[crp].rep.pt_rp[0] == 1)  &&
      (IS_SHRED_NTACT(nred_ptr[crp].rep.pt_rp[3]) ?
        (IS_ABS( (*quick_data)[8][OPERAND( nred_ptr[crp].rep.pt_rp[3] )] ) ? 
           FALSE : TRUE) : FALSE) ) )
                                                       for( loop=0;loop<nred_ptr[
                                                            crp].rep.pt_rp[0];
                                                            loop++ )
                                                          min_push[nred_ptr[crp].
                                                          rep.pt_rp[2+2*loop]] =
                                                            TRUE;
                                                  } /* end of if( !(IS_DGD_N... */ 
                                             } /* end of if( !(IS_DEL( nr... */
                                          crp++;
                                          pos++;
                                        } /* end of if( redp[2+2*... */
                                     else
                                        crp++;
                                   } /* end of while( (pos<red... */
                                if( (pos<redp[0]) && (crp == nred_count) )
                                   Error_Message();
                              } /* end of if( IS_SHRED_NTA... */
                         } /* end of if( go_on && (IS_DGD_NO... */
                     } /* end of if( user_data->dir... */
		  if( user_data->min_push && 
                      !(IS_DGD_NOT_ALLOWED( help_ptr[state].state )) &&
                      !(IS_DGD( help_ptr[state].state )) )
			   {
			    /*  RR - and MP - Optimization  */
			     redp       = help_ptr[state].rep.pt_rp;
			     count_redp = *redp;
			     redp +=2;
                             if( semantic                            ||
                                 !user_data->chain_rule_elimination  ||
                                 !n_red                              ||
                                 ((*quick_data)[7][prod] != 1)        )
			        if( semantic )
			           for( crp=0;crp<count_redp;crp++ )
				      {
				        min_push[*redp] = TRUE;
				        redp += 2;
				      } /* end of for( crp=0;crp<... */
			        else
			           {
			             redp++;
                                     state_nr = OPERAND( help_ptr[state].state );
			             for( crp=0;crp<count_redp;crp++ )
				        {
				          if( (state_nr != OPERAND( *redp )) &&
                                              (!(IS_SHRED_NTACT(*redp))  ||
                                               (OPERAND( *redp ) != prod) )   ) 
				             min_push[*(redp-1)] = TRUE;
				          redp += 2;
				       } /* end of for( crp=0;crp<... */
			           } /* end of else ( if( semantic ) ) */

			   } /* end of if( user_data->min_push ) */

	        } /* end of if( !(IS_DEL( ... */

	} /* end of for( prod=0;pro... */

     if( extra_info )
	printf("end of function DGD_RR_MP_Opti()\n");
     return( min_push );

   }/* end of function DGD_RR_MP_Opti() */




static void Find_Non_Push_Transitions( changed_data,test_vc,ttab,ntab,max,
				       redp,rhs,non,not,length,count_vc,
				       extra_info )

   struct inter  *changed_data;  /* Internal vector between the module for
				    higher optimization techniques and the
				    one for lower optimization techniques.
				    This vector saves the changed data.    */
   short              *test_vc, /* used to test if one state is a non-push
				   state and in how many reduction paths of
				   the current reduction situation it
				   occurs                                  */
			 *ttab,  /* representation of the T - table        */
			 *ntab,  /* representation of the N - table        */
			 *redp,  /* pointer to the reduction paths of one
				    reduction situation                    */
			  *rhs,  /* vector which saves the right hand sides
				    of each production                     */
			   max,  /* the maximum number of push states on a
				    reduction path of the current reduction
				    situation                              */
			   non,  /* number of nonterminal symbols          */
			   not,  /* number of terminal symbols             */
			length,  /* if the old action is a shift/reduce
				    action, length = length of right hand
						     side - 1,
				    else    length = length of right hand
						     side                  */
		     *count_vc;  /* vector with the number of pops of all
				    reduction paths of the actual reduction
				    situation                              */

   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                         */


/* If a pop count conflict takes place and it can not be easy resolved,
   this function is called.  It searchs for states on the reduction
   paths of the current reduction situation, which are not push states.
   Then the conflict would be solved, by changing some of them to push
   states.
*/

   {
     short        crp,  /* loop index for reduction paths                  */
	    act_state,  /* the actual state which will be investigated     */
	    rhs_count,  /* loop index for the right hand side of a rule    */
	     rhs_symb,  /* the symbol of the right hand side actually
			   investigated                                    */
	       noredp;  /* nuber of reduction paths of the current
			   reduction situation                             */



     if( extra_info )
	printf("begin of function Find_Non_Push_Transitions( )\n");

     noredp = *redp;

     for( crp=0;crp<noredp;crp++ )
	{
	  act_state = *(redp+2+crp*2);
	  for( rhs_count=0;rhs_count<length;rhs_count++ )
	     {
	       rhs_symb = rhs[rhs_count];
	       if( rhs_symb<0 )
		  {
		    if( !(changed_data->min_push[OPERAND(
				 ntab[act_state*non-rhs_symb-2] )]) )
		       if( max == count_vc[redp[crp*2+2]] )
			  test_vc[OPERAND(
				   ntab[act_state*non-rhs_symb-2] )] = -1;
		       else
			  if( test_vc[OPERAND(
				   ntab[act_state*non-rhs_symb-2] )] >=0 )
			     test_vc[OPERAND(
				      ntab[act_state*non-rhs_symb-2] )]++;
		    act_state = OPERAND( ntab[act_state*non-rhs_symb-2] );
		  } /* end of if( rhs_symb<0 ) */
	       else
		  {
		    if( !(changed_data->min_push[OPERAND(
				    ttab[act_state*not+rhs_symb] )]) )
		       if( max == count_vc[redp[crp*2+2]] )
			  test_vc[OPERAND(
				   ttab[act_state*not+rhs_symb] )] = -1;
		       else
			  if( test_vc[OPERAND(
				   ttab[act_state*not+rhs_symb] )] >=0 )
			     test_vc[OPERAND(
				      ttab[act_state*not+rhs_symb] )]++;
		    act_state = OPERAND( ttab[act_state*not+rhs_symb] );
		  } /* end of else ( if( rhs_symb<0 ) ) */
	     } /* end of for( rhs_count=0... */
	} /* end of for( crp=0;crp<... */

     if( extra_info )
	printf("end of function Find_Non_Push_Transitions( )\n");

   } /* end of function Find_Non_Push_Transitions( ) */




static char Solve_PCC( quick_data,redp,count_vc,red_state,length,rhs,
		       changed_data,old_action,kind,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */

   short                 *redp,  /* the reduction situation, with the pop
				    count conflict                         */
		     *count_vc,  /* vector with the number of pops of all
				    reduction paths of the actual reduction
				    situation                              */
		     red_state,  /* the state where the production will be
				    reduced, which leads to the reduction
				    situation with the pop count conflict  */
			  *rhs,  /* right hand side of the actual produc-
				    tion                                   */
			length,  /* if the old action is a shift/reduce
				    action, length = length of right hand
						     side - 1,
				    else    length = length of right hand
						     side                  */
			  kind,  /* This variable saves, what kind of
				    reduction situation be submitted.
				    if kind == 0, it is a reduce situation in
					       T - table,
				    if kind == 1, it is a shift/reduce situ-
					       ation in T - table and
				    if kind == 2, it is a shift/reduce situ-
					       ation in N - table          */
		    old_action;  /* the action, which leads to this reduc-
				    tion situation                         */

   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char     	    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                         */


/* This function solves pop count conflicts. A pop count conflict
   happens very seldom. So the time and space penalties for solving
   this conflict can be neglected.

   First, the conflict position is determined in the reduction
   situation.  Then a test is performed to see if it is possible to
   solve this conflict by visiting the state stack. If not, a non push
   state on one reduction situation is choosen and is turned into a push
   state.  Then the function Pop_Count_Entry starts again.

   Otherwise I save the information to solve the pop count conflict and
   go on.
*/



   {
     short            crp,  /* loop index                                  */
		rhs_count,  /* loop index                                  */
		 rhs_symb,  /* one symbol of the right hand side of the
			       production                                  */
		   noredp,  /* number of reduction paths of the reduction
			       situation                                   */
		    *ntab,  /* representation of the N - table             */
		    *ttab,  /* representation of the T - table             */
		      not,  /* number of terminals                         */
		      non,  /* number of nonterminals                      */
		      nos,  /* number of states                            */
		act_state,  /* the actual state which will be investigated */
		      max,  /* used to count how many push states on the
			       reduction path with the most push states    */
		      min,  /* used to count how many push states on the
			       reduction path with the less push states    */
		max_state,  /* used to determine the non push state which
			       accurs most in the reduction situation      */
		 max_test,  /* the cooresponding number of occurences      */
		       st,  /* loop index                                  */
		    count,  /* count how many states are involved in the
			       conflict                                    */
		 *test_vc;  /* This vector is used in function ind_Non_Push_
			       States. The vector will be passed to this
			       function. There it is used to test if one
			       state is a non push state and in how many
			       reduction paths of the current reduction
			       situation it occurs                         */

     char            found; /* used to decide if a searched state is found */
     struct pcc_elem* elem; /* one element of the structure, which saves
			       all relevant data for solving of the pop
			       count conflict                              */




     if( extra_info )
	printf("begin of function Solve_PCC()\n");



     ntab = (*quick_data)[4];
     ttab = (*quick_data)[1];
     not = *((*quick_data)[0]);
     non = *((*quick_data)[3]);
     nos = *((*quick_data)[9]);

     noredp = *redp;

     if( (test_vc = (short*) calloc( nos,sht )) == NULL )
	Error_Message( _SOLVE_PCC,MODULE_HIGH_OPTIM,NO_SPACE_FOR_VECTOR,ABORT,
                       " test_vc" );


     min = nos+1;
     max = -1;
     for( crp=0;crp<noredp;crp++ )
	{
	  if( min>count_vc[redp[crp*2+2]] )
	     min = count_vc[redp[crp*2+2]];
	  if( max<count_vc[redp[crp*2+2]] )
	     max = count_vc[redp[crp*2+2]];
	} /* end of for( crp=0;crp<... */
     if( max-min > 1 )
	{
	  Find_Non_Push_Transitions( changed_data,test_vc,ttab,ntab,max,
				     redp,rhs,non,not,length,count_vc,
				     extra_info );

	  max_test = 0;
	  max_state = -1;
	  for( st=0;st<nos;st++ )
	     if( max_test<test_vc[st] )
		{
		  max_test  = test_vc[st];
		  max_state = st;
		} /* end of if( max_test<te... */
	  if( max_test == 0 )
	     Error_Message( _SOLVE_PCC,MODULE_HIGH_OPTIM,NOT_FIND_ELEMENT,ABORT,
                            " max_test");
	  changed_data->min_push[max_state] = TRUE;
	  return( TRUE );
	} /* end of if( max-min > 1 ) */


     found = FALSE;
     for( crp=0;crp<noredp;crp++ )
	if( (min == count_vc[redp[crp*2+2]]) &&
	    !(changed_data->min_push[redp[crp*2+2]]) )
	   {
	     found = TRUE;
	     changed_data->min_push[redp[crp*2+2]] = TRUE;
	   } /* end of if( (min == cou... */

     if( found )
	return( TRUE );

     for( st=0;st<nos;st++ )
	test_vc[st] = 0;

     for( crp=0;crp<noredp;crp++ )
	if( max == count_vc[redp[crp*2+2]] )
	   {
	     found = FALSE;
	     rhs_count = 0;
	     act_state = *(redp+2+crp*2);
	     while( (rhs_count<length) && !found )
		{
		  rhs_symb = rhs[rhs_count];
		  if( rhs_symb<0 )
		     {
		       if( changed_data->min_push[OPERAND(
			       ntab[act_state*non-rhs_symb-2] )] )
			  {
			    found = TRUE;
			    test_vc[OPERAND(
			       ntab[act_state*non-rhs_symb-2] )]++;
			  } /* end of if( changed_dat... */
		       act_state = OPERAND( ntab[act_state*non-rhs_symb-2] );
		     } /* end of if( rhs_symb<0 ) */
		  else
		     {
		       if( changed_data->min_push[OPERAND(
				    ttab[act_state*not+rhs_symb] )] )
			  {
			    found = TRUE;
			    test_vc[OPERAND(
				       ttab[act_state*not+rhs_symb] )]++;
			  } /* end of if( changed_dat... */
		       act_state = OPERAND( ttab[act_state*not+rhs_symb] );
		     } /* end of else ( if( rhs_symb<0 ) ) */
		  rhs_count++;
		} /* end of for( rhs_count=0... */
	   } /* end of if( max == coun... */

     found = FALSE;
     crp = 0;
     while( crp<noredp )
	if( (min == count_vc[redp[crp*2+2]]) &&
	    (test_vc[redp[crp*2+2]] > 0) )
	   found = TRUE;
	else
	   crp++;
     if( found )
	{
	  for( st=0;st<nos;st++ )
	     test_vc[st] = 0;
	  Find_Non_Push_Transitions( changed_data,test_vc,ttab,ntab,max,
				     redp,rhs,non,not,length,count_vc,
				     extra_info );
	  act_state = redp[crp*2+2];
	  rhs_count = 0;
	  found = FALSE;
	  while( (rhs_count<length) && !found )
	     {
	       rhs_symb = rhs[rhs_count];
	       if( rhs_symb < 0 )
		  {
		    if( !(changed_data->min_push[OPERAND(
			  ntab[act_state*non-rhs_symb-2] )]) &&
			 (test_vc[OPERAND(
			  ntab[act_state*non-rhs_symb-2] )] >0) )
			  {
			    found = TRUE;
			    changed_data->min_push[OPERAND(
				 ntab[act_state*non-rhs_symb-2] )] = TRUE;
			  } /* end of if( !(changed_d... */
		    act_state = OPERAND(ntab[act_state*non-rhs_symb-2] );
		  } /* end of if( rhs_symb<0 ) */
	       else
		  {
		    if( !(changed_data->min_push[OPERAND(
			  ttab[act_state*not+rhs_symb] )])  &&
			 (test_vc[OPERAND(
			  ttab[act_state*not+rhs_symb] )] >0) )
			  {
			    found = TRUE;
			    changed_data->min_push[OPERAND(
				 ttab[act_state*not+rhs_symb] )] = TRUE;
			  } /* end of if( !(changed_d... */
		    act_state = OPERAND(ttab[act_state*not+rhs_symb] );
		  } /* end of else ( if( rhs_symb<0 ) ) */
	       rhs_count++;
	     } /* end of while( (rhs_cou... */
	  if( found )
	     return( TRUE );
	  else
	     Error_Message( _SOLVE_PCC,MODULE_HIGH_OPTIM,NOT_FIND_ELEMENT,ABORT,
                            " rhs_symb" );
	} /* end of if( found ) */

     count = 0;
     for( crp=0;crp<nos;crp++ )
	if( test_vc[crp] )
	   count++;

     if( (elem = (struct pcc_elem*) malloc(
			  sizeof( struct pcc_elem ) )) == NULL )
	Error_Message( _SOLVE_PCC,MODULE_HIGH_OPTIM,NO_SPACE_FOR_STRUCTURE,ABORT,
                       " elem" );

     elem->state  = red_state;
     elem->prod   = old_action;
     elem->kind   = kind;
     elem->pop    = max-1;
     elem->number = count;
     elem->next   = changed_data->pcc_list;
     changed_data->pcc_list = elem;

     if( (elem->pointer = (short*) calloc( count,sht )) == NULL )
	Error_Message( _SOLVE_PCC,MODULE_HIGH_OPTIM,NO_SPACE_FOR_VECTOR,ABORT,
                       " elem->pointer" );

     count = 0;
     for( crp=0;crp<nos;crp++ )
	if( test_vc[crp] )
	   {
	     elem->pointer[count] = crp;
	     count++;
	   } /* end of if( test_vc[crp... */

     redp[1] = -1;
     changed_data->number_of_pcc++;
     if( extra_info )
	printf("end of function Solve_PCC()\n");
     return( FALSE );

   } /* end of function Solve_PCC() */







static char PCC( quick_data,state_ptr,pos,count_vc,length,rhs,changed_data,
		 old_action,kind,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */

   struct rp        *state_ptr;  /* pointer to all reduction situations for
				    one production                         */
   short                   pos,  /* position in state_ptr, which points to
				    the actual reduction situation         */
		     *count_vc,  /* vector with the number of pops of all
				    reduction paths for the actual reduction
				    situation                              */
			  *rhs,  /* right hand side of the actual produc-
				    tion                                   */
			length,  /* if the old action is a shift/reduce
				    action, length = length of right hand
						     side - 1,
				    else    length = length of right hand
						     side                  */
		    old_action;  /* the action which leads to this reduc-
				    tion situation                         */

   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char     	    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */


/* This function checks for the occurance a pop count conflict in a given
   reduction situation. If one occurs, control is passed to the function 
   Solve_PCC.  This function returns a new reduction situation whithout 
   pop count conflicts.
*/


   {
     short                crp,  /* loop index                              */
		      eq_elem,  /* the greatest pop entry in count_vc      */
		       noredp,  /* number of reduction paths               */
			*redp;  /* the actual reduction situation          */
     char  pop_count_conflict   /* variable to decide, if a pop count      */
		      = FALSE,  /* conflict has arisen                     */
	    new_entry = FALSE;  /* It is used to decide if the changes by
				   function Solve_PC are so aggravating,
				   that all reduction situations must be
				   investigated once again.                */






     if( extra_info )
	printf("begin of function PCC()\n");
     redp = state_ptr[pos].rep.pt_rp;
     noredp = *redp;
     eq_elem = count_vc[*(redp+2)];

     /* test if a pop count conflict exist */
     for(crp=1;crp<noredp;crp++)
	if( (count_vc[*(redp+2+crp*2)] != eq_elem) )
	   pop_count_conflict = TRUE;
     if( pop_count_conflict )
	{
	  new_entry = Solve_PCC( quick_data,state_ptr[pos].rep.pt_rp,
				 count_vc,OPERAND( state_ptr[pos].state ),
				 length,rhs,changed_data,old_action,kind,
				 extra_info );
	  if( IS_DGD( state_ptr[pos].state ) )
	     state_ptr[pos].state = SET_NO_DGD( state_ptr[pos].state );

	} /* end of if( pop_count_c... */
     else
	*(state_ptr[pos].rep.pt_rp+1) = eq_elem;

     if( extra_info )
	printf("end of function PCC()\n");
     return( new_entry );

   } /* end of function PCC() */






static char Pop_Count_Entry( red_paths,quick_data,min_push,changed_data,
			     t_table,extra_info )

   struct ptrp      *red_paths;  /* a representation of the reduction
				    paths                                  */
   readtype        *quick_data;  /* interface vector to optimization       */
   char              *min_push;  /* the minimal push state                 */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char                t_table,  /* if t_table == TRUE then reduction
				    situations of the T - table should
				    be investigated.  Otherwise, the
				    N-table reduction situations should
				    be investigated */
		    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */


/* After the minimal push states are determined, it is possible to
   decide how many states must be popped if a given reduction path is
   used.  For every reduction situation, the complete reduction paths
   are computed once again and the number of push states on each
   reduction path is determined.  This computed number is exactly the
   number of states which must be popped, if the situation above takes
   place.  To save the determined numbers, the same data structure
   described in module Build_Paths (see function Red_Sit and function
   Build_Reduce_Paths)  is used, and the free positions in the vector
   are filled, which saves the reduction paths of a given reduction
   situation.  If the number of pops is not equal in one reduction
   situation, a so-called pop count conflict arises. For inquiry,
   control will be passed to function PCC.

   If direct goto determination applies to a reduction situation,  we
   do not need all continuation states because they are all equal. So
   we need only one which represents the continuation states. The
   reduction paths will be saved as follows:

   +----+----------------+------------------+------------------------+
   | 1  | number of pops | any origin state | the continuation state |
   +----+----------------+------------------+------------------------+

*/


   {
     short              nop,  /* number of productions                     */
			nos,  /* number of states                          */
			non,  /* number of nonterminals                    */
			not,  /* number of terminals                       */
		      count,  /* loop index                                */
		      state,  /* loop index                                */
		       prod,  /* loop index                                */
			crp,  /* loop index                                */
		state_count,  /* number of states in which a production
				 r will be reduced                         */
		       *rhs,  /* a vector of the right hand side symbols
				 from one production                       */
		 rhs_length,  /* the corresponding length of the vector
				 rhs                                       */
		  *count_vc,  /* this vector is used to compute the
				 complete reduction situation              */
	      *act_state_vc,  /* used to determine all states of the
				 reduction paths                           */
		     length,  /* if the old action is a shift/reduce
				 action, length = length of right hand
						  side - 1,
				 else    length = length of right hand
						  side                     */
		  rhs_count,  /* loop index                                */
		   rhs_symb,  /* one symbol of the right hand side of the
				 production                                */
		     noredp,  /* number of reduction paths of the reduction
				 situation                                 */
		      *ntab,  /* representation of the N - table           */
		      *ttab,  /* representation of the T - table           */
		      *redp,  /* pointer to the current reduction
				 situation                                 */
		       kind;  /* This variable saves what kind of reduc-
				 tion situation is submitted.
				 kind == 0, it is a reduce situation in
					    T - table,
				 kind == 1, it is a shift/reduce situation
					    in T - table and
				 kind == 2, it is a shift/reduce situation
					    in N - table                   */

     struct rp    *help_ptr;  /* pointer to the vector of states which
				 represent, together with the corresponding
				 production, all reduction situations of
				 this production                           */

     char         new_entry;  /* used to decide if the changes by
				 function Solve_PC are so aggravating, that
				 all reduction situations must be investi-
				 gate once again.                          */




     if( extra_info )
	printf("begin of function Pop_Count_Entry()\n");

     not = *((*quick_data)[0]);
     non = *((*quick_data)[3]);
     nos = *((*quick_data)[9]);
     nop = *((*quick_data)[5]);
     ntab = (*quick_data)[4];
     ttab = (*quick_data)[1];

     if( ((count_vc    = (short*) malloc ( nos*sht )) == NULL) ||
	 ((act_state_vc = (short*) malloc ( nos*sht )) == NULL) )
	     Error_Message( _POP_COUNT_ENTRY,MODULE_HIGH_OPTIM,
                            NO_SPACE_FOR_VECTOR,ABORT," act_state_vc" );

     new_entry = FALSE;
     prod = 0;
     while( (prod<nop) && !new_entry )
	{
	  help_ptr    = red_paths[prod].pointer;
	  state_count = red_paths[prod].number_of_states;
	  rhs         = (*quick_data)[14+prod];
	  rhs_length  = (*quick_data)[7][prod];


	  for( count=0;count<state_count;count++ )
	     if( !(IS_DEL( help_ptr[count].state )) && !new_entry )
		{
		  for( state=0;state<nos;state++ )
		     {
		       count_vc[state]    = 0;
		       act_state_vc[state] = 0;
		     } /* end of for( state=0;st... */

		  redp     = help_ptr[count].rep.pt_rp;
		  noredp   = *redp;
		  length   = (IS_SHIFT_SITUATION( help_ptr[count].state )) ?
				   (rhs_length - 1) : rhs_length;
		  if( !t_table )
		     kind = 2;
		  else
		     kind = (IS_SHIFT_SITUATION( help_ptr[count].state )) ?
				   1 : 0;

		  for( crp=0;crp<noredp;crp++ )
		     act_state_vc[crp] = *(redp+2+crp*2);

		  /* determine the pop's of all reduction paths, of the
		     current reduction situation */
		  for( rhs_count = 0;rhs_count<length;rhs_count++ )
		     {
		       rhs_symb = rhs[rhs_count];
		       for( crp=0;crp<noredp;crp++ )
			  if( rhs_symb<0 )
			     {
			       if( min_push[
				   OPERAND(
				   ntab[act_state_vc[crp]*non-rhs_symb-2] )] )
					  count_vc[*(redp+2+crp*2)]++;
			       act_state_vc[crp] = OPERAND(
				    ntab[act_state_vc[crp]*non-rhs_symb-2] );
			     } /* end of if( rhs_symb<0 ) */
			  else
			     {
			       if( min_push[
				   OPERAND(
				    ttab[act_state_vc[crp]*not+rhs_symb] )] )
				       count_vc[*(redp+2+crp*2)]++;
			       act_state_vc[crp] = OPERAND(
				      ttab[act_state_vc[crp]*not+rhs_symb] );
			     } /* end of else ( if( rhs_symb<0 ) ) */
		     } /* end of for( rhs_count ... */

     /* Now in count_vc the number of pop's of all reduction paths
	of the current reduction situation are registered                  */
		  new_entry = PCC( quick_data,help_ptr,count,count_vc,
				   length,rhs,changed_data,prod,kind,
				   extra_info );
		  redp = help_ptr[count].rep.pt_rp;
		} /* end of if( !(IS_DEL( ... */
	  if( !new_entry )
	     prod++;
	} /* end of while( prod<nop... */

     if( extra_info )
	printf("end of function Pop_Count_Entry()\n");
     return( new_entry );

   }/* end of function Pop_Count_Entry()  */






static char Proof_Join( red_paths_ntab,prod,state,extra_info )

   struct ptrp  *red_paths_ntab;  /* a representation of the reduction
				     paths of N - Table reduction sit-
				     uations                               */
   short                   prod,
                          state;
   char              extra_info; 

   {
     struct rp    *help_ptr;  /* pointer to the vector of states which
				 represent, together whith the corresponding
				 production, all reduction situations of
				 this production                           */
     short      state_count;
     char             found=
                      FALSE;

     if( extra_info )
	printf("begin of function Proof_Join()\n");

     help_ptr    = red_paths_ntab[prod].pointer;
     state_count = red_paths_ntab[prod].number_of_states;

     while( (state_count>0) && !found )
        if( OPERAND( (*help_ptr).state) == state ) 
           found = TRUE;
        else
           {
             help_ptr++;
             state_count--;
           } /* end of else ( if( OPERAND( (*hel... ) */
     if( state_count == 0 )
        Error_Message( );
     if( IS_DGD( (*help_ptr).state ) )
        {
          if( extra_info )
	     printf("end of function Proof_Join()\n");
          return( FALSE );
        }
     else
        {
          if( extra_info )
	     printf("end of function Proof_Join()\n");
          return( TRUE );
        }



   } /* end of function Proof_Join() */







static void Join_Red_Paths( quick_data,redp,red_paths_ntab,extra_info )

   readtype         *quick_data;  /* interface vector to optimization      */
   short                  *redp;  /* pointer to the actual reduction
				     situation                             */
   struct ptrp  *red_paths_ntab;  /* a representation of the reduction
				     paths of N - Table reduction sit-
				     uations                               */
   char     	     extra_info;  /* if extra_info == 1, then extra infor-
				     mation about begin and end of func-
				     tion is printed out                  */

/* This is a recursive function, which join two reduce paths of chain
   rules.  This function works only on the N - table because the
   following situation cannot take place on the T - table.
   A reduction path of a chain rule has the same structure every time.
   It only consists of an origin state and a continuation state. It is
   possible that the continuation state is a new reduction of a rule.
   If this rule is a chain rule too, then it is possible to join these two
   paths. This function returns the result of a repetitive computation
   of the phenomen described above.
*/

   {
     char              join=
                       TRUE,
                      found;  /* variable to decide if the searched state
				 is found or not                           */
     short        new_state,  /* The origin state of the first chain rule
				 is the reduction state of the second chain
				 rule. We are searching for this new state.*/
		   new_prod,  /* the continuation state of the first chain
				 rule is a new reduce entry                */
		state_count,  /* saves the number of states in which a fixed
				 rule will be reduced [* right? *]         */
		  cont_prod,  /* The continuation state of the second chain
				 rule is a reduce entry too. Because it is
				 possible to call this function once again
				 we must save the entry.                   */
		 *help_redp;  /* help pointer to the new reduction situ-
				 ation                                     */
     struct rp    *help_ptr;  /* pointer to the vector of states which
				 represent, together whith the corresponding
				 production, all reduction situations of
				 this production                           */



     if( extra_info )
	printf("begin of function Join_Red_Paths()\n");
     found       = FALSE;
     new_state   = *(redp+2);
     new_prod    = OPERAND( *(redp+3) );
     help_ptr    = red_paths_ntab[new_prod].pointer;
     state_count = red_paths_ntab[new_prod].number_of_states;

     /* find the searched state */
     while( (state_count>0) && !found )
	if( OPERAND( (*help_ptr).state ) == new_state )
	   found = TRUE;
	else
	   {
	     help_ptr++;
	     state_count--;
	   } /* end of else ( if( OPERAND( (*... ) */
     if( state_count == 0 )
	Error_Message( _JOIN_RED_PATHS,MODULE_HIGH_OPTIM,NOT_FIND_ELEMENT,ABORT,
                       "new_state" );
     help_redp = (*help_ptr).rep.pt_rp;

     /* if the new state is a chain rule, with a new reduction situation
	as continuation state, join this both too */
     if( IS_SHRED_NTACT( help_redp[3] ) )
	{
	  cont_prod = OPERAND( *(help_redp+3) );
	  if( !(IS_ABS( (*quick_data)[8][cont_prod] ))  &&
	      ((*quick_data)[7][cont_prod] == 1) &&
	      (cont_prod != new_prod) )
		 {
		   Join_Red_Paths( quick_data,help_redp,red_paths_ntab,
				   extra_info );
		 } /* end of if( !(IS_ABS( (*... */
          else
             join = Proof_Join( red_paths_ntab,cont_prod,*(help_redp+2),
                                extra_info );
	} /* end of if( IS_SHRED_... */
     if( join )
        *(redp+3) = *(help_redp+3);

     if( extra_info )
	printf("end of function Join_Red_Paths()\n");

   } /* end of function Join_Red_Paths() */






static void Insert_Chain_Rules(quick_data,user_data,ntab_red_paths,help_ptr,
                               pos,n_red,extra_info )


   readtype         *quick_data;  /* interface vector to optimization      */
   struct ptrp  *ntab_red_paths;  /* a representation of the reduction
				     paths of N - Table reduction sit-
				     uation                                */
   struct user       *user_data;  /* structure which saves informations
				     fixed by the user                     */
   struct rp          *help_ptr;  /* pointer to the vector of states which  
                                     represent, together whith the corres-
                                     ponding production, all reduction 
                                     situations of this production         */
   short                    pos;
   char                   n_red,  /* N table reduction situation are 
                                     investigated                          */
                     extra_info;  /* if extra_info == 1, then extra infor-
				     mations about begin and end of func-
				     tion are printed out                  */

/* If there exist a reduction situation of a non chain rule in N - or
   T - table, which leads to a new reduction of a rule r. Then both
   reduction situation will be joined, if r is a chain rule.
*/


   {
     short     search_count,  /* loop index                                */
			crp,  /* loop index                                */
		  cont_prod,  /* The continuation state of the T - table
				 chain rule has a reduction situation as
				 continuation state. Cont_prod saves the
				 rule which will be reduced.               */
		 count_redp,  /* number of reduction paths of the current
				 reduction situation                       */
		    eq_test,  /* saves the first continuation state of the
				 reduction situation                       */
		 cont_state,  /* Saves the origin state of the actual
				 reduction path. This state is the reduction
				 state of the new reduction situation.     */
                 new_action,
		      *redp;  /* pointer to the actual reduction situation */
     char             found,  /* variable to decide, if the state is found */
		     change,  /* used to decide if a reduction situation is
				 changed                                   */
                direct_goto,
		      go_on;  /* breaking condition of a while loop        */

     struct rp  *search_ptr;  /* represent, together whith the corresponding
				 production, all reduction situations of
				 this production                           */



     if( extra_info )
	printf("begin of function Insert_Chain_Rules()\n");

     redp       = help_ptr[pos].rep.pt_rp;
     count_redp = *redp;
     if( (count_redp>1)                &&
         (IS_DGD(help_ptr[pos].state)) )
        direct_goto = TRUE;
     else
        direct_goto = FALSE;
     change     = FALSE;
     new_action = 0;
     for( crp=0;crp<count_redp;crp++ )
        if( IS_SHRED_NTACT( redp[crp*2+3] ) )
	   {
	     cont_prod     = OPERAND( redp[crp*2+3] );
	     cont_state    = redp[crp*2+2];
             if( !(IS_ABS( (*quick_data)[8][cont_prod] )) &&
	         ((*quick_data)[7][cont_prod] == 1) )
	        {
		  found        = FALSE;
	          search_ptr   = ntab_red_paths[cont_prod].pointer;
		  search_count = ntab_red_paths[cont_prod].number_of_states;
		  while( (search_count>0) && !found )
		     if( OPERAND( (*search_ptr).state ) == cont_state )
		        found = TRUE;
		     else
		        {
		          search_ptr++;
		          search_count--;
		        } /* end of else ( if( OPERAND( (*... ) */
		  if( !found )
		     Error_Message( _INSERT_CHAIN_RULES,MODULE_HIGH_OPTIM,
                                    NOT_FIND_ELEMENT,ABORT," cont_state");
                  if( direct_goto )
                     {
                       if( ! new_action )
                          if( IS_SHRED_NTACT( *((*search_ptr).rep.pt_rp+3) ) )
                             if( Proof_Join( ntab_red_paths,
                                             OPERAND( *((*search_ptr).
                                                      rep.pt_rp+3) ),
                                             *((*search_ptr).rep.pt_rp+2),
                                             extra_info ) )
                                new_action = *((*search_ptr).rep.pt_rp+3);
                             else
                                crp = count_redp;
                          else
                             new_action = *((*search_ptr).rep.pt_rp+3);
                       else
                          if( new_action != *((*search_ptr).rep.pt_rp+3) )
                             {
                               crp = count_redp;
                               new_action = 0;
                             } /* end of if( new_action... */
                     } /* end of if( direct... */
                  else
                     if( IS_SHRED_NTACT( *((*search_ptr).rep.pt_rp+3) ) )
                        {
                          if( Proof_Join( ntab_red_paths,
                                          OPERAND( *((*search_ptr).rep.pt_rp+3) ),
                                          *((*search_ptr).rep.pt_rp+2),
                                          extra_info ) )
                             {
                               change = TRUE;
		               redp[crp*2+3] = *((*search_ptr).rep.pt_rp+3);
                             }
                        }
                     else
                        {
                          change = TRUE;
		          redp[crp*2+3] = *((*search_ptr).rep.pt_rp+3);
                        }
	        } /* end of if( !(IS_ABS( (... */
	   } /* end of if( IS_SHRED_NT... */

        if( direct_goto && new_action )
           for( crp=0;crp<count_redp;crp++ )
	      redp[crp*2+3] = new_action;

        if( change  && (user_data->individual_reduce_code || !n_red) )
	   {       
             go_on = TRUE;
	     redp += 3;
	     count_redp--;
	     eq_test = *redp;
	     while( (count_redp > 0) && go_on )
	        {
		  count_redp--;
		  redp += 2;
		  if( (eq_test != *redp)        ||
		      (IS_SHRED_NTACT( *redp )) )
		     go_on = FALSE;
		} /* end of while( (count_r... */
             if( go_on )
                if( !(IS_DGD( help_ptr[pos].state ))             && 
                    !(IS_DGD_NOT_ALLOWED( help_ptr[pos].state )) )
		   help_ptr[pos].state = SET_DGD( help_ptr[pos].state );
           } /* end of if( change... */

     if( extra_info )
	printf("end of function Insert_Chain_Rules()\n");

   } /* end of function Insert_Chain_Rules() */






static struct ptrp *NTab_Chain_Rule_Elimination( quick_data,user_data,
                                                 red_paths_ntab,
						 extra_info )

   readtype         *quick_data;  /* interface vector to optimization      */
   struct user       *user_data;  /* structure which saves informations
				     fixed by the user                     */
   struct ptrp  *red_paths_ntab;  /* a representation of the reduction
				     paths of N - Table reduction sit-
				     uation                                */
   char     	     extra_info;  /* if extra_info == 1, then extra infor-
				     mation about begin and end of func-
				     tion is printed out                  */

/* This function searches for chain rules which have new reduction
   situations which appear as continuation states.  If this new reduction
   situation is a reduction of a new chain rule, control will be passed
   to function Join_Red_Paths, to join these two rules and if possible
   following chain rules too.
*/

   {
     short              nop,  /* number of productions                     */
		       prod,  /* loop index                                */
		      state,  /* loop index                                */
		 rhs_length,  /* length of the right hand side of a given
				 production                               */
		state_count,  /* saves the number of states in which a fix
				 rule will be reduced                      */
		  cont_prod,  /* The continuation state of the second chain
				 rule is a reduce entry too. Because it is
				 possible to call this function once again
				 we must save the entry.                   */
		      *redp;  /* pointer to the new reduction situation    */

     struct rp    *help_ptr;  /* pointer to the vector of states which
				 represent, together whith the corresponding
				 production, all reduction situations for
				 this production                           */



     if( extra_info )
	printf("begin of function NTab_Chain_Rule_Elimination()\n");
     nop = *((*quick_data)[5]);
     for( prod=0;prod<nop;prod++ )
	{
	  rhs_length  = (*quick_data)[7][prod];
	  if( !(IS_ABS( (*quick_data)[8][prod] )) && (rhs_length == 1) )
	      /* it's a chain rule */
	     {
	       help_ptr    = red_paths_ntab[prod].pointer;
	       state_count = red_paths_ntab[prod].number_of_states;
	       for( state=0;state<state_count;state++ )
		  {
                    redp = help_ptr[state].rep.pt_rp;

		    /* if the new state is a chain rule, with a new
		       reduction situation as continuation state, join
		       this both */
		    if( IS_SHRED_NTACT( redp[3] ) )
		       {
			 cont_prod = OPERAND( *(redp+3) );
			 if( !(IS_ABS( (*quick_data)[8][cont_prod] ))  &&
			     ((*quick_data)[7][cont_prod] == 1) &&
			     (cont_prod != prod) )
				{
				  Join_Red_Paths( quick_data,redp,
						  red_paths_ntab,
						  extra_info );
				} /* end of if( !(IS_ABS( (*... */
		       } /* end of if( IS_SHRED_... */
		  } /* end of for( state=0;st... */
	     } /* end of if( !(IS_ABS( (*... */
	} /* end of for( prod=0;pro... */


     for( prod=0;prod<nop;prod++ )
	{
	  help_ptr    = red_paths_ntab[prod].pointer;
	  state_count = red_paths_ntab[prod].number_of_states;
	  for( state=0;state<state_count;state++ )
	     Insert_Chain_Rules( quick_data,user_data,red_paths_ntab,
                                 help_ptr,state,1,extra_info );
	} /* end of for( prod=0;pro... */


     if( extra_info )
	printf("end of function NTab_Chain_Rule_Elimination()\n");
     return( red_paths_ntab );

   } /* end of function NTab_Chain_Rule_Elimination() */




static struct ptrp  *TTab_Chain_Rule_Elimination( quick_data,user_data,
                                                  ntab_red_paths,
						  ttab_red_paths,extra_info )


   readtype         *quick_data;  /* interface vector to optimization      */
   struct user       *user_data;  /* structure which saves informations
				     fixed by the user                     */
   struct ptrp  *ntab_red_paths,  /* a representation of the reduction
				     paths of N - Table reduction sit-
				     uations                               */
		*ttab_red_paths;  /* a representation of the reduction
				     paths of T - Table reduction sit-
				     uations                               */
   char     	     extra_info;  /* if extra_info == 1, then extra infor-
				     mations about begin and end of func-
				     tion are printed out                  */

/* If direct goto determination could apply to a T - table reduction
   situation and the continuation state is a new reduction situation, we
   test if this reduction situation is a chain rule reduction situation
   and join these two reduction paths.
*/


   {
     short              nop,  /* number of productions                     */
		       prod,  /* loop index                                */
		      state,  /* loop index                                */
		state_count;  /* saves the number of states in which a fix
				 rule will be reduced                      */
     struct rp    *help_ptr;  /* pointer to the vector of states which     */


     if( extra_info )
	printf("begin of function TTab_Chain_Rule_Elimination()\n");
     nop = *((*quick_data)[5]);
     for( prod=0;prod<nop;prod++ )
	{
	  help_ptr    = ttab_red_paths[prod].pointer;
	  state_count = ttab_red_paths[prod].number_of_states;
	  for( state=0;state<state_count;state++ )
	     if( !(IS_DEL( help_ptr[state].state )) )
		Insert_Chain_Rules( quick_data,user_data,ntab_red_paths,
                                    help_ptr,state,0,extra_info );
	} /* end of for( prod=0;pro... */

     if( extra_info )
	printf("end of function TTab_Chain_Rule_Elimination()\n");
     return( ttab_red_paths );

   } /* end of function TTab_Chain_Rule_Elimination() */






void High_Optim( quick_data,changed_data,user_data,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   struct user      *user_data;  /* structure which saves informations
				    fixed by the user                      */
   char    	    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of func-
				    tion is printed out                    */


/* This is the control function of the module High_Optim. It calls the
   other functions in the correct order and if TESTOPT is set, some
   information will be written on file High.wrt.
*/


   {
     short                  state,  /* loop index                          */
			      nos;  /* number of states                    */


     char               *min_push,  /* the push states are marked          */
			new_entry;  /* used to decide if a non push state
				       should become a push state          */
     struct inter_high     *paths;  /* interface vector between the module
				       Build_Paths and this module         */


#ifdef TESTOPT
     FILE                  *fp;  /* file pointer, used to write information
				    on external file                       */
     short                 nop,  /* number of productions                  */
			  prod,  /* loop index                             */
			   crp,  /* loop index                             */
			 *redp,  /* pointer to reduction paths             */
		    count_redp,  /* number of reduction paths of the
				    current reduction situation            */
		   state_count,  /* number of reduction situations of one
				    production                             */
			number;  /* variable which saves the amount of
				    printed information                    */
     struct rp    *help_prn_pt;  /* help pointer to read the information out
				    of internal data structure             */


     nop = *((*quick_data)[5]);
#endif

     if( extra_info )
	printf("begin of function High_Optim()\n");

     nos = *((*quick_data)[9]);


     if( ((min_push = (char*) calloc(
				nos,sizeof( char ) )) == NULL) ||
	 ((paths = (struct inter_high*) malloc(
			 sizeof( struct inter_high ) )) == NULL) )

	     Error_Message( _HIGH_OPTIM,MODULE_HIGH_OPTIM,NO_SPACE_FOR_STRUCTURE,
                            ABORT," paths");

     paths->ttred_paths  = NULL;
     paths->ttsred_paths = NULL;
     paths->ntred_paths  = NULL;
     paths->rv_ttab      = NULL;
     paths->rv_ntab      = NULL;






     (void) Build_Paths( quick_data,paths,extra_info );

     if( !user_data->high_before_low && user_data->lower_optimization )
	{
	  Eq_Red_Sit( quick_data,changed_data,paths->ttred_paths,extra_info );
	  Eq_Red_Sit( quick_data,changed_data,paths->ttsred_paths,extra_info );
	} /* end of if( !user_data-... */

     if( !user_data->min_push )
	for( state=0;state<nos;state++ )
	   min_push[state] = TRUE;

     if( user_data->direct_goto_determination || user_data->min_push )
	{
	  min_push = DGD_RR_MP_Opti( quick_data,user_data,paths->ttred_paths,
                                     paths->ntred_paths,min_push,0,extra_info );

	  min_push = DGD_RR_MP_Opti( quick_data,user_data,paths->ttsred_paths,
				     paths->ntred_paths,min_push,0,extra_info );

	  min_push = DGD_RR_MP_Opti( quick_data,user_data,paths->ntred_paths,
				     paths->ntred_paths,min_push,1,extra_info );
	} /* end of if( user_dat... */

     changed_data->min_push   = min_push;

     new_entry = TRUE;
     while( new_entry )
	{
	  new_entry = Pop_Count_Entry( paths->ttred_paths,quick_data,
				       min_push,changed_data,1,extra_info );

	  if( !new_entry )
	     new_entry = Pop_Count_Entry( paths->ttsred_paths,quick_data,
					  min_push,changed_data,1,extra_info );
	  if( !new_entry )
	     new_entry = Pop_Count_Entry( paths->ntred_paths,quick_data,
					  min_push,changed_data,0,
					  extra_info );
	} /* end of while( new_entry ) */

     if( user_data->chain_rule_elimination )
	{
	  paths->ntred_paths =
		   NTab_Chain_Rule_Elimination( quick_data,user_data,
						paths->ntred_paths,
						extra_info );

	  paths->ttred_paths =
		   TTab_Chain_Rule_Elimination( quick_data,user_data,
						paths->ntred_paths,
						paths->ttred_paths,
						extra_info );

	  paths->ttsred_paths =
		   TTab_Chain_Rule_Elimination( quick_data,user_data,
						paths->ntred_paths,
						paths->ttsred_paths,
						extra_info );

	} /* end of if( user_data->... */

     changed_data->ttred_paths  = paths->ttred_paths;
     changed_data->ttsred_paths = paths->ttsred_paths;
     changed_data->ntred_paths  = paths->ntred_paths;
     changed_data->min_push     = min_push;



#ifdef TESTOPT
   fp = fopen("HIGH.wrt","w");

	number = 1;
   fprintf(fp,"The minimal push states are :\n");
   fprintf(fp,"\n");
   for( state=0;state<nos;state++ )
      {
	if( min_push[state] )
	  if( number == 1 )
	     {
	       fprintf( fp,"%-4d",state );
	       number++;
	     } /* end of if( number == 1 ) */
	  else
	     {
	       fprintf( fp," , %-4d",state );
	       if( number < 11 )
		  number++;
	       else
		  {
		    fprintf(fp," ,\n");
		    number = 1;
		  } /* end of else ( if( number < 16 ) ) */
	       } /* end of else ( if( number < 1 ) ) */
      } /* end of for( state=0;st... */

   fprintf(fp,"\n\n\n");



   fprintf(fp,"The T - table reduction situations :\n");
   fprintf(fp,"( Only REDUCE - Situations )\n\n");
   for( prod=0;prod<nop;prod++ )
      for( state=0;state<paths->ttred_paths[prod].number_of_states;state++ )
	 {
	   help_prn_pt = paths->ttred_paths[prod].pointer;
	   fprintf(fp,"\n");
	   fprintf(fp,"production - number : %-4d           ",prod);
	   fprintf(fp,"   state - number : %-4d\n",
		   OPERAND( help_prn_pt[state].state ));
	   if( IS_SHIFT_SITUATION( help_prn_pt[state].state ) )
	      fprintf(fp,"old action          : shift/reduce %-4d ",prod);
	   else
	      fprintf(fp,"old action          : reduce %-4d       ",prod);
	   if( !(IS_DEL( help_prn_pt[state].state )) )
	      if( IS_DGD( help_prn_pt[state].state ) )
		 {
		   if( IS_SHRED_NTACT( *(help_prn_pt[state].rep.pt_rp+3) ) )
		      if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
			 fprintf(fp,"new action     : shift/reduce %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		      else
			 fprintf(fp,"new action     : reduce %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		   else
		      if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
			 fprintf(fp,"new action     : shift %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		      else
			 fprintf(fp,"new action     : goto %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		 } /* end of if( IS_DGD( hel... */
	      else
		 if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
		    fprintf(fp,"new action     : shift/reduce %-4d\n",prod);
		 else
		    fprintf(fp,"new action     : reduce %-4d\n",prod);
	   else
	      {
		fprintf(fp,"new action     : see state %d\n ",
			help_prn_pt[state].rep.rep_state );
		fprintf(fp,"					");
		fprintf(fp,"                 ( code is shared ! )\n" );
	      } /* end of else ( if( !(IS_DEL( h... ) */
	 } /* end of for( state=0;st... */


   fprintf(fp,"\n\n\n");
   fprintf(fp,"The T - table reduction situations :\n");
   fprintf(fp,"( Only SHIFT/REDUCE - Situations )\n\n");
   for( prod=0;prod<nop;prod++ )
      for( state=0;state<paths->ttsred_paths[prod].number_of_states;state++ )
	 {
	   help_prn_pt = paths->ttsred_paths[prod].pointer;
	   fprintf(fp,"\n");
	   fprintf(fp,"production - number : %-4d           ",prod);
	   fprintf(fp,"   state - number : %-4d\n",
		   OPERAND( help_prn_pt[state].state ));
	   if( IS_SHIFT_SITUATION( help_prn_pt[state].state ) )
	      fprintf(fp,"old action          : shift/reduce %-4d ",prod);
	   else
	      fprintf(fp,"old action          : reduce %-4d       ",prod);
	   if( !(IS_DEL( help_prn_pt[state].state )) )
	      if( IS_DGD( help_prn_pt[state].state ) )
		 {
		   if( IS_SHRED_NTACT( *(help_prn_pt[state].rep.pt_rp+3) ) )
		      if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
			 fprintf(fp,"new action     : shift/reduce %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		      else
			 fprintf(fp,"new action     : reduce %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		   else
		      if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
			 fprintf(fp,"new action     : shift %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		      else
			 fprintf(fp,"new action     : goto %-4d\n",
			       OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		 } /* end of if( IS_DGD( hel... */
	      else
		 if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
		    fprintf(fp,"new action     : shift/reduce %-4d\n",prod);
		 else
		    fprintf(fp,"new action     : reduce %-4d\n",prod);
	   else
	      {
		fprintf(fp,"new action     : see state %d\n ",
			help_prn_pt[state].rep.rep_state );
		fprintf(fp,"					");
		fprintf(fp,"                 ( code is shared ! )\n" );
	      } /* end of else ( if( !(IS_DEL( h... ) */
	 } /* end of for( state=0;st... */


   fprintf(fp,"\n\n\n");
   fprintf(fp,"The N - table reduction situations :\n");
   fprintf(fp,"\n");
   for( prod=0;prod<nop;prod++ )
      for( state=0;state<paths->ntred_paths[prod].number_of_states;state++ )
	 {
	   help_prn_pt = paths->ntred_paths[prod].pointer;
	   fprintf(fp,"\n");
	   fprintf(fp,"production - number : %-4d           ",prod);
	   fprintf(fp,"   state - number : %-4d\n",
		   OPERAND( help_prn_pt[state].state ));
	   if( IS_SHIFT_SITUATION( help_prn_pt[state].state ) )
	      fprintf(fp,"old action          : shift/reduce %-4d ",prod);
	   else
	      fprintf(fp,"old action          : reduce %-4d       ",prod);
	   if( IS_DGD( help_prn_pt[state].state ) )
	      {
		if( IS_SHRED_NTACT( *(help_prn_pt[state].rep.pt_rp+3) ) )
		   if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
		      fprintf(fp,"new action     : shift/reduce %-4d\n",
			      OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		   else
		      fprintf(fp,"new action     : reduce %-4d\n",
			      OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		else
		   if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
		      fprintf(fp,"new action     : shift %-4d\n",
			      OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
		   else
		      fprintf(fp,"new action     : goto %-4d\n",
			      OPERAND( *(help_prn_pt[state].rep.pt_rp+3) ));
	      } /* end of if( IS_DGD( he... */
	   else
	      if( IS_SHIFT_SITUATION(  help_prn_pt[state].state ) )
		 fprintf(fp,"new action     : shift/reduce %-4d\n",prod);
	      else
		 fprintf(fp,"new action     : reduce %-4d\n",prod);
	 } /* end of for( state=0;st... */


   fprintf(fp,"\n\n\n");
   if( !changed_data->number_of_pcc )
      fprintf(fp,"There exist no Pop - Count - Conflicts !\n");
   else
      fprintf(fp,"There exist %d Pop - Count - Conflicts !\n",
		changed_data->number_of_pcc);


   fprintf(fp,"\n\n\n\n\n\n");
   fprintf(fp,"The T - table reduction paths after higher %s",
	   ((!user_data->high_before_low) ? "and lower " : ""));
   fprintf(fp,"optimization \ntechnique%s applied:\n",
	   ((!user_data->high_before_low) ? "s" : "") );
   fprintf(fp,"( Only REDUCE - Situations )\n\n");
   fprintf(fp,"( origin state = x <--> direct goto determination ");
   fprintf(fp,"could apply ! )\n\n\n");
   for( prod=0;prod<nop;prod++ )
      {
	help_prn_pt = paths->ttred_paths[prod].pointer;
	state_count = paths->ttred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   if( !(IS_DEL( help_prn_pt[state].state )) )
	      {
		fprintf(fp,"In the reduction situation ");
		fprintf(fp,"( production %d x state %d )\n",
			prod,OPERAND( help_prn_pt[state].state ) );
		redp       = help_prn_pt[state].rep.pt_rp;
		fprintf(fp,"are %d push states on reduction paths.\n\n",
			   redp[1]);
		count_redp = *redp;
		for( crp=0;crp<count_redp;crp++ )
		   {
		     if( IS_DGD( help_prn_pt[state].state ) )
	                fprintf(fp,"origin state =    x " );
		     else
			fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		     if( IS_SHRED_NTACT( redp[crp*2+3] ) )
			fprintf(fp,"  continuation state = shift/reduce %-4d\n",
				    OPERAND( redp[crp*2+3] ) );
		     else
			fprintf(fp,"  continuation state = %-4d\n",
				OPERAND( redp[crp*2+3] ) );
		     if( IS_DGD( help_prn_pt[state].state ) )
                        crp = count_redp;
		   } /* end of for( crp=0;cr... */
		fprintf(fp,"\n\n");
	      } /* end of if( !(IS_DEL( h... */
      } /* end of for( prod=0;pro... */


   fprintf(fp,"\n\n\n\n\n\n");
   fprintf(fp,"The T - table reduction paths after higher %s",
	   ((!user_data->high_before_low) ? "and lower " : ""));
   fprintf(fp,"optimization \ntechnique%s applied:\n",
	   ((!user_data->high_before_low) ? "s" : "") );
   fprintf(fp,"( Only SHIFT/REDUCE - Situations )\n\n");
   fprintf(fp,"( origin state = x <--> direct goto determination ");
   fprintf(fp,"could apply ! \n");
   fprintf(fp,"( push = -1        <--> there exist a pop count ");
   fprintf(fp,"conflict ! )\n\n\n");
   for( prod=0;prod<nop;prod++ )
      {
	help_prn_pt = paths->ttsred_paths[prod].pointer;
	state_count = paths->ttsred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   if( !(IS_DEL( help_prn_pt[state].state )) )
	      {
		fprintf(fp,"In the reduction situation ");
		fprintf(fp,"( production %d x state %d )\n",
			prod,OPERAND( help_prn_pt[state].state ) );
		redp       = help_prn_pt[state].rep.pt_rp;
		fprintf(fp,"are %d push states on reduction paths.\n\n",
			   redp[1]);
		count_redp = *redp;
		for( crp=0;crp<count_redp;crp++ )
		   {
		     if( IS_DGD( help_prn_pt[state].state ) )
	                fprintf(fp,"origin state =    x " );
		     else
			fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		     if( IS_SHRED_NTACT( redp[crp*2+3] ) )
			fprintf(fp,"  continuation state = shift/reduce %-4d\n",
				    OPERAND( redp[crp*2+3] ) );
		     else
			fprintf(fp,"  continuation state = %-4d\n",
				OPERAND( redp[crp*2+3] ) );
		     if( IS_DGD( help_prn_pt[state].state ) )
                        crp = count_redp;
		   } /* end of for( crp=0;crp<... */
		fprintf(fp,"\n\n");
	      } /* end of if( !(IS_DEL( ... */
      } /* end of for( prod=0;pro... */

   fprintf(fp,"\n\n\n");
   fprintf(fp,"The N - table reduction paths after higher %s",
	   ((!user_data->high_before_low) ? "and lower " : ""));
   fprintf(fp,"optimization \ntechnique%s applied:\n",
	   ((!user_data->high_before_low) ? "s" : "") );
   fprintf(fp,"( origin state = x <--> direct goto determination ");
   fprintf(fp,"could apply ! \n");
   fprintf(fp,"( push = -1        <--> there exist a pop count ");
   fprintf(fp,"conflict ! )\n\n\n");
   for( prod=0;prod<nop;prod++ )
      {
	help_prn_pt = paths->ntred_paths[prod].pointer;
	state_count = paths->ntred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   if( !(IS_DEL( help_prn_pt[state].state )) )
	      {
		fprintf(fp,"In the reduction situation ");
		fprintf(fp,"( production %d x state %d )\n",
			prod,OPERAND( help_prn_pt[state].state ) );
		redp       = help_prn_pt[state].rep.pt_rp;
		fprintf(fp,"are %d push states on reduction paths.\n\n",
			   redp[1]);
		count_redp = *redp;
		for( crp=0;crp<count_redp;crp++ )
		   {
		     if( IS_DGD( help_prn_pt[state].state ) )
			fprintf(fp,"origin state =    x " );
		     else
			fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		     if( IS_SHRED_NTACT( redp[crp*2+3] ) )
			fprintf(fp,"  continuation state = shift/reduce %-4d\n",
				OPERAND( redp[crp*2+3] ) );
		     else
			fprintf(fp,"  continuation state = %-4d\n",
				OPERAND( redp[crp*2+3] ) );
		     if( IS_DGD( help_prn_pt[state].state ) )
                        crp = count_redp;
		   } /* end of for( crp=0;crp<... */
		fprintf(fp,"\n\n");
	      } /* end of if( !(IS_DEL( h... */
      } /* end of for( prod=0;pro... */


   fclose(fp);
#endif
   if( extra_info )
      printf("end of function High_Optim()\n");

   } /* end of function High_Optim() */




