/*
** $Id: ctx.h,v 1.2 90/10/23 13:35:29 cogito Exp $
*/

/***************************************************************************/
/* File: ctx.h		First Edit: 24.04.89	  Last Edit: 24.04.89      */
/*	 								   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: 25.04.89	From: Karl-Josef Prott			   */
/***************************************************************************/

/***************************************************************************/
/* The ctx-sets are used in "purdom.c" and "lalr.c". Therefore they are in */
/* an own module. For another programmer this module isn't interesting.    */
/* Note: There are not obvious dependencies with other modules.		   */
/***************************************************************************/



/* Typedefinitions of the data-structure representing the CTX-sets. */
  typedef struct ctx
    {
      Indextype		ntind;
      BitSet		set;
      struct ctx	*next;
    }  ctxtype;

typedef ctxtype		*SEQctxtype;
typedef SEQctxtype	*ARRSEQctxtype;


/* CTX is a dynamic array of SEQctxtype. Let ctx one element of CTX[X].
 * Then is: (ctx.ntind == Y  <==> X L* Y)  and (ctx.set == CTX(X,Y))
 */
extern	ARRSEQctxtype	CTX;


/* macros and functions for handling with 'SEQctx', where
 * (l: SEQctxtype, *el: ctxtype, result: SEQctxtype)
 */
#define initSEQctx()		((SEQctxtype)NULL)
#define emptySEQctx(l)		((l) == (SEQctxtype)NULL)
#define hdSEQctx(l)		(*l)	/* result: ctxtype */
#define tlSEQctx(l)		((l)->next)

extern	SEQctxtype	insSEQctx(/* SEQctxtype list; ctxtype *el */);
extern	ctxtype		*mkctx(/* Indextype ntind; BitSet set */);
extern	void		FreeARRSEQctx(/* ARRSEQctxtype arrctx */);


/* return == arr(A,B), if existing in array 'arr'
 *	  == (BitSet)NULL, if not existing in array 'arr'
 * ( for example: CTX(A,B) if called with CTX as 'arr' )
 */
extern	BitSet	GetValueSet(/* ARRSEQctxtype arrctx; Indextype A, B */);

/* 'ComputeCTX()' computes the CTX-sets in global variable 'CTX' */
extern	void	ComputeCTX(/* Indextype epsind */);
