/*
** $Id: lalr1tst.h,v 1.2 90/10/23 13:36:00 cogito Exp $
*/

/***************************************************************************/
/* File: lalr1tst.h	First Edit: 16.03.89	  Last Edit: 20.03.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: 31.03.89	From: Karl-Josef Prott			   */
/***************************************************************************/


#ifndef lalr1tst_DEF
#define lalr1tst_DEF

#include	"parserlib.h"	/* for typedefinitons */
#include	"cmrlib.h"

/***************************************************************************/
/* Imported variables, which MUST(!) be initialized before 		   */
/*					executing 'cmrtl_lalr1tst()'.      */
/***************************************************************************/

/* global variables defined in "cmrlib" */
extern	Indextype	MAXTERM;  /* init. by cmrlib_compute_globarrs() */
extern	ARRIndextype	INDEX;
extern	ARRdef_entry	DEFTBL;

/* 'CMR' will be used by 'cmrtl_lalr1tst()' but needn't be init. before */
extern	p_comar	CMR;		  /* init. by cmrlib_changeglobalcmrvar() */


/* global variable defined in "parserlib" */
extern	unsigned short	MAXSTATE;	/* number of states */


/* The following variables must NOT be initalized. */

/* global variables defined in "parserlib" */
extern	ARRSEQconflicttype	CONFLICTSTATES;
extern	Boolean			ISLALR1;
extern	SEQmodiftype		MODIFICATIONS;



/***************************************************************************/
/* Exported errorcode and function:					   */
/***************************************************************************/


/* errorcodes */
#define	ISNOTLALR1	-49	/* Grammar of the automaton 'automat' is */
				/* not LALR(1) - 'automat' is nondeterm. */


/* return == CMR_SUCCESS, if automat represents a LALR(1)-automaton
 *	  == ISNOTLALR1	, otherwise
 * Note: if 'info', further information about conflict-states,if existing,
 *	 will be computed and stored in CONFLICTSTATES of "parserlib"
 */
extern ERR cmrtl_lalr1tst(/*p_comar c; ARRstatetype automat; Boolean info*/);

#endif  /* of lalr1tst_DEF */


