/*
** $Id: privatlib.h,v 1.3 91/05/22 16:59:33 cogito Exp $
*/

/***************************************************************************/
/* File: privatlib.h	First Edit: 17.10.88	  Last Edit: 22.02.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/***************************************************************************/


#ifndef	privlib_DEF
#define privlib_DEF

/*********************************************************************/
/* TABLE OF CONTENTS :                                  	     */
/*	SECTION 1 : constant-definitions			     */
/*	SECTION 2 : variable-definitions                             */
/*	SECTION 3 : macros                                           */
/*	    3.1   : macros for general use			     */
/*	    3.2   : additions to the IDL-macros generated to "comar.idl" */
/*	SECTION 4 : "extern"-declarations of functions               */
/*					    implemented in privatlib.c */
/*********************************************************************/

/*********************************************************************/
/* SECTION 1 : constant-definitions                                  */
/*********************************************************************/

/* Maximal length of filenames */
#define MAXNAMLEN	80


/*********************************************************************/
/* SECTION 2  : variable-definitions                                 */
/*********************************************************************/


/*********************************************************************/
/* SECTION 3 : macros                                                */
/*********************************************************************/

/* SECTION 3.1: macros for general use				     */

#define strequal(a,b)  (!(strcmp(a,b)))

#define INT_ERR(str)	(void)fprintf(stderr,"Internal error in %s\n",str)

#define INT_TAG_ERR(str,tg)	(void)fprintf(stderr,\
		"Internal error in %s: wrong tag: %d\n",\
		str, tg)

#define INT_ALLOC_ERR(str)	(void)fprintf(stderr,\
		"Fatal error in %s: no allocation possible!\n", str)


/* SECTION 3.2: additions to the IDL-macros generated to "comar.idl" */

#define manipulSEQsymb_entry(symbseq,formanipul,elem)  for\
	    (formanipul = &symbseq;\
	     *formanipul != NULL &&\
                ((elem.IDLinternal = (*formanipul)->value.IDLinternal)||1);\
	     formanipul = &(*formanipul)->next   )

#define manipulSEQdef_entry(defseq,formanipul,elem)  for\
	    (formanipul = &defseq;\
	     *formanipul != NULL &&\
                ((elem.IDLinternal = (*formanipul)->value.IDLinternal)||1);\
	     formanipul = &(*formanipul)->next   )

#define manipulSEQprop_entry(propseq,formanipul,elem)  for\
	    (formanipul = &propseq;\
	     *formanipul != NULL &&\
                ((elem.IDLinternal = (*formanipul)->value.IDLinternal)||1);\
	     formanipul = &(*formanipul)->next   )

#define manipulSEQunit(unitseq,formanipul,elem)  for\
	    (formanipul = &unitseq;\
	     *formanipul != NULL &&\
                ((elem.IDLinternal = (*formanipul)->value.IDLinternal)||1);\
	     formanipul = &(*formanipul)->next   )

#define manipulSEQvalue(valseq,formanipul,elem)  for\
	    (formanipul = &valseq;\
	     *formanipul != NULL &&\
                ((elem.IDLinternal = (*formanipul)->value.IDLinternal)||1);\
	     formanipul = &(*formanipul)->next   )


/* SECTION 3.3: macros using functions of "cmrlib" or "privatlib" */

#define priv_deftostr(def)	(priv_sidtostr(def.IDLclassCommon->sid))
#define priv_proptostr(prop)	(priv_sidtostr(prop.IDLclassCommon->sid))


/*********************************************************************/
/* SECTION 4 : "extern"-declarations of functions                    */
/*					    implemented in privatlib.c */
/*********************************************************************/

extern	void	priv_generrstr(/* ERR code, String name */);

extern	String	priv_genfilename(/* String  name, ext */);

extern	String	priv_sidtostr(/* SID sid */);

extern	void	priv_printdefseq(/* SEQdef_entry d_seq */);

extern	void	priv_print_rhsdid(/* SEQdef_entry d_seq, FILE *f */);

/*********************************************************************/
/* SECTION 5 : ADT "stack" for elemets with                          */
/*			   sizeof("elements") <= sizeof("pointer")   */
/*********************************************************************/

/* generic type of stack-elements: use cast-operator for type-conversion! */
typedef char	*eltype;

/* typedefinition for stack-variables */
typedef struct sttype
	{
	  eltype	val;
	  struct sttype	*next;
	}	*stacktype;


#define create(stack)	( stack = (stacktype)NULL )
#define top(stack)	( stack->val )
#define empty(stack)	( stack == (stacktype)NULL )

extern	stacktype push(/* stacktype stack, eltype el */);
extern	stacktype pop(/* stacktype stack */);
extern	Boolean	  isin(/* stacktype stack, eltype el */);


#endif		/* of privlib_DEF */
