/*
** $Id: purdom.h,v 1.3 91/02/11 15:21:21 cogito Exp Locker: cogito $
*/

/***************************************************************************/
/* File: purdom.h	First Edit: 19.04.89	  Last Edit: 26.04.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: ??.04.89	From: Karl-Josef Prott			   */
/***************************************************************************/


#ifndef purdom_DEF
#define purdom_DEF

/***************************************************************************/
/* Imported variables, which MUST(!) be initialized before 		   */
/*					executing 'cmrtl_purdom()'.        */
/***************************************************************************/


/* global variables defined in "cmrlib" */
extern	SEQdef_entry	PROD_SEQ; /* initialized by cmrlib_arrangedefs() */

extern	Indextype	MAXTERM;  /* init. by cmrlib_compute_globarrs() */
extern	Indextype	MAXPROD;
extern	ARRIndextype	INDEX;
extern	ARRSEQdef_entry	PRODWITHLHS;
extern	ARRdef_entry	DEFTBL;

extern	p_comar	CMR;		  /* init. by cmrlib_changeglobalcmrvar() */

/* global variable defined in "lr0" */
extern	unsigned short	MAXSTATE;  /* init. by cmrtl_compute_LR0automat() */
extern	unsigned short	MAXITEMNO;

/* global variable defined in "firstset" */
extern	ARRBitSet	FIRSTSETS;	/* init. by computeFIRSTSETS() */


/***************************************************************************/
/* Exported errorcode and function:					   */
/***************************************************************************/

/* CONTINGENT and FORBIDDEN are names of OTHER-objects inserted by
 * cmrtl_purdom() in the definition-table and the right side of productions.
 * Don't insert connections into grammar-positions marked as FORBIDDEN
 * and avoid it in positions marked as CONTINGENT. The first one will
 * destroy the LALR(1)-property surely and the second one very often.
 */
#ifndef CONTINGENT
#define	CONTINGENT	"_CONTINGENT"
#define	FORBIDDEN	"_FORBIDDEN"
#endif

/* errorcodes */
#define	LALR_AMBEPS	-46	/* The same as in "lalr.h" */


extern	ERR	cmrtl_purdom(/* p_comar c; ARRstatetype autom */);

#endif  /* of purdom_DEF */

