/*
** $Id: ccomario.h,v 1.2 90/10/23 11:36:42 cogito Exp $
*/

/* ccomario.h - header for COMAR reader, writer and formatter routines 
 *
 *	Author: Karl Prott
 *		University of Paderborn
 */

#ifndef ccomario_DEF
#define ccomario_DEF


/* Maximum tool information line length (first line) */
#define MAX_TOOL_INFO 127


/* exported routines: */

/* cmrio-write - write ASCII comar representation of COMAR structure t
 *	entry:	*f is open for writing.
 *		*tool_info does not contain '\n'.
 *		*c == an initialized COMAR internal structure
 *	exit:	(cmrio_write == CMR_SUCCESS) ==> 
 *		    *tool_info has been written to *f followed by '\n',
 *		    followed by the ASCII representation of *c.
 *		else a write error has occurred.
 */
extern int cmrio_write( /* FILE *f; char *tool_info; p_comar c */ );


/* cmrio-read - read ASCII comar representation into new COMAR structure
 *	entry:	*name == name of external COMAR file.
 *		tool_info addresses a buffer with length >= MAX_TOOL_INFO
 *		c addresses an new, empty COMAR specification.
 *	exit:	(cmrio_read == CMR_SUCCESS) ==> 
 *		    *c == COMAR structure containing the internal
 *		     representation for the contents of file *name.
 *		    *tool_info == the first line from that file, containing
 *		     tool-specific information.
 *		else an I/O error has occurred.
 */
extern int cmrio_read( /* char *name; char *tool_info; p_comar c */ );


#endif !ccomario_DEF
