/*
** $Id: equality.h,v 1.2 90/10/23 14:40:52 cogito Exp $
*/

#include "old_to_newcmr.h"

/**********************************************************************/
/*       Functions for finding equivalences in the grammar            */
/*              and especially in production trees                    */
/**********************************************************************/


/* cmrl_equal_list - returns TRUE iff list1 and list2 are structural equal
 * on entry:
 *
 */
extern boolean cmrl_equal_list( /* tCOMAR *c, *list1, *list2,
				   tCOMAR *stack, tCOMAR **equals */ );

/* cmrl_equal_subtr - returns TRUE iff l1 and l2 are structural equal
 * on entry: l1 and l2 are subtrees of productions
 *           stack ( on first call: cmr_new_list())
 * on exit : TRUE iff subtrees l1 and l2 are structural equal
 *           FALSE otherwise
 */
extern boolean cmrl_equal_subtr( /* tCOMAR *c, tCOMAR *l1, tCOMAR *l2,
				    tCOMAR *stack, tCOMAR **equals */ );


/* cmrl_equal_nterms - returns TRUE iff did1 and did2 are equal
 *                                          or structural equal
 * on entry: did1 and did2 are equal or they are different nonterminals
 *           stack
 * on exit:  TRUE iff did1 == did2
 *                or did1 and did2 will already be compared
 *                   or they produce structural equal right hand sides
 *           FALSE otherwise
 */
extern boolean cmrl_equal_nterms( /* tCOMAR *c, DID did1, DID did2,
				     tCOMAR *stack, tCOMAR **equals */ );

/* cmrl_equal_nterms_elim - removes given structural equal nterms from
 *                          the grammar
 * on entry : a list equals constructed by cmrl_equal_XXX with pairs
 *              of structural equal nonterminals
 *            DID nosubst one nonterminal that should not be substituted 
 *                   by an other
 * on exit : CMR_SUCCESS if no error occurs
 *             else errorcode
 */
extern int cmrl_equal_nterms_elim( /* tCOMAR *c, tCOMAR *equals, 
				      DID nosubst  */ );

/* cmrl_equal_nt_replace - replaces nt1 by nt2 and removes nt2 from grammar
 * on entry : database c
 *            nonterminals nt1 and nt2
 * on exit  : nt2 is replaced by nt1 in all grammar rules and
 *               in all properties and all productions for
 *               nt2 are deleted
 *            returns CMR_SUCCESS if no error occurs
 *              else an errorcode
 */
extern int cmrl_equal_nt_replace( /* tCOMAR *c, DID nt1, DID nt2 */ );
