/*
** $Id: propoutp.h,v 1.2 90/10/23 14:43:51 cogito Exp $
*/

#include "old_to_newcmr.h"

/* Module for writing properties in a human readable form
 * to a File.
 *
 * N O T E :
 * By setting the compiler option
 *            SINGLE
 * each member of a property will be written to a new line
 */

#define CMRTL_WRTPROPERR -40

/* all functions return CMR_SUCCESS or an errorcode */

/* cmrtl_write_property - writes the specified property sid
 *                        for the specified did to a file
 * on entry  : filepointer *f, 
 *             datastructure c,
 *             DEFTAB index did
 *             property-specification sid
 * on exit   : writes strings for did and sid to stdout
 *             if property has tagkind P_PROP_VAL
 *               then this subtree is written to stdout too
 */
extern int cmrtl_write_property( /* FILE *f, tCOMAR *c, DID did,
				    SID sid */ );

/* the next two functions have to be called with a parameter l, that
 * indicates the space left from the left margin for formatted output
 */

/* cmrtl_write_prop_tree - writes property-subtree to a file
 * on entry  : filepointer *f, 
 *             datastructure c, 
 *             property-subtree tree
 * on exit   : writes the strings, symbols or tagkind-equivalent
 *             symbols to FILE f
 */
extern int cmrtl_write_prop_tree( /* FILE *f, tCOMAR *c,
				     tCOMAR *tree, int l */ );


/* cmrtl_write_prop_list - writes property-list to a file 
 * on entry  : datastructure c,
 *             property-list list
 * on exit   : if list is empty 
 *               then a closing bracket is written
 *               else the subtree of list-head and 
 *                    the list-tail are written to FILE f 
 */
extern int cmrtl_write_prop_list( /* FILE *f, tCOMAR *c,
				     tCOMAR *list, int l */ );

