
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGIdent *_PPTGIdent;
struct _SPTGIdent{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGInt *_PPTGInt;
struct _SPTGInt{
  _PTGProc _print;
  int _t0;
};

void _PrPTGAxiom(n)
_PPTG4 n;
{
  fputs ("$CODE\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("$GRAMMAR\n<$START_SYMBOL>: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

void _PrPTGCoding(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
}

void _PrPTGProd(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n\t", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
}

void _PrPTGStkProd(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n\t", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" &'SourceLeaf(ZAttributKeller);' .\n", f);
}

void _PrPTGSepList(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" // ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGAlt(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" / ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGAltNull(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" / ", f);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGConnect(n)
_PPTG1 n;
{
  fputs ("&", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGAtMod(n)
_PPTG1 n;
{
  fputs ("@", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGDolMod(n)
_PPTG1 n;
{
  fputs ("$", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGOpt(n)
_PPTG1 n;
{
  fputs ("[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]", f);
}

void _PrPTGGroup(n)
_PPTG1 n;
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGPlus(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("+", f);
}

void _PrPTGStar(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("*", f);
}

void _PrPTGStack(n)
_PPTG1 n;
{
  fputs ("'", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("'", f);
}

extern void OutSym();

void _PrPTGIdent(n)
_PPTGIdent n;
{
OutSym(f,n->_t0);
}

void _PrPTGInt(n)
_PPTGInt n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGEof(n)
_PPTG0 n;
{
  fputs ("EOF", f);
}

void _PrPTGLines(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

PTGNode PTGAxiom(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGAxiom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGCoding(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGCoding;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGProd(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGProd;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGStkProd(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGStkProd;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSepList(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSepList;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGAlt(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGAlt;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGAltNull(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGAltNull;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGConnect(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGConnect;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAtMod(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGAtMod;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGDolMod(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGDolMod;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGOpt(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGOpt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGGroup(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGGroup;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPlus(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPlus;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGStar(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStar;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGStack(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStack;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGIdent(_t0)
  int _t0;
{
  _PPTGIdent n;

  if ((n = (_PPTGIdent) malloc (sizeof (struct _SPTGIdent)))  ==  (_PPTGIdent)NULL)
	MEMERR
  n->_print = _PrPTGIdent;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGInt(_t0)
  int _t0;
{
  _PPTGInt n;

  if ((n = (_PPTGInt) malloc (sizeof (struct _SPTGInt)))  ==  (_PPTGInt)NULL)
	MEMERR
  n->_print = _PrPTGInt;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGEof()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGEof;
  return ((PTGNode) n);
}

PTGNode PTGLines(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGLines;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

