# $Id: Makefile.cpp,v 1.5 1992/06/24 23:28:19 waite Exp $
# Digit calculator example

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

SPECS	= digit.con expr.c expr.con expr.specs
EXTRAS	= derive input result

TIDY	= ERRS a.out core *.o *.a ELI pcode
CLEAN	= $(TIDY) *.exe src

all:	ELI $(SPECS) $(EXTRAS) src
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <derive); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <derive); \
	fi
	cd src; make; ./*.exe ../input >result
	diff result src/result

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/digitcalc ; \
		rm -f $(DESTDIR)/Tool/examples/digitcalc/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/digitcalc ; \
		chmod 644 $(DESTDIR)/Tool/examples/digitcalc/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi

src:
	mkdir src
