# $Id: Makefile.cpp,v 1.11 1991/09/04 13:00:50 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

CFLAGS	= -I../csm
COFLAGS	= -q

SYS	= fpt.specs fpt.c fpt.h

TIDY	= core a.out *.o
CLEAN	= $(TIDY)
CLOBBER	= $(CLEAN) Makefile

all:	$(SYS)

.PRECIOUS:	$(SYS)

install:
	@for f in $(SYS); do \
		echo install -m 644 $$f $(DESTDIR)/Tool/fpt; \
		rm -f $(DESTDIR)/Tool/fpt/$$f; \
		cp $$f $(DESTDIR)/Tool/fpt/$$f; \
		chmod 644 $(DESTDIR)/Tool/fpt/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr: $(SYS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SYS) Makefile.cpp
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SYS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SYS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SYS)
