%token T2 2
%token T3 3
%token T4 4
%token T6 6
%token T7 7
%token T8 8
%token T9 9
%token T10 10
%token T11 11
%token T12 12
%token T5 5
%token T13 13
%token T14 14
%token T15 15
%{
static char xxRCSID[]= "$Id: parser.y,v 1.6 1992/07/31 14:57:34 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */
#include "err.h"	/* To define "POSITION" */
#include "csm.h"	/* To define "string" */
#include "can.h"	/* To define "string" */
#include "dj.h"

int EofCode = 0;        /* assume this is returned on EOF */

int	NonLitCount;    /* number of non-literal patterns */
int	LitCount;       /* number of literal patterns */
int	NTokens;        /* sum of LitCount and NonLitCount */

int Index= 0;           /* index into Y arrays below */
char *YauxScanner[MAXLITS+MAXNONLITS];
char *Yprocessor[MAXLITS+MAXNONLITS];
char *Ypattern[MAXLITS+MAXNONLITS];
short YextCode[MAXLITS+MAXNONLITS];
short YinLine[MAXLITS+MAXNONLITS];
/* Reverse index, from symbol, to Y entries.
** Used to match Idns of encodings w/ Labels of non-literal descriptions */
short YXsymtab[MAXLITS+MAXNONLITS];

extern char *TokenStart, *TokenEnd;
extern int ParseErr;

struct leaf {		/* Information about terminals */
	POSITION loc;		/* Source text coordinates */
	int attribute;		/* Intrinsic attribute */
	};
%}
%union {
	struct leaf leaf;
}
%token <leaf> T2 T4 T3
%type <leaf> value
%%
spec		: nonLitDescs options encodings wrap;

nonLitDescs	: nonLitDescs nonLitDesc 
		| /* empty */ 
		;

options		: options option ;
		| option {NonLitCount = Index; Index=1; }
		;

encodings	: encodings encoding 
		| /* empty */ 
		;
wrap		:
		  {	/* compute NTokens, make Y arrays consecutive */
		  int i;
		  LitCount = Index-1;
		  NTokens = LitCount + NonLitCount;
		  /* copy non-lits to consecutive Y locations */
		  for(i=0; i<NonLitCount; i++){
			Ypattern[LitCount+i+1] = Ypattern[MAXLITS+i];
			YextCode[LitCount+i+1] = YextCode[MAXLITS+i];
			YinLine[LitCount+i+1] = YinLine[MAXLITS+i];
			Yprocessor[LitCount+i+1] = Yprocessor[MAXLITS+i];
			YauxScanner[LitCount+i+1] = YauxScanner[MAXLITS+i];
			}

		  }


encoding	: T4 value {
					/* get rid of leading $ by adding 1 */
			Ypattern[Index] =  string[$1.attribute]+1;
			YextCode[Index] =  $2.attribute;
			YinLine[Index] =  $1.loc.line;
			Index++;
			if(Index >= MAXLITS){
				printf("Fatal: %d encodings\n", Index);
				exit(5);
				}
			if( $2.attribute == NORETURN)
				printf("Warning, code %d used internally\n",
						NORETURN);
			}
		| T2 value {
			if($1.attribute >= MAXLITS+MAXNONLITS){
				printf("Fatal: %d out of range\n", $1.attribute);
				exit(5);
				}
			if( YXsymtab[$1.attribute]== 0){
				printf("Fatal: Identifier (%s) not set\n",
						string[$1.attribute]);
				exit(5);
				}
			YextCode[YXsymtab[$1.attribute]] =  $2.attribute;
			if( $2.attribute == NORETURN)
				printf("Warning, code %d used internally\n",
						NORETURN);
			}
		;

option		: T5
		| T13 value {EofCode = $2.attribute; }
		| T14 value { $2.attribute; }
		| T15
		;

nonLitDesc	: T2 T10 rest
			{
			YXsymtab[$1.attribute] = Index+MAXLITS;
			if(++Index >= MAXNONLITS){
				printf("Fatal: %d non-literals\n", Index);
				exit(5);
				}
			}
		| value T10 rest
			{
			YextCode[Index+MAXLITS] = $1.attribute;
			if(++Index >= MAXNONLITS){
				printf("Fatal: %d non-literals\n", Index);
				exit(5);
				}
			}
		| rest
			{
			if(++Index >= MAXNONLITS){
				printf("Fatal: %d non-literals\n", Index);
				exit(5);
				}
			}
		;
rest		: T4 optAuxScanner optProcessor
			{
					/* get rid of leading $ by adding 1 */
			Ypattern[Index+MAXLITS] = string[$1.attribute]+1;
			YinLine[Index+MAXLITS] =  $1.loc.line;
			}
		| librRef optAuxScanner optProcessor
		;

librRef		: T2 {
			int i;
			i = libLookup( string[$1.attribute]);
			if(i<0)
				{
				ParseErr = 1;
				message(ERROR,"No such canned description", 0, &$1.loc);
				}
			else	{
				Ypattern[Index+MAXLITS] =  lib[i].Lpattern;
				YauxScanner[Index+MAXLITS]=lib[i].Lscanner;
				Yprocessor[Index+MAXLITS]= lib[i].Lprocessor;
				YinLine[Index+MAXLITS] =  $1.loc.line;
				}
			}
		;
				
optAuxScanner	:  /* empty */
		| T6 T2 T7 {YauxScanner[Index+MAXLITS]= string[$2.attribute];}
		;
optProcessor	: /* empty */
		| T11 T2 T12 { Yprocessor[Index+MAXLITS]= string[$2.attribute];}
		;
value		: T3 { $$ = $1; }
		| T8 T3 { $$ = $2;}
		| T9 T3 {$$.loc = $2.loc;$$.attribute = - $2.attribute;}
%%

int yylex()
{
	int code;
	code = glalex((char *)&yylval.leaf.attribute);
	yylval.leaf.loc = curpos;
	return(code);
}

/*
The job of the parser is to construct the Y arrays
from a GLA spec.  There are several complicating
factors.  Library references cause some indirection.
Non-literal specs have their encodings in different
places from their patterns.
Finally, GLA has non-literals first, and
encodings second (both literal and non-literal).
FLEX does not distinguish between lits and non-lits,
but lits must come FIRST, and non-lits SECOND.
This is because we want ambiguous tokens to be
considered literals!  Eg,:
	"begin"		{return token for begin}
	[a-z]+		{return token for identifier}
If the order were reversed in a FLEX spec, the
wrong behaviour would occur.
.lp
We want Y arrays consecutive, literals followed by
non-literals but the GLA spec has things in the
opposite order.  Solution:  Collect the non-litterals
in the upper part of the Y arrays, reset Index,
store literals where they belong, finally copy
down the non-literals.

*/
