#!/bin/sh
# $Id: kw.exe.cmd.cpp,v 1.3 1992/08/06 20:20:49 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

# kw.exe 'Keyword recognizer'* :
# 	USER
# 		: backend_data
# 		: flex_binary
# 		: accept_binary
# 		: lastdfa_binary

umask 0
cd (|<RUNDIR|)

(|$/Tool/gla/gla_be|) $ptokens (|<backend_data|) (|<lastdfa_binary|) \
	(|<accept_binary|) (|<flex_binary|) 1>/dev/null 2>ERRORS
if test -s ERRORS
then
	# default error handling, for now
	cp ERRORS (|>ERROR|)
	exit 0
fi

#ifdef _AIX
CCPROG=${ELI_CC-"cc -qlanglvl=ansi"}
#else
CCPROG=${ELI_CC-cc}
#endif

$CCPROG -o (|>kw.exe|) -I. -I(|$/Tool/kwd|) -I(|$/Tool/source|) \
		(|$/Tool/kwd/kwd.c|) \
		(|$/Tool/kwd/match.c|) \
		(|$/Tool/source/source.c|) \
	>/dev/null 2>ERRORS

if test -s ERRORS
then
	# Error formats:
	# cc:  "fred.c", line 9: an error message
	# gcc: fred.c:9: an error message
	# Remove extra gcc messages
	sed -e '/^In file included from /d
		/: At top level/d
		/: In function /d
		/: (Each undeclared identifier/d
		/: for each function/d
		/^[^:]*:$/d
		s/^\([^:]*\): *\([0-9]*\):/\1 \2 0/
		s/^"\([^"]*\)". line \([0-9]*\):/\1 \2 0/
		s;^\.\/;;
		/arning/{
			s/.arning: //w (|>WARNING|)
			d
		}' ERRORS >(|>ERROR|)
fi

exit 0
