# $Id: src.Frames.Makefile.cpp,v 1.7 1992/07/22 11:37:35 cogito Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# hack for Sun auto-mounter
PWD	= pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR	= `expr \`$(PWD)\`'/' : '\(.*[^/]\)/[^/]*/[^/]*/'`

DISTRIB = /tmp
COFLAGS = -q

SKEL    = dfltattr.c treecon.h attrpredef.h gsdescr.h attrmain.c treestack.h \
	treestack.c Gorto.ad # SourceNodeHead SourceNodeTail BIG.h 
AUX	= 
RCS	= $(SKEL) $(AUX)

TIDY    = core a.out  *% lintmsg *.p *.o ERRS
CLEAN   = $(TIDY) *.exe
CLOBBER = $(CLEAN) Makefile

all:	$(SKEL) $(AUX)

install:
	@for f in $(SKEL); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/liga/Frames; \
		rm -f $(DESTDIR)/Tool/liga/Frames/$$f; \
		cp $$f $(DESTDIR)/Tool/liga/Frames; \
		chmod 644 $(DESTDIR)/Tool/liga/Frames/$$f; \
	done

executable:
	rm -rf Makefile Makefile.cpp

SourceDistr: $(SKEL) $(AUX)

distrib:	$(SKEL) $(AUX)
	- rm -rf $(DISTRIB)/Frames
	mkdir $(DISTRIB)/Frames
	cp $(SKEL) $(AUX) Makefile.cpp $(DISTRIB)/Frames
	cd $(DISTRIB)/Frames; chmod 0644 $(SKEL) $(AUX) Makefile.cpp 

checkout:
	co $(COFLAGS) $(RCS)
	
# Cleaning Targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -f $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(SKEL) $(AUX) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp README $(SKEL) $(AUX) \
		$(CMD)
	-rcs -bOriginal.1 -q Makefile.cpp README $(SKEL) $(AUX)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q README $(SKEL) $(AUX)

.PRECIOUS:	$(SKEL) $(AUX)



