# $Id: src.backend.Makefile.cpp,v 3.2 1992/03/05 17:10:47 uwe Exp $
# 
# Makefile of the directory backend
# 
CC	= cc -g

SHELL	= /bin/sh

IDL	= ../idl
LIGASCEL= ../ligascel
ERR	= ../ligascel
OPTHANDLER= ../option

DISTRIB = /tmp

SOURCES	= BackNames.c         attrdecl.c      expr.c          incl.c \
	OutStr.c        backvisit.c     globdefs.c      ligaback.c \
	attr.c          csm.c           idn.c           backptg_gen.c

EXTINCL = $(OPTHANDLER)/opt_input.h \
        $(OPTHANDLER)/option_enums.h \
        $(OPTHANDLER)/option_types.h

INCL	= BackNames.h         backvisit.h     expr.h          idntbl.h \
	OutStr.h        bool.h          incl.h \
	attr.h          csm.h           globdefs.h      ligaback.h \
	attrdecl.h      csmtbl.h        idn.h           backptg_gen.h

# compiler options
CFLAGS	= -I$(IDL) -I$(OPTHANDLER) -I$(LIGASCEL)
COFLAGS	= -q

# objects
EXTOBJ  = $(IDL)/lookup_idl.o \
        $(IDL)/IDL.a \
        $(OPTHANDLER)/opt_input.o \
	$(ERR)/err.o \
	$(ERR)/source.o

OBJ	= BackNames.o         attrdecl.o      expr.o          incl.o \
	OutStr.o        backvisit.o     globdefs.o      ligaback.o \
	attr.o          csm.o           idn.o           backptg_gen.o

TIDY	= core *.o a.out
CLEAN	= $(TIDY) order ../ligaBack.exe
CLOBBER	= $(CLEAN) Makefile
RCS	= $(SOURCES) $(INCL) back.ptg backliga.ptg back.specs

# generates the executable order

all:	../ligaBack.exe

../ligaBack.exe: $(OBJ) $(EXTOBJ)
	$(CC) $(CFLAGS) $(OBJ) $(EXTOBJ) -o ../ligaBack.exe

# checkout

checkout:
	co $(COFLAGS) $(RCS)
	co $(COFLAGS) src.backend.README; mv src.backend.README README

# installation

install:	../ligaBack.exe
	rm -f $(DESTDIR)/Tool/liga/ligaBack.exe
	cp ../ligaBack.exe $(DESTDIR)/Tool/liga/ligaBack.exe
	chmod 755 $(DESTDIR)/Tool/liga/ligaBack.exe

# distribution
 
distrib:	$(SOURCES) $(INCL) Makefile.cpp
	- rm -rf $(DISTRIB)/backend
	mkdir $(DISTRIB)/backend
	cp $(SOURCES) $(INCL) Makefile.cpp $(DISTRIB)/backend
	cd $(DISTRIB)/backend; chmod 0644 $(SOURCES) $(INCL) Makefile.cpp

# SourceDistr

SourceDistr: $(SOURCES) $(INCL) Makefile.cpp

# cleaning targets

.PHONY:		tidy clean rcsclean clobber

tidy:
		rm -rf $(TIDY)

clean:
		rm -rf $(CLEAN)

clobber:
		rm -rf $(CLOBBER)

rcsclean:
		rm -rf $(CLEAN) Makefile
		-rcsclean $(COFLAGS) $(RCS) Makefile.cpp

save:
		-mkdir RCS
		-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
		-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
		-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
		-ci -fOriginal.1 -m/dev/null -q $(RCS)


attr.o: $(IDL)/global.h $(IDL)/lookup_idl.h $(IDL)/LIGA.h \
	$(IDL)/LIGAMacros.h $(LIGASCEL)/ligaconsts.h backptg_gen.h attr.h
attrdecl.o: $(IDL)/global.h $(LIGASCEL)/ligaconsts.h $(IDL)/lookup_idl.h \
	$(IDL)/LIGA.h $(IDL)/LIGAMacros.h backptg_gen.h attrdecl.h idn.h bool.h
expr.o: $(ERR)/err.h $(IDL)/global.h $(LIGASCEL)/ligaconsts.h \
	$(IDL)/lookup_idl.h $(IDL)/LIGA.h $(IDL)/LIGAMacros.h \
	backptg_gen.h expr.h attr.h attrdecl.h incl.h bool.h
globdefs.o: $(IDL)/global.h $(LIGASCEL)/ligaconsts.h $(IDL)/lookup_idl.h \
	$(IDL)/LIGA.h $(IDL)/LIGAMacros.h backptg_gen.h globdefs.h attrdecl.h \
	incl.h BackNames.h $(ERR)/err.h
incl.o: $(IDL)/global.h $(IDL)/lookup_idl.h $(IDL)/LIGA.h \
	$(IDL)/LIGAMacros.h $(LIGASCEL)/ligaconsts.h backptg_gen.h incl.h bool.h
ligaback.o: $(IDL)/lookup_idl.h $(IDL)/LIGA.h $(IDL)/global.h \
	$(IDL)/LIGAMacros.h $(ERR)/err.h $(OPTHANDLER)/option_enums.h \
	$(OPTHANDLER)/option_types.h $(OPTHANDLER)/opt_input.h \
	ligaback.h 
backptg_gen.o: backptg_gen.h
backvisit.o: $(IDL)/global.h $(LIGASCEL)/ligaconsts.h\
	$(IDL)/lookup_idl.h $(IDL)/LIGA.h $(IDL)/LIGAMacros.h backptg_gen.h \
	backvisit.h attrdecl.h expr.h incl.h bool.h BackNames.h
OutStr.o: OutStr.h
BackNames.o: BackNames.h idn.h csm.h idntbl.h
idn.o:	idn.c idn.h csm.h idntbl.h
csm.o:	csm.c csm.h csmtbl.h

