/* $Id: Syntax.c,v 3.2 1992/04/16 12:18:25 cogito Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Lido.head"

void PutSymClass (AtAppl, SymKey, GramKey)
	int	AtAppl;
	DefTableKey	SymKey, GramKey;
{	int	IsDef, IsAppl, Did, RootDid;

if (AtAppl) {
	IsDef = GetIsDefined (SymKey, false);
	if (!IsDef) SetSymClass (SymKey, SYMBTERM, SYMBTERM);
} else {
	SetSymClass (SymKey, SYMBNONT, SYMBNONT);
	IsAppl = GetIsApplied (SymKey, false);
	if (!IsAppl) {
		Did =  GetDid (SymKey, DIDNON);
		SetIsRoot (SymKey, true, true);
		RootDid = GetRootDid (GramKey, DIDNON);
		if (RootDid != MANYROOTS) {
		if (RootDid == DIDNON) 
			SetRootDid (GramKey, Did, Did);
		else
		if (RootDid != Did) 
			SetRootDid (GramKey, MANYROOTS, MANYROOTS);
		}
	}
}
}/*PutSymClass*/

ProdElem MakeProdElem (IsSymbol, Id, SyntPos, Coord)
	int		IsSymbol, Id, SyntPos;
	POSITION *	Coord;
{	ProdElem	res;
res = (ProdElem) malloc (sizeof (_PElem));
res->IsSymbol = IsSymbol;
res->Id = Id;
res->SyntPos = SyntPos;
res->Coord = Coord;
return (res);
}/*MakeProdElem*/


DefTableKey NewEmptyProd (lkey, rkey, env, coord)
	DefTableKey	lkey, rkey;
	Environment	env;
	POSITION	*coord;
{	DefTableKey	rulekey;
	int		ruleid;
	TList		prod;

ruleid = NewRuleId (GetDid (rkey, DIDNON), 0, 0);
rulekey = Declare (env, ruleid, RuleDef, NoEnv, coord);
prod = ConsList (MakeProdElem (true, GetDid (lkey, DIDNON), 0, coord),
		NullList);
SetRuleProd (rulekey, prod, prod);
return (rulekey);
}/*NewEmptyProd*/

DefTableKey NewListEndProd (lkey, elkey, rkey, env, coord)
	DefTableKey	lkey, elkey, rkey;
	Environment	env;
	POSITION	*coord;
{	DefTableKey	rulekey;
	int		ruleid;
	TList		prod;

ruleid = NewRuleId (GetDid (rkey, DIDNON), GetDid (elkey, DIDNON), 0);
rulekey = Declare (env, ruleid, RuleDef, NoEnv, coord);
prod = ConsList (MakeProdElem (true, GetDid (lkey, DIDNON), 0, coord),
	ConsList (MakeProdElem (true, GetDid (elkey, DIDNON), 1, coord),
		NullList));
SetRuleProd (rulekey, prod, prod);
return (rulekey);
}/*NewListEndProd*/


DefTableKey NewListProd (lkey, elkey, rkey, env, coord)
	DefTableKey	lkey, elkey, rkey;
	Environment	env;
	POSITION	*coord;
{	DefTableKey	rulekey;
	int		ruleid;
	TList		prod;

ruleid = NewRuleId (GetDid (rkey, DIDNON), GetDid (elkey, DIDNON), 1);
rulekey = Declare (env, ruleid, RuleDef, NoEnv, coord);
prod = ConsList (MakeProdElem (true, GetDid (lkey, DIDNON), 0, coord),
	ConsList (MakeProdElem (true, GetDid (lkey, DIDNON), 1, coord),
	ConsList (MakeProdElem (true, GetDid (elkey, DIDNON), 2, coord),
		NullList)));
SetRuleProd (rulekey, prod, prod);
return (rulekey);
}/*NewListProd*/


int DifferentProds (p1, p2)
	TList		p1, p2;
{	ProdElem	e1, e2;
if (p1 == p2) 	return (false);
if ((p1 == NullList) && (p2 == NullList)) 
		return (false);
if (p1 != NullList) {
	e1 = (ProdElem) HeadList (p1);
	if (!e1->IsSymbol) 
		return (DifferentProds (TailList (p1), p2));
}
if (p2 != NullList) {
	e2 = (ProdElem) HeadList (p2);
	if (!e2->IsSymbol) 
		return (DifferentProds (p1, TailList (p2)));
	if (p1 == NullList)
		return (true);
	if (e1->Id != e2->Id)
		return (true);
} else	return (true);
return (DifferentProds (TailList (p1), TailList (p2)));
}/*DifferentProds*/


TList FindNext (Did, Pro)
	int	Did;
	TList	Pro;
{	ProdElem	pel;
while (Pro != NullList) {
	pel = (ProdElem)HeadList (Pro);
	if ((pel->IsSymbol) && (pel->Id == Did)) return (Pro);
	Pro = TailList (Pro);
}
return (NullList);
}/*FindNext*/


int FindSymPos (Key, Ind, Pro, Coord)
	DefTableKey	Key;
	int		Ind;
	TList		Pro;
	POSITION *	Coord;
{	ProdElem	pel;
	int Did;

Did = GetDid (Key, DIDNON);
Pro = FindNext (Did, Pro);	/* Pro is first occurrence of Did or nil */
if (Pro == NullList) {
	message (ERROR, "referenced symbol must be in production",
		0, Coord);
	return (0);
}
pel = (ProdElem)HeadList (Pro);

if (Ind == NoIndex) {
	Pro = FindNext (Did, TailList (Pro));
				/* Pro is 2nd occurrence of Did or nil */
	if (Pro != NullList) 
		message (ERROR, "symbol must be indexed", 0, Coord);
	return (pel->SyntPos);
} else if (Ind > 1) {
	Ind--;			/* Pro is ith occurrence of Did or nil */
				/* Ind = initial index - i */
	while ((Ind > 0) && (Pro != NullList)) {
		Pro = FindNext (Did, TailList (Pro));
		Ind--;
	}
	if (Pro == NullList)
		message (ERROR, 
		"referenced symbol must be in production", 0, Coord);
		else	pel = (ProdElem)HeadList (Pro);
}
return (pel->SyntPos);
}/*FindSymPos*/
