/* $Id: Actions.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: Actions.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Main/Actions.c					*
 *									*
 *	CONTENTS:	Implementation of the GORTO actions		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#include "Misc.h"
#include "Prod.h"
#include "Symb.h"
#include "Visit.h"
#include "Main.h"
#include "Graph.h"

#include <stdio.h>
#include <X11/Xaw/AsciiText.h>


/************************************************************************
 *			     ActionMenuPopup				*
 ************************************************************************/

/* Call of the action procedure menu-popup. Update the utility value
 * DidOfGraphMenu and popup the requested menu.
 */

/*ARGSUSED*/
PUBLIC void ActionMenuPopup (w, event, params, num_params)
	Widget		w;
	XEvent		*event;
	String		*params;
	Cardinal	*num_params;
{
	static int did;
	static Arg args[] = {XtNdid, (XtArgVal) &did};

      /* Set utility value for graph widgets */
	if (XtClass (w) == graphWidgetClass)
	{
		XtGetValues (w, args, XtNumber(args));
		DidOfGraphMenu = did;
	}

      /* Popup the requested menu by calling the corresponding actions */
	XtCallActionProc (w, "XawPositionSimpleMenu", event, params, 1);
	XtCallActionProc (w, "MenuPopup", event, params, 1);
}


/************************************************************************
 *			    ActionCloseWindow				*
 ************************************************************************/

/*ARGSUSED*/
PUBLIC void ActionCloseWindow (w, event, params, num_params)
	Widget		w;
	XEvent		*event;
	String		*params;
	Cardinal	*num_params;
{
	static int did;
	static Arg args[] = {XtNdid, (XtArgVal) &did};

      /* Try to identify the class of <w> */
	if (XtClass (w) == graphWidgetClass)
	{
	      /* Retrieve did of this graph widget */
		XtGetValues (w, args, XtNumber(args));

	      /* Determine window contents */
		DidOfGraphMenu = did;
		if (ref_tab[did].etag == PROD)
		{
			if (PE(did).vs && PE(did).vs->vsar &&
			    PE(did).vs->vsar->widget == w)
				VisitCloseCB (w, (caddr_t)NULL, (caddr_t)NULL);
			else
				ProdCloseCB (w, (caddr_t) NULL, (caddr_t) NULL);
		}
		else if (ref_tab[did].etag == SYMB)
			SymbCloseCB (w, (caddr_t) NULL, (caddr_t) NULL);
	}
	else if (XtClass (w) == asciiTextWidgetClass)
		LidoCB (w, (caddr_t) NULL, (caddr_t) NULL);
}
