# $Id$
#
# Makefile for nogorto, a substitute for gorto if X11 is not installed.
# It merly fails with an error message :-(

SHELL		= /bin/sh

# directories
DISTRIB 	= /tmp

# compiler options

CFLAGS		= 
COFLAGS		= -q

EXE		= ../ligaGorto

SOURCES		= nogorto.c

INCL		= 

OBJ		= nogorto.o

TIDY		= *.o *~ a.out core
CLEAN		= $(TIDY) $(EXE)
CLOBBER		= $(CLEAN) Makefile
RCS		= $(SOURCES) $(INCL)

# MAKE

all: $(EXE)

$(EXE): $(OBJ)
	$(CC) $(CFLAGS) $(OBJ) -o $@

# checkout

checkout:
	-co $(COFLAGS) $(RCS)

# installation

install:

SourceDistr:	$(SOURCES) $(INCL)

# distribution

distrib:	$(SOURCES) $(INCL)
	- rm -rf $(DISTRIB)/nogorto
	mkdir $(DISTRIB)/nogorto
	cp $(SOURCES) $(INCL) Makefile.cpp $(DISTRIB)/nogorto
	cd $(DISTRIB)/nogorto; chmod 0644 $(SOURCES) $(INCL) Makefile.cpp

# cleaning targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(RCS)
	rm -rf $(CLEAN) Makefile

