/* $Id: induce.c,v 2.1 1991/06/10 13:25:36 cogito Exp $ */
/* $Log: induce.c,v $
 * Revision 2.1  1991/06/10  13:25:36  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: induce.c,v 2.1 1991/06/10 13:25:36 cogito Exp $";

/****************************************************************
*                                                               *
*       Module  : induce.c                                      *
*                                                               *
*       Version : 1.0                                           *
*                                                               *
*       Author  : Jiyang Liu                                    *
*                                                               *
*       compute the transitive and induced graphs for           * 
*       rules and symbols.                                      * 
*                                                               *
****************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool)
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		13.06.90	Volker Niepel
	 */

/* include */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif

/* functions */

void ruletransitive();
void distributedeps();
void transitiveclosure();

/****************************************************************
*       void  ruletransitive()                                  *
*       compute the transitive  graphs for                      *
*       rule #pid and transpose the new dependencies to         *
*       the ds of symbols occurring in this rule.               *
****************************************************************/

void
ruletransitive(pid)
int pid;

{
PRODENTRY *prod;
SYMBENTRY *symb;
#ifndef GORTO
bool changed, newsymbcycle, newrulecycle;
int atno, depatno, atntno, maxatno;
int check_row, word, maxword;
SLNODE *slnptr;
#else
bool changed, newsymbcycle, newrulecycle;
int atno, depatno, maxatno;
int check_row, word, maxword;
int atntno;
SLNODE *slnptr;
DEPENDENCY *dp, *dep, *dep2;
DEP_VECTOR *dp_row, *dp_row2, *ds_row;
#endif


newrulecycle = FALSE;
prod = & ref_tab[pid].entry.prod;
maxatno = prod->check_row - 1;
check_row = prod->check_row;
maxword = prod->check_col;

if (maxatno >= 0) { /* if there are attritbutes in this rule */

   /* transitively close prod.dp */
   do {
	changed = FALSE;
#ifndef GORTO
 	for (atno = 0; atno <= maxatno; atno++) {

	   for (word = 0; word <= maxword; word++)
	      prod->dp[check_row][word] = prod->dp[atno][word];

	   slnptr = prod->hdright;

	   while (slnptr != NULL) {
	      symb = & ref_tab[slnptr->sid].entry.symb;
	      depatno = slnptr->start_row;
              for (atntno = 0; atntno < symb->attr_num; atntno++) {
		 if (prod->dp[atno][slnptr->start_col+atntno/WORD_LENGTH] & 0x1 << atntno%WORD_LENGTH) 
		    for (word = 0; word <= maxword; word++)
		       prod->dp[check_row][word] |= prod->dp[depatno][word];
		 depatno ++;
               }

	       slnptr = slnptr->right;
            } /* while */        

	    for (word = 0; word <= maxword; word++)
	       if (prod->dp[atno][word] != prod->dp[check_row][word]) {
	          changed = TRUE;
		  /*prod->changed = TRUE;*/
	          prod->dp[atno][word] = prod->dp[check_row][word];
	       }
	 }
#else
	dp_row = & prod->dp[maxatno];
 	for (; dp_row >= & prod->dp[0]; dp_row--) {

	   dp      = & (*dp_row)[0];
	   dp_row2 = & prod->dp[0];
	   for (slnptr=prod->hdright; slnptr!=NULL; slnptr=slnptr->right) {

	      symb = & ref_tab[slnptr->sid].entry.symb;
              for (atntno = 0; atntno < symb->attr_num; atntno++,dp++,dp_row2++)

		 if (*dp) {
		    dep  = & (*dp_row)[maxatno];
		    dep2 = & (*dp_row2)[maxatno];
		    for (; dep >= & (*dp_row)[0]; dep--, dep2--) 

		      if (*dep2 && !(*dep))
		      {
			changed = TRUE;
			*dep = T_TRAN | graphstate_hint;
			prod->dp_detail[maxatno - (&prod->dp[maxatno] - dp_row)]
				       [maxatno - (&(*dp_row)[maxatno] - dep)].
			      transitive.over_atno = slnptr->start_row + atntno;
		      }
		 }
            }
	 }
#endif
   } while (changed);

#ifndef GORTO
for (slnptr = prod->hdright; slnptr != NULL; slnptr = slnptr->right) {
   newsymbcycle = FALSE;
   symb = & ref_tab[slnptr->sid].entry.symb;
   check_row = symb->attr_num;

   for (atno = 0; atno < symb->attr_num; atno++) {

      /* check circularity for both dp and ds */

      if ( prod->dp[atno+slnptr->start_row][slnptr->start_col+atno/WORD_LENGTH] &
           0x1 << atno%WORD_LENGTH) {

	 newrulecycle = TRUE; 
	 newsymbcycle = TRUE;
      }

      /* transpose into ds */

      for (word = 0; word < (symb->attr_num - 1)/WORD_LENGTH + 1;  word++) {
	 symb->ds[check_row][word] = symb->ds[atno][word] | 
				    prod->dp[slnptr->start_row+atno]
					   [slnptr->start_col+word];
	 if (symb->ds[atno][word] != symb->ds[check_row][word]) {
	    symb->ds[atno][word] = symb->ds[check_row][word];
	    symb->changed = TRUE;
	 }
      }	 
   } /* for (atno ... */

   if (newsymbcycle) {
      symb->cyclic = TRUE; 
   }
} /* out-most for */
#else
dp_row = & prod->dp[0];
for (slnptr = prod->hdright; slnptr != NULL; slnptr = slnptr->right) {

   newsymbcycle = FALSE;
   symb         = & ref_tab[slnptr->sid].entry.symb;
   ds_row       = & symb->ds[0];
   for (atno = 0; atno < symb->attr_num; atno++, dp_row++, ds_row++) {

      /* check circularity for both dp and ds */

      if ((*dp_row)[slnptr->start_row+atno]) {
	 newrulecycle = TRUE; 
	 newsymbcycle = TRUE;
      }

      /* transpose into ds */

      dep  = & (*ds_row)[symb->attr_num-1];
      dep2 = & (*dp_row)[slnptr->start_row + symb->attr_num-1];
      for (; dep >= & (*ds_row)[0]; dep--, dep2--)

	 if (!(*dep) && *dep2)
	 {
		*dep = *dep2;
		{
			*dep = T_IND | graphstate_hint;
			if ((*dep2 & T_TRAN) || !(*dep2 & T_IND))
				symb->ds_detail[atno]
				  [symb->attr_num-1 - 
				     (&(*ds_row)[symb->attr_num-1] - dep)].
				  induced.from = slnptr;
		}
		symb->state |= S_CHANGED;
	 }
   }

   if (newsymbcycle) symb->state |= S_CYCLIC;
}
#endif

if (newrulecycle) {
#ifndef GORTO
   prod->cyclic = TRUE;
#else
   prod->state |= S_CYCLIC;
#endif
}

} /* if there exist attributes in this rule */

return;
} /* end of ruletransitive() */



/****************************************************************
*	void distributedeps () 					*
* 	distribute the symbol attribute dependencies to  	*
* 	rules. 							*
****************************************************************/

void
distributedeps(sid, changed)
int sid;
bool *changed;
{
#ifndef GORTO
SLNODE  	*slnptr;
PRODENTRY 	*prod;
SYMBENTRY 	*symb;
int 	atno, word;
#else
SLNODE *slnptr;
PRODENTRY *prod;
SYMBENTRY *symb;
int atno, maxatno;
DEPENDENCY *dp, *ds;
DEP_VECTOR *dp_row, *ds_row;
#endif

*changed = FALSE;
symb = & ref_tab[sid].entry.symb;
for (slnptr = symb->hddown; slnptr != NULL; slnptr = slnptr->down) {
   prod = & ref_tab[slnptr->pid].entry.prod;
#ifndef GORTO
   for (atno = 0; atno < symb->attr_num; atno++) 
      for (word=0; word<(symb->attr_num-1)/WORD_LENGTH+1; word++) 
         if (symb->ds[atno][word] != prod->dp[atno+slnptr->start_row]
					   [word+slnptr->start_col] ) {
	    prod->dp[atno+slnptr->start_row][word+slnptr->start_col] =
	    symb->ds[atno][word];
	    *changed = TRUE;
            prod->changed = TRUE;
	 }
#else
   maxatno = slnptr->start_row + symb->attr_num-1;
   dp_row = & prod->dp[maxatno];
   ds_row = & symb->ds[symb->attr_num-1];
   for (; ds_row >= & symb->ds[0]; dp_row--, ds_row--) {

	dp = & (*dp_row)[maxatno];
	ds = & (*ds_row)[symb->attr_num-1];
	for (; ds >= & (*ds_row)[0]; dp--, ds--)

		if (*ds && !(*dp))
		{
			if (*ds & (T_DIR|T_IND))
			{
				*dp = T_IND | graphstate_hint;
				prod->dp_detail
				  [maxatno - (&prod->dp[maxatno] - dp_row)]
				  [maxatno - (&(*dp_row)[maxatno] - dp)]
				   .induced.from =
				 symb->ds_detail
				  [symb->attr_num-1 - 
				  (&symb->ds[symb->attr_num-1] - ds_row)]
				  [symb->attr_num-1 -
				   (&(*ds_row)[symb->attr_num-1] - ds)]
				    .induced.from;
			}
			else
			{
				*dp = T_IND | graphstate_hint;
				prod->dp_detail
				  [maxatno - (&prod->dp[maxatno] - dp_row)]
				  [maxatno - (&(*dp_row)[maxatno] - dp)]
				   .induced.from = (SLNODE *) NULL;
			}
			*changed = TRUE;
			prod->state |= S_CHANGED;
		}
   }
#endif
}

/*
*changed = (*changed || symb->changed);
*/
return;

} /* end of distributedeps () */

/****************************************************************
*       void transitiveclosure() 				*
*       transitively close attribute dependency graphs of 	*
*       both rules and symbols.					*
****************************************************************/

void
transitiveclosure()
{
bool changed, symbchanged;
int did;
PRODENTRY *prod;
SYMBENTRY *symb;

do { 
      for (did = min_entry; did <= max_entry; did++)
	 if (ref_tab[did].etag == PROD)  {
	    prod = & ref_tab[did].entry.prod;
#ifndef GORTO
	    if (prod->changed && !prod->cyclic) {
		ruletransitive (did);
		prod->changed = FALSE;
	    }
#else
            if ((prod->state & S_CHANGED) && !(prod->state & S_CYCLIC)) {
		ruletransitive (did);
		prod->state &= ~S_CHANGED;
	    }
#endif
	 }

      changed = FALSE;

      if (graphstate > TRANSITIVE)
	  for (did = min_entry; did <= max_entry; did++)
	     if (ref_tab[did].etag == SYMB) {
		symb = & ref_tab[did].entry.symb;
#ifndef GORTO
		if (symb->changed && !symb->cyclic) {
		   symb->changed = FALSE;
		   distributedeps(did, &symbchanged);
		   changed = changed || symbchanged;
	 	}
#else
		if ((symb->state & S_CHANGED) && !(symb->state & S_CYCLIC)) {
		    symb->state &= ~S_CHANGED;
		    distributedeps (did, &symbchanged);
		    changed = changed || symbchanged;
		}
#endif
	     }

} while (changed);

return;
} /* end of transitiveclosure () */

