/* $Id: order.c,v 3.2 1992/07/03 09:25:30 cogito Exp $ */
/* $Log: order.c,v $
 * Revision 3.2  1992/07/03  09:25:30  cogito
 * previous: there were arrays of static size MAX_SYMBNO
 * now: MAX_SYMBNO will be computed and there are "dynamic" arrays of
 *      size MAX_SYMBNO
 *
 * Revision 3.1  1992/03/05  09:12:51  uwe
 * predefined attr GENTREE
 *
 * Revision 2.3  1991/12/02  13:14:45  cogito
 * Inserted a type-cast to prevent warning message
 *
 * Revision 2.2  1991/11/05  15:13:50  kalle
 * strdup replaced by CpString (liga_func.h added)
 *
 * Revision 2.1  1991/06/10  13:25:54  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: order.c,v 3.2 1992/07/03 09:25:30 cogito Exp $";

/*********************************************
*                                            *
*       Module  : order.c                    *
*                                            *
*       Version : 1.0                        *
*                                            *
*       Contains the main-routine of order   *
*					     *
*	Author  : Jiyang Liu		     *
*                                            *
**********************************************/

#include "order.h"
#include "printerr.h"

#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"

#include "liga_func.h"

/********************************************
* 	global variables		    *
********************************************/

FILE *In=stdin, *Out=stdout, *Prot=stdout, *Err=stdout;

AttrEval ISexp;
extern SEQAttribution attribution_order;   /* defined in write.c */
int graphstate;
/* int PrintList[MAX_SYMBNO]; contains the did of symbols or rules 
                              whose graphs will be printed out */
int  *PrintList = (int *)NULL;	/* now dynamic allocatd array */
bool AUTOMATICALLY = FALSE, 
     ARRANGE = FALSE,

     PART_EARLY = FALSE,  PART_LATE = TRUE,
     PART_BRANCH_AND_BOUND = FALSE, 

     PARSE_TIME = FALSE,
     TREE_BOTTOM_UP = FALSE,
     TREE_TOP_DOWN = FALSE,
     TREE_COMPLETE = TRUE,

     PRINT_SYMBOL_DIRECT = FALSE,
     PRINT_SYMBOL_TRANSITIV = FALSE,
     PRINT_SYMBOL_INDUCED = FALSE,
     PRINT_RULE_DIRECT = FALSE,
     PRINT_RULE_TRANSITIV = FALSE,
     PRINT_RULE_INDUCED = FALSE,
     PRINT_PARTITION = FALSE,
     PRINT_RULE_PARTITIONED = FALSE,
     PRINT_VISITSEQUENCE = FALSE;

char *progname; 	/* program name for error message */

/* functions */

void usage();
FILE *efopen(); 

int main (argc, argv)
int argc;
char *argv[];

{
	char *ctl_fname= (char *) NULL;

	/* intializations */

	/* Open I/O files */
	/*
	printf("order: open I/O files\n");
	*/
	progname = *argv++;
	for (; argc > 1; argc--, argv++) {
	   if ((*argv)[0] == '-') {
	      switch ((*argv)[1]) {

		 case 'c': argv++; argc--;
			   ctl_fname= *argv;
			   break;
			
		 case 'i': argv++; argc--;
			   In = efopen(*argv, "r");
			   break;

		 case 'o': argv++; argc--;
			   Out = efopen(*argv, "w");
			   break;

		 case 'e': argv++; argc--;
			   Err = efopen(*argv, "w");
			   break;

		 case 'p': argv++; argc--;
			   Prot = efopen(*argv, "w");
			   break;

		 default: usage();
			  exit(1);
	      }
	   }
	   else {
	      usage();
	      exit(1);
	   }
	} /* for */

	if (ctl_fname== (char *) NULL)
	  ctl_fname= (char *)(CpString (ORDFNAME));

	fprintf(Prot,"========================================\n");
	fprintf(Prot,"This is ORDER, a Dependence-Pass of LIGA\n");
	fprintf(Prot,"========================================\n\n");

	/*
	printf("order: read in LIGA structure\n");
	*/
	ISexp = ligain(In);  /* read in LIGA structure from IDL */

	/* initialization of MAX_SYMBNO and allocating the dynamic
	   arrays depending on MAX_SYMBNO */
	MAX_SYMBNO = initMAX_SYMBNO(ISexp);
	PrintList = (int *)Malloc( (MAX_SYMBNO+1)*sizeof(int) );
	symbvsvect = (VSPTR *)Malloc( (MAX_SYMBNO+1)*sizeof(VSPTR) );
	symbvect = (SLNODE **)Malloc( (MAX_SYMBNO+1)*sizeof(SLNODE *) );

	/*
	printf("order: initialize ref_tab\n");
	*/
	init_ref_tab(ISexp);

	/*
	printf("order: construct direct graphs\n");
	*/
	graphstate = DIRECT;
	cons_init_dp(ISexp);
	cons_init_ds();

	/* read in options for order */
	read_orderOption(ctl_fname);

	/* set predefined dependencies */
	PredefDp (ISexp);


	if ((PRINT_SYMBOL_DIRECT) || (PRINT_RULE_DIRECT)) 
	   print_headerForGraphs(DIRECT);

	if (PRINT_SYMBOL_DIRECT) {
	   read_printOption(direct_symb);
	   print_SymbGraphs();
	}

	if (PRINT_RULE_DIRECT) {
	   read_printOption(direct_rule);
	   print_RuleGraphs();
	}

	check_cycle();

	/*
	printf("order: construct transitive graphs\n");
	*/
	graphstate = TRANSITIVE;
	transitiveclosure ();

	if ((PRINT_SYMBOL_TRANSITIV) || (PRINT_RULE_TRANSITIV)) 
	   print_headerForGraphs(TRANSITIVE);

	if (PRINT_SYMBOL_TRANSITIV) {
	   read_printOption(trans_symb);
	   print_SymbGraphs();
	}

	if (PRINT_RULE_TRANSITIV) {
	   read_printOption(trans_rule);
	   print_RuleGraphs();
	}

	check_cycle();


	if (ARRANGE) {
	   fprintf(Prot, "ARRANGE OPTIONS OF THE AG:\n");
	   fprintf(Prot, "==========================\n\n");
	   set_arrangeOption();
	   fprintf(Prot, "\n\n");
	}

	/*
	printf("order: construct induced graphs\n");
	*/
	graphstate = INDUCED;
	transitiveclosure ();

	if ((PRINT_SYMBOL_INDUCED) || (PRINT_RULE_INDUCED))
	   print_headerForGraphs(INDUCED);

	if (PRINT_SYMBOL_INDUCED) {
	   read_printOption(ind_symb); 
	   print_SymbGraphs();
	}

	if (PRINT_RULE_INDUCED) {
	   read_printOption(ind_rule);
	   print_RuleGraphs();
	}
	   
	check_cycle();

	/*
	printf("order: partitioning \n");
	*/
	graphstate = PARTITIONED;
	partit();

	/*
	printf("order: construct partitioned graphs\n");
	*/

	transitiveclosure();

	if ((PRINT_PARTITION) || (PRINT_RULE_PARTITIONED))
	   print_headerForGraphs(PARTITIONED);

	if (PRINT_PARTITION) {
	   read_printOption(partition);
	   print_SymbGraphs();
	}

	if (PRINT_RULE_PARTITIONED) {
	   read_printOption(part_rule);
	   print_RuleGraphs();
	}

	check_cycle();

	/*
	printf("order: construct visit sequences\n");
	*/

	visitsequence();

	if (PRINT_VISITSEQUENCE) {
	   read_printOption(visit_seq);
	   print_VisitSequences();
	}


	/* print the statisitc info of the input AG */

	print_stat();

	/* write liga structures */

	/*
	printf("order: write out LIGA structures\n");
	*/
	write_dataStruct();
	ISexp->attrrules = attribution_order;
	ligaout(Out, ISexp);

	return (0);

} /* main() */


static	int	initMAX_SYMBNO(ISexp)
AttrEval	ISexp;
{

  SEQDef	deflist;
  Def		def;
  SEQEntity	entlist;
  Entity	ent;
  int		cnt=0, max=0;

   max = 0;
   foreachinSEQDef(defseqOfAttrEval(ISexp), deflist, def)
     if ( typeof(def)  ==  KProd )
     {
	cnt = 0;
	foreachinSEQEntity(rhsOfProd(def.VProd), entlist, ent)
	  switch ( typeof(ent) )
	  {
	    case KSymbol:	cnt++;

	    case KLiteral:	break;

	    default:	err_print_error("Not expected Entity in initMAX_SYMBNO()");
	  }
	if ( cnt > max )  max = cnt;
      }
   printf("Max: %d\n\n", max);
   return(max);
}



/********************************************************
* 	FILE *efopen()					*
*       fopen file, die if can't 			*
********************************************************/

FILE *efopen(file, mode) 
char *file, *mode;

{
	FILE *fp, *fopen();

	if ((fp = fopen(file, mode)) != NULL)
	   return fp;
	fprintf(stderr, "%s: can't open file %s mode %s\n",
			progname, file, mode);
	exit(1);
} /* efopen() */

	
/********************************************************
* 	void usage()					*
*       print usage of program    			*
********************************************************/

static void
usage()
{
	fprintf (stderr, "Usage: %s [-i in] [-o out] [-p prot] [-e err] [-c ctl]\n",
		 progname );
} /* usage() */

