/* $Id: visit.c,v 2.9 1992/07/03 09:25:30 cogito Exp $ */
/* $Log: visit.c,v $
 * Revision 2.9  1992/07/03  09:25:30  cogito
 * previous: there were arrays of static size MAX_SYMBNO
 * now: MAX_SYMBNO will be computed and there are "dynamic" arrays of
 *      size MAX_SYMBNO
 *
 * Revision 2.8  1991/10/02  15:13:53  cogito
 * Increased Length of error message buffer.
 *
 * Revision 2.7  1991/10/02  15:07:48  cogito
 * Wrong sprintf-statements corrected.
 *
 * Revision 2.6  1991/09/25  13:38:04  cogito
 * Corrected an error of the last modification.
 *
 * Revision 2.5  1991/09/23  14:27:41  mjung
 * Added Errormessages using message. Protocoll-file is unchanged.
 *
 * Revision 2.4  1991/07/24  15:37:33  cogito
 * next try to fix the malloc(0) bug
 *
 * Revision 2.3  91/07/23  11:11:12  cogito
 * malloc(0) bug fixed again
 * 
 * Revision 2.2  91/07/18  11:41:56  cogito
 * adjust setsize to avoid malloc(0) call
 * 
 * Revision 2.1  91/06/10  13:26:21  cogito
 * sources for ORDER combined with GORTO
 *  */
static char rcs_id[]= "$Id: visit.c,v 2.9 1992/07/03 09:25:30 cogito Exp $";

/****************************************************************
*								*
*	Module  : visit.c					*
*								*
*	Version : 1.0						*
*								*
*	Author  : Jiyang Liu					*
*								*
*	compute the visit sequences for the rules.		*
*								*
****************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		26.04.90	Volker Niepel
	 */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif
#include "printerr.h"

#define ERR_BUFF_LEN 200
#define INACTIVE -1

/* global varibles */

int	MAX_SYMBNO = 0;
PRODENTRY *prod;
SYMBENTRY *symb;

VSPTR rulevisitseq, lastvisitel;
int maxsymbno;
bool nocyclicsymbs;
int pid, setsize;
BITVECTOR eval, noteval, evaluable;
/* VSPTR symbvsvect[1+MAX_SYMBNO];
   SLNODE *symbvect[1+MAX_SYMBNO]; */

VSPTR	*symbvsvect;	/* now dynamic allocated array */
SLNODE **symbvect;	/* now dynamic allocated array */

int atvect[1+MAX_ATNO];

/* function declarations */

void rulevisitsequence();
void visitsequence();
void insertconditions();
void findevaluable();
void appendsem();
void appendnextvs();
void createvisit();
void visitseqinit();
void visitstrategy();

/********************************************************
*	void rulevisitsequence()			*
*	compute the visit sequences for the given rule	*
********************************************************/

void
rulevisitsequence(did)
int did;
{
	int i;

	pid = did;
	prod = & ref_tab[pid].entry.prod;
#ifndef GORTO
      if (!prod->cyclic) {
#else
      if (!(prod->state & S_CYCLIC)) {
	 prod->state |= S_VISIT_SEQ;
#endif
 
/* Kalle: 
 * setsize is used as actual parameter for various calls of mkemptyset()
 */
/*         setsize = prod->check_col;	 * previous version */
if ( prod->check_col >= 0 )		/* now: to avoid malloc(0) */
    setsize = prod->check_col;
else	/* == -1 */
    setsize = prod->check_col + 1;
         
         nocyclicsymbs = TRUE;
        
         visitseqinit();

         if (nocyclicsymbs) {
            
            visitstrategy();
            
            if (prod->visitseq != NULL) {
	       char errmsgbuff[ERR_BUFF_LEN];
	       err_setpos(prod->prod_def->row, prod->prod_def->col);
	       sprintf (errmsgbuff, "from visitsequence() pid = %d",pid);
	       err_print_error (errmsgbuff);

               fprintf(Prot, "*** ERROR *** from visitsequence() pid = %d\n", pid);
               exit(5);
            }

            ref_tab[pid].entry.prod.visitseq = rulevisitseq;

            for (i = 0; i <= maxsymbno; i++)
               if (symbvsvect[i] != NULL) {
	       char errmsgbuff[ERR_BUFF_LEN];
	       err_setpos(prod->prod_def->row, prod->prod_def->col);
	       sprintf (errmsgbuff, "from visitsequence() pid = %d",pid);
	       err_print_error (errmsgbuff);

               fprintf(Prot, "*** ERROR *** from visitsequence() pid = %d\n", pid);
               exit(5);
               }

            for (i = 0; i < prod->check_row; i++) 
               if (atvect[i] != INACTIVE) {
	       char errmsgbuff[ERR_BUFF_LEN];
	       err_setpos(prod->prod_def->row, prod->prod_def->col);
	       sprintf (errmsgbuff, "from visitsequence() pid = %d",pid);
	       err_print_error (errmsgbuff);

               fprintf(Prot, "*** ERROR *** from visitsequence() pid = %d\n", pid);
               exit(5);
               }

         } /* nocyclicsymbs */
      } /*  !cyclic */
}


/********************************************************
*	void visitsequence()				*
*	compute the visit sequences for the rules	*
********************************************************/

void
visitsequence()
{
int did;

for (did = min_entry; did <= max_entry; did++)

   if (ref_tab[did].etag == PROD) {
	rulevisitsequence (did);
   } /* PROD */

return;
} /* end of visitsequence() */


/********************************************************
*	void insertconditions()				*
*	insert currently computable conditions into	*
*	the list headed by rulevisitseq for the 	*
*	current rule.					*
********************************************************/

void 
insertconditions()
{

VSPTR cond, notinserted, notchecked;

notinserted = NULL;
notchecked = ref_tab[pid].entry.prod.visitseq;

while (notchecked != NULL) {

         cond = notchecked;
	 notchecked = notchecked->next;
	 if (issubset(cond->deps, eval, setsize)) {
	    if (rulevisitseq == NULL)
	       rulevisitseq = cond;
	    else 
               lastvisitel->next = cond;
	    lastvisitel = cond;
	    cond->next = NULL;
         }
         else {
	    cond->next = notinserted;
	    notinserted = cond;
	 }
} 

ref_tab[pid].entry.prod.visitseq = notinserted;

return;

} /* end of insertcondtions() */

/********************************************************
*	void findevaluable()				*
*	find those attributes that are ready to 	*
*	be computed i.e. whose depended attributes	*
*	have been computed.				*
********************************************************/

void
findevaluable()

{

SLNODE *slnptr;
int atno;
bool changed;

copyset(eval, evaluable, setsize);

do {

    changed = FALSE;

    if (prod->check_row >= 1)   /* there are attribute occ. in this rule */
       for (slnptr = prod->hdright; slnptr != NULL; slnptr = slnptr->right) {
          symb = & ref_tab[slnptr->sid].entry.symb;
	  for (atno = 0; atno < symb->attr_num; atno++) 
	     if (atvect[atno + slnptr->start_row] != INACTIVE )  /* if this attr is a def occ */
#ifndef GORTO
                if ( !ismemberset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, evaluable))
	           if (issubset(prod->dp[atno + slnptr->start_row], evaluable, setsize)) {
		      addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, evaluable);
		      changed = TRUE;
		   }
       }
#else
                if ( !ismemberset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, evaluable))
	           if (dep_is_subset(prod->dp[atno + slnptr->start_row], evaluable, prod)) {
		      addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, evaluable);
		      changed = TRUE;
		   }
       }
#endif

} while (changed);

return;

} /* rulevisitsequence() */


/********************************************************
*	void appendsem()				*
*	append a visitseqence element of class VSASSIG	*
*	to the end of the list headed by rulevisitseq	*
********************************************************/

void
appendsem (atno, symbno)
int atno, symbno;

{
VSPTR semnodeptr;
SLNODE *slnptr;
int aid, sno;

slnptr = prod->hdright;
for (sno = 0; sno < symbno; sno++) slnptr = slnptr->right;

aid = atvect[atno+slnptr->start_row];
atvect[atno+slnptr->start_row] = INACTIVE;

 
/* make a new node */

semnodeptr = (VSPTR) Malloc (sizeof(VSELEM));
semnodeptr->deps = mkemptyset(setsize);

/* complete the items of this node */

#ifndef GORTO
copyset(prod->dp[atno+slnptr->start_row], semnodeptr->deps, setsize);
#else
copy_dep_to_set(prod->dp[atno+slnptr->start_row], semnodeptr->deps, prod);
#endif

semnodeptr->vscls = VSASSIG;
semnodeptr->next = NULL;

semnodeptr->vsinfo.assig.aid = aid;
semnodeptr->vsinfo.assig.apos = atno;
semnodeptr->vsinfo.assig.sid = slnptr->sid;
semnodeptr->vsinfo.assig.sno = symbno;

/* append semnodeptr to the end of rulevisitseq */

if (rulevisitseq == NULL)
   rulevisitseq = semnodeptr;
else
   lastvisitel->next = semnodeptr;

lastvisitel = semnodeptr;

/* modify sets eval and noteval */

addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, eval);
delfromset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, noteval);

return;

} /* appendsem() */


/********************************************************
*	void appendnextvs()				*
*	append a visitseqence element of class VSVISIT	*
*	to the end of the list headed by rulevisitseq	*
********************************************************/


void
appendnextvs(symbno)
int symbno;

{
int atno, sno;
VSPTR vsnode;
BITVECTOR neweval, tmpset;
SLNODE *slnptr;

if (symbvsvect[symbno] == NULL) {
   err_setpos(0,0);
   err_print_error ("in appendnextvs()");
   fprintf(Prot, "*** ERROR *** in appendnextvs ()\n");
   exit(5);
}

neweval = mkemptyset(setsize);
tmpset = mkemptyset(setsize);

vsnode = symbvsvect[symbno];
copyset(vsnode->deps, neweval, setsize);
diffset(eval, neweval, setsize);         /* neweval <= vsnode->deps - eval */

copyset(evaluable, tmpset, setsize);
unionset(eval, tmpset, setsize);	/* tmpset <= evaluable + eval */

if (!issubset(vsnode->deps, tmpset, setsize)) {
   err_setpos(0,0);
   err_print_error("in appendnextvs()");
   fprintf(Prot, "*** ERROR *** in appendnextvs ()\n");
   exit(5);
}

do {

if (prod->check_row >= 1)   /* there are attribute occ. in this rule */
   for (sno = 0, slnptr = prod->hdright; slnptr != NULL; sno++, slnptr = slnptr->right) {
      symb = & ref_tab[slnptr->sid].entry.symb;
      for (atno = 0; atno < symb->attr_num; atno++)
#ifndef GORTO
         if (ismemberset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, neweval))
 	    if (issubset(prod->dp[atno + slnptr->start_row], eval, setsize)) {
   	       appendsem(atno, sno);
	       delfromset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, neweval);
	       insertconditions();
   	    }
#else
         if (ismemberset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, neweval))
 	    if (dep_is_subset(prod->dp[atno + slnptr->start_row], eval, prod)) {
   	       appendsem(atno, sno);
	       delfromset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, neweval);
	       insertconditions();
   	    }
#endif
   }
} while (!isemptyset(neweval, setsize));

/* append this visit node */

if (ref_tab[vsnode->vsinfo.visit.vssid].entry.symb.symb_def->tornt == 0) { /* if non-terminal */

   if (rulevisitseq == NULL)
      rulevisitseq = vsnode;
   else 
      lastvisitel->next = vsnode;

   lastvisitel = vsnode;
}

/* modify the symbvsvect array */

symbvsvect[symbno] = vsnode->next;
vsnode->next = NULL;

unionset(vsnode->vsinfo.visit.evalset, eval, setsize);
diffset(eval, noteval, setsize);
insertconditions();
findevaluable();

Free( (char **) &tmpset);
Free( (char **) &neweval);

return;

} /* appendnextvs() */


/********************************************************
*	void createvisit()				*
*	create a visit node and insert it into		*
*	symbvsvect[symbno]				*
********************************************************/

void
createvisit(sid, sno, actpartno)
int sid, sno, actpartno;

{

VSPTR vsnode;

vsnode = (VSELEM *) Malloc(sizeof(VSELEM));

vsnode->deps = mkemptyset(setsize);

vsnode->vscls = VSVISIT;
vsnode->vsinfo.visit.evalset = mkemptyset(setsize);
vsnode->vsinfo.visit.vssid = sid;
vsnode->vsinfo.visit.vssno = sno;

vsnode->vsinfo.visit.vsord = (actpartno + 1)/2;

vsnode->next = symbvsvect[sno];
symbvsvect[sno] = vsnode;

return;

} /* createvisit() */


/********************************************************
*	void visitseqinit()				*
*	initializations of the global data structures	*
*	used in the module 				*
********************************************************/

void 
visitseqinit()

{

int currpartno; 
int atno, aid; 
int sno;
int aux;
bool isdefpart;
SLNODE *slnptr;

rulevisitseq = NULL;
lastvisitel = NULL;


for (sno = 0; sno <= MAX_SYMBNO; sno++) {
   symbvsvect[sno] = NULL;
   symbvect[sno] = NULL;
}
 
if (prod->check_row >= 1)
   for (atno = 0; atno < prod->check_row;  atno++)
      atvect[atno] = INACTIVE;

eval = mkemptyset(setsize);
evaluable = mkemptyset(setsize);
noteval = mkemptyset(setsize);

if (prod->check_row >= 1)
   for (slnptr = prod->hdright; slnptr != NULL; slnptr = slnptr->right) {
      symb = & ref_tab[slnptr->sid].entry.symb;
      for (atno = 0; atno < symb->attr_num; atno++)
         addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, noteval);
   }

slnptr = prod->hdright;
/* last visit to ancestor */

if ( (aux = ref_tab[slnptr->sid].entry.symb.part_num)  == 0 )
   aux++;
createvisit(slnptr->sid, 0, aux);

copyset(noteval, symbvsvect[0]->deps, setsize);

for (sno = 0, slnptr = prod->hdright; slnptr != NULL; slnptr = slnptr->right, sno++) {
   symb = & ref_tab[slnptr->sid].entry.symb;
#ifndef GORTO
   nocyclicsymbs = nocyclicsymbs && !(symb->cyclic);
#else
   nocyclicsymbs = nocyclicsymbs && !(symb->state & S_CYCLIC);
#endif
   symbvect[sno] = slnptr;

   for (currpartno = symb->part_num; currpartno >= 0; currpartno--) {
      
      isdefpart = ((sno == 0) && ODD(currpartno)) || ((sno > 0) && EVEN(currpartno));

      if (!isdefpart) createvisit(slnptr->sid, sno, currpartno);

      for (atno = 0; atno < symb->attr_num; atno++) {
         aid = lookup_attr(slnptr->sid, atno);
         if (ref_tab[aid].entry.attr.part == currpartno) 
            if (isdefpart) {
               atvect[atno+slnptr->start_row] = aid;
/*
               if (symbvsvect[sno] != NULL) {
*/
                  addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, symbvsvect[sno]->deps);
#ifndef GORTO
                  unionset(prod->dp[atno+slnptr->start_row], symbvsvect[sno]->deps, setsize);
#else
                  dep_unionset(prod->dp[atno+slnptr->start_row], symbvsvect[sno]->deps, prod);
#endif
/*
  	       }
*/
               /* 
                  symbvsvect[sno]->deps <= [atno] + attr->deps + symbvsvect[sno]->deps,
                  i.e. 
                  previously constructed visit must not be executed 
                  before this attr is evaluated                  
               */
            }
            else /*if (symbvsvect[sno] != NULL)*/
               addtoset(atno%WORD_LENGTH, slnptr->start_col+atno/WORD_LENGTH, symbvsvect[sno]->vsinfo.visit.evalset);
      } /* for atno */

   } /* for currpartno */
   
   
} /* for sno, slnptr */

maxsymbno = sno - 1;

/* for the tree-complete case */

unionset(symbvsvect[0]->vsinfo.visit.evalset, eval, setsize);
symbvsvect[0] = symbvsvect[0]->next;

diffset(eval, noteval, setsize);
insertconditions();
findevaluable();

return;

} /* visitseqinit() */
	 
/********************************************************
*	void visitstrategy()				*
*	visit as many sons as possible			*
********************************************************/

void
visitstrategy()

{

int symbno;
bool foundancestor;
BITVECTOR tmpset;

tmpset = mkemptyset(setsize);

symbno = 1 % (maxsymbno + 1);  /* try with visit of X[1], if existss */
foundancestor = TRUE;

do {
   
   if (symbno == 0)
      foundancestor = FALSE;

   if (symbvsvect[symbno] == NULL)
      symbno = (symbno + 1) % (maxsymbno + 1);
   else {

      copyset(eval, tmpset, setsize);
      unionset(evaluable, tmpset, setsize);  /* tmpset <= evaluable + eval */

      if (issubset(symbvsvect[symbno]->deps, tmpset, setsize)) {
         appendnextvs(symbno);
         if (symbno == 0)  foundancestor = TRUE;
         symbno = 1 % (maxsymbno + 1);
      } 
      else symbno = (symbno + 1) % (maxsymbno + 1);
   }
      
} while (foundancestor);

Free( (char **) &tmpset );
return;

} /* visitstrategy() */


