static char RCSid[] = "$Id: cstsupp.c,v 7.12 91/07/02 09:28:55 tony Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include "err.h"
#include "csm.h"
#include "idn.h"	/* To define "dofold" */

#ifdef __STDC__
extern char *getenv (char *);
#else
extern char *getenv ();
#endif

          /* Interface to C support routines */

/*
procedure SCANINIT(var s: filename; fold: integer);
   (* Initialize the support modules *)
*/
char *source = "SOURCE";
int f;

SCANINIT(s,fold)
char *s; int fold;
{
	int rc;

	if (getenv("ERRORSNOGRAMMARLINE") != NULL) ErrorInit(1,0,1);

	source = s;
	while (*s != ' ') s++; *s = '\0';

	if ((f = open(source, 0)) == -1) {
		fprintf(stderr, "Cannot open file %s\n", source);
		exit(1);
	}

	initBuf(source,f);      /* Initialize the source module */
	dofold = fold;          /* Upper and lower case identity */
	return;                 /* Compile the program */
}

/*
procedure WRAPUP;
   (* Finalize the compilation *)
*/
WRAPUP()
{
	/* the following lines give options thru environment variables */
	char ErrorsInContext = (getenv("ERRORSINCONTEXT") != NULL);
	char ErrorsFullList = (getenv("ERRORSFULLLIST") != NULL);

        close(f);                       /* Reopened in lisedit */

	if( ErrorsInContext!=0 || ErrorsFullList!=0 )
        	lisedit(source, stdout, 0, ErrorsInContext ? 1 : 0);
}


/*
procedure MESSAGE(PCLASS, PMSGTEXT, PGRAMLINE, LINE, COL: integer);
   (* Issue an error report
      On entry-
         PCLASS=GAG error message classification
         PMSGTEXT=index of the message text in the symbol table
         PGRAMLINE=grammar line originating the message
         LINE,COL=coordinates
   *)
*/
MESSAGE(PCLASS, PMSGTEXT, PGRAMLINE, LINE, COL)
int PCLASS, PMSGTEXT, PGRAMLINE, LINE, COL;
{
	POSITION POS;

	POS.line = LINE; POS.col = COL;
	message(
		PCLASS==0 ? NOTE : (PCLASS<4 ? FATAL : DEADLY),
		string[PMSGTEXT],
		PGRAMLINE,
		&POS);
}
