/* $Id: p.pars.frame,v 8.0.1.7 91/04/16 11:34:08 tony Exp $ */

/**********************************************************************/
/*                                                                    */
/*            Schnittstelle Eingabe/Ausgabe                           */
/*                                                                    */
/**********************************************************************/

#include <stdio.h>
#include "err.h"
#include "gla.h"

typedef int TERMINALSYMBOL;

typedef
  struct
  { POSITION        Pos;
    TERMINALSYMBOL  SyntaxCode;
    int Attr;
  } GRUNDSYMBOLDESKRIPTOR;

#include "parse.h"

#if defined(__cplusplus) || defined(__STDC__)
void
LiesGrundSymbol(GRUNDSYMBOLDESKRIPTOR *ZG)
#else
void
LiesGrundSymbol(ZG)
GRUNDSYMBOLDESKRIPTOR  *ZG;
#endif
{
	ZG->SyntaxCode = glalex( (char *)&(ZG->Attr) );
	ZG->Pos = curpos;
}

#if defined(__cplusplus) || defined(__STDC__)
void
FehlerDeskriptor(TERMINALSYMBOL T, POSITION *ZPos, GRUNDSYMBOLDESKRIPTOR *ZG)
#else
void
FehlerDeskriptor(T, ZPos, ZG)
TERMINALSYMBOL T; POSITION *ZPos; GRUNDSYMBOLDESKRIPTOR *ZG;
#endif
{
	ZG->Pos = *ZPos;
	ZG->SyntaxCode = T;
	ZG->Attr = 0;
}

static int severity[] = {DEADLY, DEADLY, DEADLY, FATAL, DEADLY, NOTE};
static char *text[] = {
	"",			/* 0 */
	"",			/* 1 */
	"Wrong parse tables",	/* 2 */
	"Parse stack overflow",	/* 3 */
	"",			/* 4 */
	"Syntax error",		/* 5 */
	"Symbol inserted",	/* 6 */
	"Symbol deleted",	/* 7 */
	"Parsing resumed here"};/* 8 */

#if defined(__cplusplus) || defined(__STDC__) 
void
FehlerMeldung(int Klasse, int Schluessel, POSITION *ZPos, GRUNDSYMBOLDESKRIPTOR *ZG)
#else
void
FehlerMeldung(Klasse, Schluessel, ZPos, ZG)
int Klasse, Schluessel; POSITION *ZPos; GRUNDSYMBOLDESKRIPTOR *ZG;
#endif
/* Klasse     : deadly error       = 1  repair          = 4           */
/*              limitation         = 2  information     = 5           */
/*              error              = 3                                */
/*                                                                    */
/* Schluessel : wrong parse tables = 2  symbol inserted = 6           */
/*              stack overflow     = 3  symbol deleted  = 7           */
/*              syntax error       = 5  restart point   = 8           */
/*                                                                    */
/* *ZPos      : error location                                        */
/*                                                                    */
/* *ZG        : token deleted or inserted by the error recovery       */
/*                                                                    */
/* when a syntax error occurs, the inserted or deleted tokens are     */
/* reported. The succession of tokens is directed by the calling      */
/* sequence of this procedure. Additionally, the position of the      */
/* next correct input token is reported.                              */
{
	if (Klasse != 4) message(severity[Klasse],text[Schluessel],0,ZPos);
}

/**********************************************************************/

/**********************************************************************/
/*                                                                    */
/*            Zerteilergroessen                                       */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/*            Zerteilerkonstanen                                      */
/**********************************************************************/

/* Date should go here */
#define    ZEMAXTERMINALCODE 29
#define    ZEMAXRSLAENGE     9
#define    ZEANZZST          66
#define    ZEMAXTEINTRAG     180
#define    ZEMAXNTEINTRAG    92
#define    ZEMAXTE1          66
#define    ZEMAXTE2          123
#define    ZEMAXNTE          66
#define    ZEANZNT           42
#define    ZEANZPROD         57
#define    ZEMAXTNEXT        102
#define    ZEMAXTCHECK       128
#define    ZEMAXNTNEXT       110
#define    ZETINDEX          ZEMAXTERMINALCODE / M_BITS
#define    ZESTOPSYMBOL      1

/**********************************************************************/
/*            Zerteilertypen und -makros                              */
/**********************************************************************/

typedef unsigned char   K_TYP1;    /* 1 Byte  unsigned */
typedef unsigned short  K_TYP2;    /* 2 Bytes unsigned */
typedef unsigned short  M_TYP;     /* Komponententyp des Mengenfeldes */
#define M_BITS  16                 /* (Bits pro Byte) * sizeof(M_TYP) */
#define M_SHIFT 4                  /* ld(M_BITS) */
#define M_MASKE 017                /* Maske : (M_BITS - 1) */
#define M_DIV(x) (x >> M_SHIFT)    /* x DIV M_BITS */
#define M_MOD(x) (x & M_MASKE)     /* x MOD M_BITS */
#define INMENGE(m,x) (*(m + M_DIV(x)) >> M_MOD(x) & 01)
#define ZUMENGE(m,x) (*(m + M_DIV(x)) |= 01 << M_MOD(x))


/**********************************************************************/
/*            Zerteilertabellen                                       */
/**********************************************************************/

static  K_TYP1    TBase[ ZEANZZST + 1]  =
{   0,    38,     0,     0,     0,     0,     0,     0,     0,     2,
    3,    11,     5,     0,    74,    16,    67,    67,     1,    65,
    0,     0,    84,    79,     0,    66,    80,     0,     0,    89,
   67,     0,    71,    30,     8,    85,    68,    37,     5,    47,
   85,     0,    88,    40,    32,    72,     0,     2,     0,    78,
    0,    79,    58,    33,     0,     0,    22,    84,     0,     0,
   60,    91,    32,    91,    99,    93,    72 };

static  K_TYP1    TNext[ ZEMAXTNEXT + 1]  =
{   0,   151,   154,   152,   151,   154,   174,    31,    19,   174,
   21,   151,   154,   174,   111,   151,   154,   151,   154,   151,
  154,    48,    32,    20,    99,   153,   174,   174,   151,   154,
  175,   109,   110,   175,   109,   110,   175,   175,   114,   175,
  177,   175,     2,   177,     3,    22,   177,   177,     6,   177,
    4,   177,     5,   106,   107,   108,   169,   169,   109,   110,
  106,   107,   108,   106,   107,   108,     7,   173,   173,   176,
   64,   155,   159,    42,    51,   155,   159,    41,    50,    25,
  180,   162,    54,    27,    24,    28,   180,   100,   101,   103,
  161,    49,   162,   115,   113,    53,    58,    59,    63,    65,
  121,    93,   122 };

static  K_TYP1    TCheck[ ZEMAXTCHECK + 1]  =
{   0,     8,    18,     9,     8,    18,    55,    47,    10,    55,
   12,     8,    18,    55,    38,     8,    18,     8,    18,     8,
   18,    34,    47,    11,    47,    15,    55,    55,     8,    18,
   56,    38,    38,    56,    34,    34,    56,    56,    44,    56,
   62,    56,     1,    62,    53,    15,    62,    62,    53,    62,
   53,    62,    53,    33,    33,    33,    39,    39,    44,    44,
   37,    37,    37,    43,    43,    43,     1,    52,    52,    60,
   60,    19,    25,    30,    36,    19,    25,    30,    36,    14,
   66,    32,    45,    16,    14,    17,    66,    22,    23,    26,
   29,    35,    32,    45,    40,    42,    49,    51,    57,    61,
   63,    64,    65,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0 };

static  K_TYP1    TZDefault[ ZEANZZST + 1]  =
{   0,    53,    64,    64,    64,    64,    64,    64,     0,     0,
    0,     0,     0,    15,     0,     0,     0,     0,     0,    64,
   47,    64,     0,     0,    64,    64,     0,    47,    64,     1,
    0,    47,    64,    34,     0,     0,     0,    38,     0,     0,
    0,    64,     0,    44,     0,     0,    47,    64,    53,     0,
   64,     0,     0,     0,    64,    43,     0,     0,    64,    64,
    0,     0,     0,     0,     0,     0,    53 };



static  K_TYP1    NtBase[ ZEANZZST + 1]  =
{   0,     0,    62,    68,    32,    22,    50,    79,     0,     0,
    0,     0,     0,    35,     0,    82,     0,     0,     0,    38,
   13,    60,    60,     0,    33,    47,     0,    14,    55,    23,
    0,    25,    28,    49,    49,     0,     0,    49,    49,    63,
    0,    58,     0,    49,    49,     0,    42,    39,     4,     0,
   61,     0,    67,     9,    64,    49,    91,     0,    69,    71,
   69,     0,    95,     0,     1,     0,    14 };

static  K_TYP1    NtNext[ ZEMAXNTNEXT + 1]  =
{   0,     1,     9,     0,    29,     0,    18,     0,     8,     8,
    8,     8,     8,     8,    56,    56,    56,    56,    57,    56,
   56,    56,    56,    61,    91,    91,    91,    91,    80,    79,
   92,    81,    81,    81,    81,    81,    81,    34,    38,    90,
   15,    74,    74,    33,    37,    33,    37,    75,    75,    44,
   69,    77,    13,    74,    23,    43,    74,    43,    14,    75,
   69,    69,    82,    45,    30,    72,    73,    74,    12,    14,
   74,    84,    55,    75,    55,    74,    75,    40,    70,    16,
   46,    78,    47,    79,    36,    83,    73,    10,    74,    74,
   67,    11,    74,    39,    35,    85,    68,    74,    86,    74,
   17,    26,    76,    87,    52,    88,    60,    71,    62,    89,
   66 };

static  K_TYP1    LS[ ZEANZPROD + 1 ]  =
{   0,    25,    23,    36,    29,    21,    26,    27,    34,    32,
   19,    18,    37,    38,     4,     5,    35,    26,    30,    37,
   35,    20,    18,    39,    40,    16,    15,    28,     6,     1,
   19,     4,    26,    32,    42,    12,    37,    11,     2,    35,
   33,    33,    33,    31,    31,    10,    41,     9,    32,    32,
   39,    24,    17,    22,    15,    13,     8,    14 };

static  K_TYP1    LaengeRS[ ZEANZPROD + 1 ]  =
{   0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
    2,     3,     1,     1,     2,     1,     1,     3,     3,     3,
    3,     6,     6,     2,     2,     1,     2,     1,     0,     1,
    0,     0,     0,     1,     1,     4,     0,     4,     3,     0,
    1,     1,     1,     1,     1,     5,     0,     5,     3,     3,
    0,     3,     0,     3,     0,     8,     9,     3 };

static  K_TYP1    FSymbol[ ZEANZZST + 1 ]  =
{   0,    28,     2,     2,     2,     2,     2,     2,     1,     1,
    5,    12,     5,     9,     5,     9,    16,    18,     1,     6,
   22,     2,     3,     9,     2,     6,     9,    22,     2,     1,
    6,    22,    10,    13,    13,     6,     6,     9,     9,     9,
    9,     2,     7,     6,     6,    21,    22,    22,    15,    18,
    2,    18,     9,    15,     2,     6,     8,    14,     2,     2,
    9,     8,     8,     9,     2,     9,     8 };

static  K_TYP1    RSymbol[ ZEANZZST + 1 ]  =
{   0,    28,     2,     2,     2,     2,     2,     2,     1,     1,
    5,    12,     5,     9,     5,     9,    16,    18,     1,     6,
   22,     2,     3,     9,     2,     6,     9,    22,     2,     1,
    6,    22,    10,    13,    13,     6,     6,     9,     9,     9,
    9,     2,     7,     6,     6,    21,    22,    22,    15,    18,
    2,    18,     9,    15,     2,     6,     8,    14,     2,     2,
    9,     8,     8,     9,     2,     9,     8 };

static  M_TYP    SemKlammer[ ZETINDEX + 1 ]  =
{0X2   ,  0X0    };

static  M_TYP    Ueberlesen[ ZETINDEX + 1 ]  =
{0X0   ,  0X0    };


/**********************************************************************/
/*            Weitere Konstantenvereinbarungen                        */
/**********************************************************************/

#define  UEBERSETZERFEHLER           1
#define  UEBERSETZERBESCHRAENKUNG    2
#define  SCHWERERFEHLER              3
#define  REPARATUR                   4
#define  KOMMENTAR                   5

#define  TABELLENFALSCH              2
#define  KELLERVOLL                  3
#define  SYNTAXFEHLER                5
#define  SYMBOLEINGEFUEGT            6
#define  SYMBOLGELOESCHT             7
#define  AUFSETZPUNKT                8

#define  STARTZUSTAND     1
#define  KEINZUSTAND      0

#define  KELLERENDE       150

/**********************************************************************/
/*            Zustandsgroessen des Zerteilers                         */
/**********************************************************************/

typedef
  K_TYP2                 ZERTEILERKELLER[KELLERENDE + 1];

typedef
  GRUNDSYMBOLDESKRIPTOR  ATTRIBUTKELLER[KELLERENDE + 1];

typedef
  enum
  {  BehandleFehler, Lies, Reduziere, LiesReduziere, LiesNT,
     LiesNTReduziere
  }  ZERTEILERAKTION;

#define  ANZAHLAKTIONEN  6

typedef
  struct
  { ZERTEILERAKTION  Aktion;
    union
    {  K_TYP2           FolgeZustand;
       K_TYP2           ProduktionsNr;
    }  V;
  }  TABELLENEINTRAG;


static  ZERTEILERKELLER         Keller;
static  ATTRIBUTKELLER          AttributKeller;
static  GRUNDSYMBOLDESKRIPTOR   SynAttribut;
static  unsigned                Pegel;
static  TABELLENEINTRAG         Eintrag;
static  GRUNDSYMBOLDESKRIPTOR   GrundSym;
static  int                     gefunden;  

#if defined(__cplusplus) || defined(__STDC__)
static void
Abbruch(int Klasse, int Schluessel, POSITION  *ZPos)
#else
static void
Abbruch(Klasse, Schluessel, ZPos)
int        Klasse, Schluessel;
POSITION  *ZPos;
#endif
{
  FehlerMeldung(Klasse, Schluessel, ZPos,
                (GRUNDSYMBOLDESKRIPTOR *) NULL);
  (void)fprintf(stderr, "*** Abbruch\n");
  exit(1);
}



#if defined(__cplusplus) || defined(__STDC__) 
static void
TTabelle(K_TYP2 Z, TERMINALSYMBOL S, TABELLENEINTRAG *ZEintrag)
#else
static void
TTabelle(Z, S, ZEintrag)
K_TYP2            Z;
TERMINALSYMBOL    S;
TABELLENEINTRAG  *ZEintrag;
#endif

/**********************************************************************/
/*            Bestimmung des Eintrags der Terminaltabelle             */
/**********************************************************************/

{  K_TYP2    TabEintrag;
   unsigned  TIndex;

    for (;;) {

    if (TCheck [TIndex = TBase [Z] + S] == Z) {

      TabEintrag = TNext [TIndex];

      if (TabEintrag <= ZEMAXTE1)
      {
        ZEintrag->Aktion = Lies;
        ZEintrag->V.FolgeZustand = TabEintrag;
      }
      else if (TabEintrag <= ZEMAXTE2)
      {
        ZEintrag->Aktion = LiesReduziere;
        ZEintrag->V.ProduktionsNr = TabEintrag - ZEMAXTE1;
      }
      else
      {
        ZEintrag->Aktion = Reduziere;
        ZEintrag->V.ProduktionsNr = TabEintrag - ZEMAXTE2;
      } /* end if */

      break;

    } else {

      if ((Z = TZDefault [Z]) == KEINZUSTAND) {
        ZEintrag->Aktion = BehandleFehler;
        break;
      }

    } /* end if */

    } /* end for */


}

#if defined(__cplusplus) || defined(__STDC__) 
static void
NTabelle(K_TYP2 Z, K_TYP2 N, TABELLENEINTRAG  *ZEintrag)
#else
static void
NTabelle(Z, N, ZEintrag)
K_TYP2            Z, N;
TABELLENEINTRAG  *ZEintrag;
#endif

/**********************************************************************/
/*            Bestimmung des Eintrags der Nichtterminaltabelle        */
/**********************************************************************/

{  K_TYP2  TabEintrag;

    TabEintrag = NtNext [NtBase [Z] + N];

    if (TabEintrag <= ZEMAXNTE)
    { 
      ZEintrag->Aktion = LiesNT;
      ZEintrag->V.FolgeZustand = TabEintrag;
    }
    else
    {
      ZEintrag->Aktion = LiesNTReduziere;
      ZEintrag->V.ProduktionsNr = TabEintrag - ZEMAXNTE;
    }

}

#if defined(__cplusplus) || defined(__STDC__) 
static  int
InMenge(M_TYP *ZM, TERMINALSYMBOL X)
#else
static  int
InMenge(ZM, X)
M_TYP          *ZM;
TERMINALSYMBOL  X;
#endif
{
  return ( INMENGE(ZM, X) ); 
}

/**********************************************************************/
/*            Strukturanknuepfungen                                   */
/**********************************************************************/

#if defined(__cplusplus) || defined(__STDC__) 
static void
StrukturAnknuepfung(unsigned PR, GRUNDSYMBOLDESKRIPTOR *ZAttributKeller)
#else
static void
StrukturAnknuepfung(PR, ZAttributKeller)
unsigned  PR;
register GRUNDSYMBOLDESKRIPTOR  *ZAttributKeller;
#endif
{

  switch (PR) {
  case   1: SourceNode(13,ZAttributKeller); break;
  case   2: SourceNode(17,ZAttributKeller); break;
  case   3: SourceNode(38,ZAttributKeller); break;
  case   4: SourceNode(16,ZAttributKeller); break;
  case   5: SourceNode(37,ZAttributKeller); break;
  case   6: SourceNode(11,ZAttributKeller); break;
  case   7: SourceNode(14,ZAttributKeller); break;
  case   8: SourceNode(36,ZAttributKeller); break;
  case   9: SourceNode(19,ZAttributKeller); break;
  case  10: SourceNode(42,ZAttributKeller); break;
  case  11: SourceNode(29,ZAttributKeller); break;
  case  12: SourceNode(34,ZAttributKeller); break;
  case  13: SourceNode(40,ZAttributKeller); break;
  case  15: SourceNode(3,ZAttributKeller); break;
  case  16: SourceNode(31,ZAttributKeller); break;
  case  17: SourceNode(12,ZAttributKeller); break;
  case  18: SourceNode(18,ZAttributKeller); break;
  case  19: SourceNode(35,ZAttributKeller); break;
  case  20: SourceNode(32,ZAttributKeller); break;
  case  21: SourceNode(27,ZAttributKeller); break;
  case  22: SourceNode(28,ZAttributKeller); break;
  case  24: SourceNode(3,ZAttributKeller); break;
  case  25: SourceNode(3,ZAttributKeller); break;
  case  27: SourceLeaf(ZAttributKeller); break;
  case  28: SourceNode(2,ZAttributKeller); break;
  case  29: SourceNode(1,ZAttributKeller); break;
  case  30: SourceNode(41,ZAttributKeller); break;
  case  32: SourceNode(10,ZAttributKeller); break;
  case  33: SourceNode(21,ZAttributKeller); break;
  case  34: SourceLeaf(ZAttributKeller); break;
  case  35: SourceNode(6,ZAttributKeller); break;
  case  36: SourceNode(33,ZAttributKeller); break;
  case  37: SourceNode(5,ZAttributKeller); break;
  case  38: SourceNode(4,ZAttributKeller); break;
  case  39: SourceNode(30,ZAttributKeller); break;
  case  40: SourceNode(22,ZAttributKeller); break;
  case  41: SourceNode(23,ZAttributKeller); break;
  case  42: SourceNode(24,ZAttributKeller); break;
  case  43: SourceNode(25,ZAttributKeller); break;
  case  44: SourceNode(26,ZAttributKeller); break;
  case  45: SourceNode(15,ZAttributKeller); break;
  case  46: SourceNode(2,ZAttributKeller); break;
  case  47: SourceNode(7,ZAttributKeller); break;
  case  49: SourceNode(20,ZAttributKeller); break;
  case  51: SourceNode(18,ZAttributKeller); break;
  case  52: SourceNode(2,ZAttributKeller); break;
  case  53: SourceNode(39,ZAttributKeller); break;
  case  55: SourceNode(8,ZAttributKeller); break;
  case  56: SourceNode(9,ZAttributKeller); break;
  case  57: SourceNode(4,ZAttributKeller); break;
  } /* end switch */

}



/**********************************************************************/
/*            Fehlerbehandlung - aufgesetzt                           */
/**********************************************************************/
#if defined(__cplusplus) || defined(__STDC__) 
static int
aufgesetzt(K_TYP2 Z)
#else
static int
aufgesetzt(Z)
K_TYP2  Z;
#endif

/* aufgesetzt = 1, falls im Zustand Z auf GrundSym.SyntaxCode     */
/*                 aufgesetzt werden kann.                        */
/* aufgesetzt = 0, sonst.                                         */

{
  TABELLENEINTRAG  E;

  TTabelle(Z, GrundSym.SyntaxCode, &E);
  return ( (E.Aktion == Lies) || (E.Aktion == LiesReduziere) );
}

/**********************************************************************/
/*            Fehlerbehandlung - FehlerSym                            */
/**********************************************************************/
#if defined(__cplusplus) || defined(__STDC__) 
static TERMINALSYMBOL
FehlerSym(K_TYP2 *ZK, unsigned P)
#else
static TERMINALSYMBOL
FehlerSym(ZK, P)
K_TYP2           *ZK;
unsigned          P;
#endif

/* FehlerSym = RSymbol[K[P]], falls RSymbol[K[P]] Separator ist und */
/* sich der Aufsetzpunkt dahinter befindet.                         */
/* FehlerSym = FSymbol[K[P]], sonst.                                */

{
  TERMINALSYMBOL    F, R;
  K_TYP2            Z;
  TABELLENEINTRAG   EF, ER;
  int               Separator;

  Z = *(ZK + P);
  F = FSymbol[Z]; R = RSymbol[Z];
  if (F == R)
    return F;
  else
  {
    TTabelle(Z, F, &EF); TTabelle(Z, R, &ER);
    if (ER.Aktion != EF.Aktion)
      Separator = 1;
    else
    { switch (ER.Aktion)
      { case BehandleFehler :
          Separator = 0;
          break;
        case Lies :
        case LiesNT :
          Separator = ER.V.FolgeZustand != EF.V.FolgeZustand;
          break;
        case Reduziere :
        case LiesReduziere :
        case LiesNTReduziere :
          Separator = ER.V.ProduktionsNr != EF.V.ProduktionsNr;
          break;
      }
    }
    if (Separator)
    {
      /* RSymbol[K[P]] ist Separator. Nun ist zu pruefen, ob sich  */
      /* dahinter der Aufsetzpunkt befindet.                       */
      while (1)
      { if (ER.Aktion == Reduziere)
          P--;
        switch (ER.Aktion)
        { case BehandleFehler :
            Abbruch(UEBERSETZERFEHLER, TABELLENFALSCH, &GrundSym.Pos);
            break;
          case Lies :
          case LiesNT :
            goto ZerteileEnde;
            break;
          case Reduziere :
          case LiesReduziere :
          case LiesNTReduziere :
            P = P - LaengeRS[ER.V.ProduktionsNr] + 1;
            NTabelle(*(ZK + P), LS[ER.V.ProduktionsNr], &ER);
            break;
        } /* end switch */
      } /* end while */

      ZerteileEnde :
      
      if (aufgesetzt(ER.V.FolgeZustand))
        return R;
      else
        return F;

    } /* end if */
    else return F;
  } /* end if */
}

/**********************************************************************/
/*            Fehlerbehandlung - SucheAufsetzPunkt - Erreichbar       */
/**********************************************************************/
#if defined(__cplusplus) || defined(__STDC__) 
static void
Erreichbar(K_TYP2 *ZKel, unsigned Peg, int SemKl)
#else
static void
Erreichbar(ZKel, Peg, SemKl)
K_TYP2    *ZKel;
unsigned   Peg;
int        SemKl;
#endif
{
  ZERTEILERKELLER  Kel;
  TERMINALSYMBOL   F;
  K_TYP2           Z;
  unsigned         i;
  TABELLENEINTRAG  E;
  int              halt;

  for (i = 0; i <= Peg; i++)
    Kel[i] = *(ZKel + i);


  /* Zunaechst wird mittels einer Kopie des Zerteilerzustandes durch  */
  /* Fortsetzung der Zerteilung geprueft, ob das aktuelle Grundsymbol */
  /* akzeptiert werden kann. Durch Erniedrigung des Kellerpegels wird */
  /* dafuer gesorgt, dass auch der aktuelle Zustand geprueft wird.    */

  E.Aktion =  LiesNT; E.V.FolgeZustand = Kel[Peg]; Peg--;
  halt = 0;

  while (1)
  {
    if (Peg == KELLERENDE)
      Abbruch(UEBERSETZERBESCHRAENKUNG, KELLERVOLL, &GrundSym.Pos);
    Peg++;

    switch(E.Aktion)
    {
      case Lies :
      case LiesReduziere :
        halt = (!SemKl) && InMenge(SemKlammer, F);
        break;
      case Reduziere :
        Peg--;
        break;
      case LiesNT :
      case LiesNTReduziere :
      case BehandleFehler :
        break;
    }

    switch(E.Aktion)
    {
      case BehandleFehler :
        Abbruch(UEBERSETZERFEHLER, TABELLENFALSCH, &GrundSym.Pos);
        break;

      case Lies :
      case LiesNT :
        Z = E.V.FolgeZustand;
        Kel[Peg] = Z;
        if (aufgesetzt(Z))
        { gefunden = 1; halt = 1;
        }
        else
        { F = FehlerSym(Kel, Peg);
          TTabelle(Z, F, &E);
        }
        break;
    
      case Reduziere :
      case LiesReduziere :
      case LiesNTReduziere :
        Peg -= LaengeRS[E.V.ProduktionsNr];
        NTabelle(Kel[Peg], LS[E.V.ProduktionsNr], &E);
        break;

    } /* end switch */

    if (halt || ((E.Aktion == LiesNT) &&
                 (E.V.FolgeZustand == STARTZUSTAND)))
      goto ZerteileEnde;

  } /* end while */

  ZerteileEnde : ;
}

/**********************************************************************/
/*            Fehlerbehandlung - SucheAufsetzPunkt                    */
/**********************************************************************/
static void
SucheAufsetzPunkt()

/* Es wird ein akzeptables Symbol gesucht, wobei eventuell Symbole  */
/* ueberlesen werden.                                               */

{

  gefunden = 0;
  do
  { if (GrundSym.SyntaxCode == ZESTOPSYMBOL)
      gefunden = 1;
    else
      if (!InMenge(Ueberlesen, GrundSym.SyntaxCode))
        Erreichbar(Keller, Pegel,
                   InMenge(SemKlammer, GrundSym.SyntaxCode));
    if (!gefunden)
    {
      FehlerMeldung(REPARATUR, SYMBOLGELOESCHT, &GrundSym.Pos,
                    &GrundSym);
      LiesGrundSymbol(&GrundSym);
    }
  } while (!gefunden);

  FehlerMeldung(KOMMENTAR, AUFSETZPUNKT, &GrundSym.Pos,
                (GRUNDSYMBOLDESKRIPTOR *) NULL);
}


/**********************************************************************/
/*            Fehlerbehandlung - ErreicheAufsetzPunkt                 */
/**********************************************************************/
static void
ErreicheAufsetzPunkt()
{
  TERMINALSYMBOL           F;
  K_TYP2                   Z;
  GRUNDSYMBOLDESKRIPTOR    FDeskr;
  int                      halt;


  /* Nun werden die gleichen Zerteileraktionen wie in Erreichbar  */
  /* wiederholt, diesmal aber mit semantischen Aktionen. Am Ende  */
  /* gilt die Invariante der Hauptzerteilerschleife wieder.       */
  /* Zunaechst wird wie in Erreichbar der Pegel zurueckgesetzt.   */

  Eintrag.Aktion = LiesNT;
  Eintrag.V.FolgeZustand = Keller[Pegel];
  SynAttribut = AttributKeller[Pegel]; /* da Sprung in 1. case - Anw. */
  Pegel--;
  halt = 0;

  while (1)
  {
    if(Pegel == KELLERENDE)
      Abbruch(UEBERSETZERBESCHRAENKUNG, KELLERVOLL, &GrundSym.Pos);
    Pegel++;

    switch(Eintrag.Aktion)
    {
      case Lies :
      case LiesReduziere :
        FehlerDeskriptor(F, &GrundSym.Pos, &FDeskr);
        FehlerMeldung(REPARATUR, SYMBOLEINGEFUEGT, &FDeskr.Pos,
                      &FDeskr);
        AttributKeller[Pegel] = FDeskr;
        break;

      case Reduziere :
        Pegel--;
        break;

      case LiesNT :
      case LiesNTReduziere :
        AttributKeller[Pegel] = SynAttribut;
        break;

      case BehandleFehler :
        break;
    }

    switch(Eintrag.Aktion)
    {
      case BehandleFehler :
        Abbruch(UEBERSETZERFEHLER, TABELLENFALSCH, &GrundSym.Pos);
        break;
      
      case Lies :
      case LiesNT :
        Z = Eintrag.V.FolgeZustand;
        Keller[Pegel] = Z;
        if (aufgesetzt(Z))
        { halt = 1;
          TTabelle(Keller[Pegel], GrundSym.SyntaxCode, &Eintrag);
        }
        else
        { F = FehlerSym(Keller, Pegel);
          TTabelle(Z, F, &Eintrag);
        }
        break;
                  
      case Reduziere :
      case LiesReduziere :
      case LiesNTReduziere :
        Pegel -= LaengeRS[Eintrag.V.ProduktionsNr];
        StrukturAnknuepfung(Eintrag.V.ProduktionsNr,
                            AttributKeller + Pegel);
        NTabelle(Keller[Pegel], LS[Eintrag.V.ProduktionsNr], &Eintrag);
        break;
    } /* end switch */

    if (halt || ((Eintrag.Aktion == LiesNT) &&
                 (Eintrag.V.FolgeZustand == STARTZUSTAND)))
      goto ZerteileEnde;

  } /* end while */

  ZerteileEnde:
  ;  
}

/**********************************************************************/
/*            Instandsetzung bei syntaktischen Fehlern                */
/**********************************************************************/

static void
FehlerBehandlung ()
{

  
  FehlerMeldung(SCHWERERFEHLER, SYNTAXFEHLER, &GrundSym.Pos,
                (GRUNDSYMBOLDESKRIPTOR *) NULL);
  
  SucheAufsetzPunkt();
  ErreicheAufsetzPunkt();
  
}


/**********************************************************************/
/*            Anfang des Zerteilers                                   */
/**********************************************************************/

void  Zerteiler()
{
  register  K_TYP2  *ZKeller;
  register  GRUNDSYMBOLDESKRIPTOR  *ZAttributKeller;
  register  unsigned  xZP;
  /* xZP enthaelt den Folgezustand bei einer Lies oder LiesNT   */
  /* Aktion. Erfolgt eine LiesReduziere, LiesNTReduziere oder   */
  /* Reduziere Aktion, so enthaelt xZP die Nummer der zu redu-  */
  /* zierenden Produktion. Daneben wird xZP beim Zugriff zur    */
  /* Terminal- bzw. Nichtterminaltabelle als Hilfsvariable zur  */
  /* Bestimmung der naechsten Zerteileraktion benutzt.          */

  ZKeller = Keller;
  ZAttributKeller = AttributKeller;
  xZP = STARTZUSTAND;

xLies :
  LiesGrundSymbol(&GrundSym);
xLiesNT :
  *++ZAttributKeller = GrundSym;
  *++ZKeller = xZP;
  if (ZKeller == Keller + KELLERENDE)
    Abbruch(UEBERSETZERBESCHRAENKUNG, KELLERVOLL, &GrundSym.Pos);
  /* Der Keller muss nur bei einer Lies oder LiesNT Aktion auf  */
  /* Ueberlauf geprueft werden, sofern fuer eine nachfolgende   */
  /* LiesReduziere oder LiesNTReduziere Aktion noch eine Keller-*/
  /* zelle frei bleibt.                                         */

/****************************************************************/
/*            Zugriff auf die Terminaltabelle                   */
/****************************************************************/
  {
    register TERMINALSYMBOL  S;
    unsigned  TIndex;

    S = GrundSym.SyntaxCode;

    for (;;)
    {

      if (TCheck [TIndex = TBase [xZP] + S] == xZP)
      {

        xZP = TNext [TIndex];

        if (xZP <= ZEMAXTE1)
        {
          goto xLies;
        }
        else if (xZP <= ZEMAXTE2)
        {
          xZP -= ZEMAXTE1;
          goto xLiesReduziere;
        }
        else
        {
          xZP -= ZEMAXTE2;
          goto xReduziere;
        }

      }
      else
      {
        if ((xZP = TZDefault [xZP]) == KEINZUSTAND)
        goto xBehandleFehler;
      }

    } /* end for */

  }
/**********************************************************************/

xLiesReduziere:
  LiesGrundSymbol(&GrundSym);
xLiesNTReduziere:
  *++ZAttributKeller = GrundSym;
  ZKeller++;
xReduziere:
  {
    register unsigned LngRS;

    LngRS = LaengeRS[xZP];
    ZKeller -= LngRS;
    ZAttributKeller -= LngRS;
  }
  StrukturAnknuepfung(xZP, ZAttributKeller);

/**********************************************************************/
/*            Zugriff auf die Nichtterminaltabelle                    */
/**********************************************************************/

  xZP = NtNext [NtBase [*ZKeller] + LS [xZP]];

  if (xZP <= ZEMAXNTE)
  { 
    if (xZP == STARTZUSTAND)
      goto ZerteilerEnde;
    else
      goto xLiesNT;
  }
  else
  {
    xZP -= ZEMAXNTE;
    goto xLiesNTReduziere;
  }

/**********************************************************************/

xBehandleFehler :
  Eintrag.Aktion = BehandleFehler;

  Pegel = ZKeller - Keller;

  FehlerBehandlung();

  if (Pegel == KELLERENDE)
    Abbruch(UEBERSETZERBESCHRAENKUNG, KELLERVOLL, &GrundSym.Pos);

  ZKeller = Keller + Pegel;
  ZAttributKeller = AttributKeller + Pegel;

  if (Eintrag.Aktion == LiesNT &&
      Eintrag.V.FolgeZustand == STARTZUSTAND) goto ZerteilerEnde;

  switch (Eintrag.Aktion)
  {
    case Lies :
      xZP = Eintrag.V.FolgeZustand;
      goto xLies; 

    case LiesReduziere :
      xZP = Eintrag.V.ProduktionsNr;
      goto xLiesReduziere;

    default :
      Abbruch(UEBERSETZERFEHLER, TABELLENFALSCH, &GrundSym.Pos);
      break;
   }

ZerteilerEnde: ;

}  /* Zerteilerende */

