(* $Id: tree.pp,v 7.6 91/06/23 16:23:45 waite Exp $ *)
(* Copyright, 1989, Universitaet Paderborn *)

#include "frame.h"
#include "attr.h"
#include "tree.h"
#include "connection.ext.h"


const

 (*  ERROR MESSAGES ACCORDING TO <USER>.C.SCANTAB:  *)
   INCLFAILSMSG       =   5; (* tree *)
   NODESTACKFULLMSG   =  12; (* tree and attr eval *)
   NODESTACKEMPTYMSG  =  13; (* tree *)


var

  CURRTOK, INSERTTOK : NODEPTR;
  NODESTACK : array [1..MAXTREEDEPTH] of NODEPTR;

LASTCURRNODE : NODEPTR;

procedure PUSHNODE  (* (PTR : NODEPTR) *);
begin
  if NODESTACKTOP >= MAXTREEDEPTH
  then MESSAGE(SYSLIMIT,NODESTACKFULLMSG,0,GLOBPOS.LINE,GLOBPOS.COL);
  NODESTACKTOP:=NODESTACKTOP+1;
  NODESTACK[NODESTACKTOP]:=PTR;
end; (* PUSHNODE *)

function POPNODE  (* : NODEPTR *) ;
var RESULT : NODEPTR;   (* P240-ERROR!!*)
begin
  if NODESTACKTOP <= 1  (* 1 : DUMMYNODE!! *)
  then MESSAGE(SYSERROR,NODESTACKEMPTYMSG,0,GLOBPOS.LINE,GLOBPOS.COL);
  RESULT:=NODESTACK[NODESTACKTOP];
  NODESTACKTOP:=NODESTACKTOP-1;
   POPNODE := RESULT;
end; (* POPNODE *)

procedure INCLUDING  (* (     INCLKEY : INCLRANGE;
                         var HIVAR   : UNIONTYPE ) *) ;
var NOTFOUND : Boolean;
    INCLTOP  : 1..MAXTREEDEPTH;
begin
 NOTFOUND := true; INCLTOP := NODESTACKTOP;
 while (INCLTOP > 1) and NOTFOUND do
 begin
  with NODESTACK[INCLTOP]^ do 
  if RULE <> LISTRULE (* EMPTYRULE AND TERMRULE CANNOT OCCUR *)
  then
  case INCLKEY of

1:if NTSEL=N304OIL then begin
     NOTFOUND:=false;
     HIVAR.C307tEnv:=A304305defEnv
     end;
3:if NTSEL=N312xStmt then begin
     NOTFOUND:=false;
     HIVAR.C307tEnv:=A312306refEnv
     end;
5:if NTSEL=N315xParamList then begin
     NOTFOUND:=false;
     HIVAR.C307tEnv:=A315305defEnv
     end;
6:if NTSEL=N308xStmtList then begin
     NOTFOUND:=false;
     HIVAR.C154tOilClass:=A308214class
     end;
17:if NTSEL=N304OIL then begin
     NOTFOUND:=false;
     HIVAR.C307tEnv:=A304306refEnv
     end;
24:if NTSEL=N304OIL then begin
     NOTFOUND:=false;
     HIVAR.COLIST:=A304254identMap
     end;

(*&END GEN INCLUDE*)
  end;  (* CASE INCLKEY *)
  INCLTOP := INCLTOP - 1;
 end;   (* WHILE *)
 if NOTFOUND then
  MESSAGE(INCLFAILS,INCLFAILSMSG,0,CURRNODE^.POS.LINE,CURRNODE^.POS.COL);
end;    (* INCLUDING *)

function ANCRULETEST  (* : RULENRS  *) ;
       (*===========*)
var  STACKIND : 0 .. MAXTREEDEPTH;
begin
   if NODESTACK[NODESTACKTOP]^.RULE = LISTRULE
   then STACKIND := NODESTACKTOP - 1
   else STACKIND := NODESTACKTOP;
(* ASSERT(NOT NODESTACK[STACKIND]^.RULE IN [EMPTYRULE,LISTRULE..]); *)
   ANCRULETEST := NODESTACK[STACKIND]^.RULE ;
end;

procedure TREENEXT;
(* Move to root of next tree to be evaluated.
   If nil evaluation stops *)
begin
  if NODESTACKTOP = 2
  then begin
 (* first call:  root of tree after construction *)
    CURRNODE := NODESTACK[2];
    NODESTACKTOP := 1;
  end else CURRNODE := nil;
 (* second call: nil after last TREEANCESTOR *)
end;

procedure TREEANCESTOR;
(*  move to ancestor *)
begin
(* assumes that bottom stack element is NIL *)
  LASTCURRNODE := CURRNODE;
  CURRNODE := NODESTACK [NODESTACKTOP];
  NODESTACKTOP := NODESTACKTOP - 1;
end;

procedure TREEDESCENDANT  (* (I : integer) *) ;
(*  move to I-th descendant *)
begin
  if NODESTACKTOP >= MAXTREEDEPTH
  then MESSAGE(SYSLIMIT,NODESTACKFULLMSG,0,CURRNODE^.POS.LINE,CURRNODE^.POS.COL);
  NODESTACKTOP := NODESTACKTOP + 1;
  NODESTACK [NODESTACKTOP] := CURRNODE;
  CURRNODE := CURRNODE^.SONS;
  while I > 1 
  do begin CURRNODE := CURRNODE^.BROTHER; I := I - 1; end;
end;

procedure TREEFIRSTELEM;
(*  move to first element of a listnode *)
begin
  if NODESTACKTOP >= MAXTREEDEPTH
  then MESSAGE(SYSLIMIT,NODESTACKFULLMSG,0,CURRNODE^.POS.LINE,CURRNODE^.POS.COL);
  NODESTACKTOP := NODESTACKTOP + 1;
  NODESTACK [NODESTACKTOP] := CURRNODE;
  CURRNODE := CURRNODE^.ELEMS;
end;

procedure TREEBROTHER;
(* PRE: be at a list node, reached by an immediately
        preceeding TREEANCESTOR form an element *)
(*  move to next element of the listnode *)
begin
  NODESTACKTOP := NODESTACKTOP + 1;       (* list node is still on top *)
  CURRNODE := LASTCURRNODE^.BROTHER;
end;


(*===========================================================*)
(* Functions for parser driven tree construction             *)
(*===========================================================*)

procedure EMPTYLIST   (*ELZAHL:integer*) ;
         (*========*)

var NODEVAR  : NODEPTR;
    I : integer;

begin

(* IF ELZAHL > 0  THEN *)
   begin

        for I := 1 to ELZAHL do
        begin
          new(NODEVAR,LISTRULE);
          NODEVAR^.RULE      := LISTRULE;
          NODEVAR^.ELEMS     := nil;
          NODEVAR^.BROTHER   := nil;
          PUSHNODE(NODEVAR);
        end;


  end;(* ELSE ELZAHL = 0 *)

end; (* EMPTYLIST *)

procedure ANFLIST   (* ELZAHL : integer *)  ;
        (*=======*)

var NODEVAR : NODEPTR ;
    I       : integer ;

begin

(* IF ELZAHL > 0 THEN *)
   begin for I := 0 to ELZAHL-1 do
           begin new ( NODEVAR,LISTRULE ) ;
                 with NODEVAR^ do
                 begin RULE := LISTRULE ;
                       ELEMS := NODESTACK [ NODESTACKTOP - I ] ;
                       BROTHER := nil
                 end ;
                 NODESTACK [ NODESTACKTOP - I ] := NODEVAR
           end ;
   end;(* ELSE ELZAHL = 0 *)
end ; (* PROCEDURE ANFLIST *)


procedure CONTLIST   (* ELZAHL : integer *)  ;
        (*========*)

var NODEVAR : NODEPTR ;
    I       : integer ;

begin

(* IF ELZAHL > 0 THEN *)
   begin for I := 1 to ELZAHL do
         begin NODEVAR := NODESTACK [ NODESTACKTOP - ELZAHL ]^.ELEMS ;
               while NODEVAR^.BROTHER <> nil
                  do NODEVAR := NODEVAR^.BROTHER ;
               NODEVAR^.BROTHER := POPNODE
         end
   end;(* ELSE ELZAHL = 0 *)

end ; (* PROCEDURE CONTLIST *)


procedure EMPTYNODE   (*I : integer*)  ;
        (*=========*)

var J : integer;
    NODEVAR : NODEPTR;

begin
   if I > 0 then
   for J := 1 to I do
   begin
     new(NODEVAR,EMPTYRULE);
     NODEVAR^.RULE := EMPTYRULE;
     NODEVAR^.BROTHER := nil;
     PUSHNODE(NODEVAR);
   end;


end; (* EMPTYNODE *)

procedure MAKENONODE  (NTIND: NTNRS) ;

begin

end; (*MAKENONODE*)

procedure MAKENODE   (*RULEIND: RULENRS;
                      NTIND  : NTNRS;
                      SUCCS  : POSINT*)  ;

var I : integer;
    SONSPTR, NODEVAR : NODEPTR;

begin

case RULEIND of 

     
          R410GEN:new(NODEVAR,R410GEN,N304OIL);
          R411GEN:new(NODEVAR,R411GEN,N308xStmtList);
          R412GEN:new(NODEVAR,R412GEN,N312xStmt);
          R413GEN:new(NODEVAR,R413GEN,N314xParamTypeDef);
          R414GEN:new(NODEVAR,R414GEN,N326xParamId);
          R415GEN:new(NODEVAR,R415GEN,N315xParamList);
          R417GEN:new(NODEVAR,R417GEN,N315xParamList);
          R418GEN:new(NODEVAR,R418GEN,N315xParamList);
          R419GEN:new(NODEVAR,R419GEN,N312xStmt);
          R420GEN:new(NODEVAR,R420GEN,N328xForId);
          R421GEN:new(NODEVAR,R421GEN,N312xStmt);
          R422GEN:new(NODEVAR,R422GEN,N332xTypeExprId);
          R423GEN:new(NODEVAR,R423GEN,N312xStmt);
          R424GEN:new(NODEVAR,R424GEN,N334xCoerSig);
          R425GEN:new(NODEVAR,R425GEN,N312xStmt);
          R426GEN:new(NODEVAR,R426GEN,N342xFuncSig);
          R427GEN:new(NODEVAR,R427GEN,N342xFuncSig);
          R428GEN:new(NODEVAR,R428GEN,N329xTypeExpr);
          R429GEN:new(NODEVAR,R429GEN,N329xTypeExpr);
          R430GEN:new(NODEVAR,R430GEN,N329xTypeExpr);
          R431GEN:new(NODEVAR,R431GEN,N329xTypeExpr);
          R432GEN:new(NODEVAR,R432GEN,N345xBinOp);
          R433GEN:new(NODEVAR,R433GEN,N345xBinOp);
          R434GEN:new(NODEVAR,R434GEN,N345xBinOp);
          R435GEN:new(NODEVAR,R435GEN,N345xBinOp);
          R436GEN:new(NODEVAR,R436GEN,N345xBinOp);
          R437GEN:new(NODEVAR,R437GEN,N347xTypeList);
          R438GEN:new(NODEVAR,R438GEN,N347xTypeList);
          R439GEN:new(NODEVAR,R439GEN,N347xTypeList);
          R440GEN:new(NODEVAR,R440GEN,N343xArgSig);
          R441GEN:new(NODEVAR,R441GEN,N343xArgSig);
          R442GEN:new(NODEVAR,R442GEN,N343xArgSig);
          R443GEN:new(NODEVAR,R443GEN,N338xTypeId);
          R444GEN:new(NODEVAR,R444GEN,N312xStmt);
          R445GEN:new(NODEVAR,R445GEN,N350xIndDef);
          R446GEN:new(NODEVAR,R446GEN,N337xOpDef);
          R447GEN:new(NODEVAR,R447GEN,N351xOpList);
          R448GEN:new(NODEVAR,R448GEN,N310xOpRef);
          R449GEN:new(NODEVAR,R449GEN,N335xOpCost);
          R450GEN:new(NODEVAR,R450GEN,N335xOpCost)
     
(*&END GEN INCLUDE*)

end; (*case RULEIND*)

NODEVAR^.RULE:=RULEIND;
(* IF NOT (RULEIND IN [EMPTYRULE, LISTRULE,  TERMRULE] THEN *)
(* EMPTYRULE , LISTRULE, TERMRULE KOMMT ABER NICHT VOR *)
   with NODEVAR^ do
   begin
     NTSEL := NTIND; 
     POS := GLOBPOS;
     BROTHER := nil;

     SONS := nil;
     for I := SUCCS downto 1 do
     begin
        SONSPTR := POPNODE;
        SONSPTR^.BROTHER := SONS;
        SONS := SONSPTR;
     end;
   end;
   PUSHNODE(NODEVAR);

end;

(*===========================================================*)
(* PGS-Parser interface routines:                            *)
(*===========================================================*)

procedure SourceLeaf(var D: GRUNDSYMBOLDESKRIPTOR );
begin
  if INSERTTOK = nil
  then begin
    CURRTOK^.TERMSEL:=D.SYNTAXCODE;
    CURRTOK^.TERMAT.TERMAT:=D.ATTR;
    PUSHNODE (CURRTOK);
    new (CURRTOK, TERMRULE); CURRTOK^.RULE:=TERMRULE;
  end else begin
    INSERTTOK^.TERMSEL:=D.SYNTAXCODE;
    INSERTTOK^.TERMAT.TERMAT:=D.ATTR;
    PUSHNODE (INSERTTOK); 
    INSERTTOK:=nil;
  end;
end;

(*
procedure SourceNode(PR : integer; var D: GRUNDSYMBOLDESKRIPTOR);
begin
  GLOBPOS := D.POS;
  case PR of
*)
(*&INCLUDE PGS_GEN_STRUKTURANKNUEPFUNGEN*)
(*&END GEN INCLUDE*)
(*
  end;

end;*) (*SourceNode*)

procedure SourceInit;
begin
  INSERTTOK:=nil;
  new (CURRTOK, TERMRULE); CURRTOK^.RULE:=TERMRULE;
  NODESTACKTOP := 1;
  NODESTACK[1] := nil;
  CURRNODE     := nil;
  GLOBPOS.LINE:=1; GLOBPOS.COL:=1;
end;

	(* Functions to construct new trees *)

function Leaf(*a: integer): NODEPTR*);
   (* Build a terminal node with attribute a *)
   var p: NODEPTR;
   begin new(p,TERMRULE); p^.BROTHER:=nil; p^.RULE:=TERMRULE;
   p^.TERMSEL:=0; p^.TERMAT.TERMAT:=a;
   Leaf:=p;
   end;

function Link(*f,r: NODEPTR): NODEPTR*);
   (* Make r the brother of f *)
   begin
   if (f=nil) or (r=nil) then Link:=nil
   else begin f^.BROTHER:=r; Link:=f end;
   end;

function Rule(*r: integer; s: NODEPTR): NODEPTR*);
   (* Build a node for rule r with sons s *)
   var p: NODEPTR;
   begin
   if s=nil then Rule:=nil
   else
      begin new(p); p^.BROTHER:=nil; p^.RULE:=r;
      p^.POS:=GLOBPOS; p^.SONS:=s; p^.NTSEL:=1;
      Rule:=p;
      end;
   end;

function Tree(*n: integer; t: NODEPTR): boolean*);
   (* Establish a tree to be processed
      On entry-
         The root is current
      On exit-
         The nth subtree of the root is t
   *)
   var p: NODEPTR;
   begin
   if t<>nil then
      begin p:=CURRNODE^.SONS;
      while n>2 do begin n:=n-1; p:=p^.BROTHER end;
      p^.BROTHER:=t;
      end;
   Tree:=true;
   end;

function Bottom(*: NODEPTR*);
   (* Establish an invalid tree *)
   begin
   Bottom:=nil;
   end;

function Empty(*: NODEPTR*);
   (* Establish an empty optional tree *)
   var p: NODEPTR;
   begin
   new(p,EMPTYRULE); p^.BROTHER:=nil; p^.RULE:=EMPTYRULE;
   Empty:=p;
   end;

function EmptyL(*: NODEPTR*);
   (* Establish an empty list *)
   var p: NODEPTR;
   begin
   new(p,LISTRULE); p^.BROTHER:=nil; p^.RULE:=LISTRULE; p^.ELEMS:=nil;
   EmptyL:=p; 
   end; 
 
function List(*l: NODEPTR): NODEPTR*);
   (* Establish a list node
      On entry-
         l=root of the list
   *)
   var p: NODEPTR;
   begin
   if l=nil then List:=nil
   else
      begin new(p,LISTRULE); p^.BROTHER:=nil; p^.RULE:=LISTRULE;
      p^.ELEMS:=l;
      List:=p;
      end;
   end;


