#ifndef OILADT2_H
#define OILADT2_H
/*
  $Id: oiladt2.h,v 1.15 1991/12/24 08:32:45 waite Exp $
Copyright, 1989, The Regents of the University of Colorado
*/

#define ForDebugging 1

/* 'ForDebugging' is used by 'oiladt2b.c' to select the output of the
        compiler which contains the 'sID' component.  Originally designed to be
	removed for a 'release' to save space but never seen as worthwhile.
	*/

#define WithIDs 1

/* 'WithIDs' indicates that an extract 'sID' component is maintained in 
	the data structures.  This, sID, field is a unique number 
	associated with each object for use in inter-object references 
	when 'dumping' the objects out to a file in form suitible for 
	compilation.
	  The field sStat is used to mark those fields which have been
	visited while dumping and need not be dumped again.  This field
	is also used to emit 'extern' stmts as necessary;
	*/
#ifdef WithIDs
#define OilDefID int sID, sStat;
#else
#define OilDefID
#endif

/*
#define oilName char *
*/
#define oilName int

#define BOOL int
#define TRUE 1
#define FALSE 0
#define nil 0

typedef struct Stype {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;		/* type denotation */
	struct ScoercionSeq
		*sCoercionCosts;/* coercions from this type to others */
	struct Ssig *sSigs;	/* signatures whose 'top' type is this */
	struct StypeSet
		*sResultSets;	/* RSs whose last element is this */
	struct Sop *sOps;	/* Ops which result in this type */
	} *tOilType;

typedef struct Ssig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct Ssig *sNext;	/* next argument type in signature */
	tOilType sArg;		/* a specific type */
	struct Ssig *sSameType;	/* other sigs which end in this type */
	} *tOilArgSig;

typedef struct Sop {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;	/* operator denotation */
	int sCost;	/* its cost */
	tOilArgSig sArgs;	/* type signature of arguments */
	struct Sop *sSameType;	/* other ops with the same result type */
	struct SopIdent *sIndOps; /* the identifiable ops */
	} *tOilOp;

typedef struct ScoercionSeq {
	OilDefID /* used in compiler and debugging but not in release version */
	tOilType sResultType;	/* type of result of coercion sequence */
	struct ScoercionSeq
		*sNextCost;/* next coercion which can be applied to this type */
	tOilOp sCoercionOp;	/* the coercion operator used here */
	struct ScoercionSeq
		*sCoercionSeq;	/* rest of coercion sequence */
	int sCost;		/* total cost of coercion sequence */
	} *tOilCoercionSeq;

typedef struct StypeSet {
	OilDefID /* used in compiler and debugging but not in release version */
	tOilType sBaseType;	/* 'A' type which can be directly referrenced */
	struct StypeSet
		*sNext;	/* the other types which can be directly referenced */
	int sCost;		/* the cost to get to this type */
	struct StypeSet
		*sSameType;	/* other sets with this base type */
	} *tOilTypeSet;

typedef struct SsetSig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SsetSig *sNext;	 /* next in signature list */
	tOilTypeSet sResultTypes;/* list of possible argument types */
	} *tOilSetSig;

typedef struct SopIdent {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SopIdent *sNext;/* next in list */
	tOilOp sOp;			/* which op to identify */
	} *tOilOpIdentification;

typedef enum{
	eClassRef,	/* refers to the created type */
	eElementRef,	/* refers to the element used to derive type */
	eSpecTypeRef	/* refers to a specific type */
	} tOilClassSigArgDesc;

typedef struct SclassArgSig {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassArgSig *sAnother;	/* tail sharing ptr */
	struct SclassArgSig *sNext;	/* next in list */
	tOilClassSigArgDesc sDescPattern;
	tOilType sRefdType;		/* possibly refers to a specific type */
	int sParamIndex;		/* or a specific parameter */
	} *tOilClassArgSig;

typedef struct SclassOp {
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassOp *sNext;
	oilName sName;		/* operator denotation */
	tOilClassArgSig sArgDesc;	/*  list of argument descriptions */
	int sCost;		/* cost of operator */
	BOOL isCoercion;	/* defs a coercion */
	struct SclassOpId *sIdents;	/* indications */
	} *tOilClassOp;

typedef struct SclassOpId { 
	OilDefID /* used in compiler and debugging but not in release version */
	struct SclassOpId *sNext;/* next in list */
	tOilOp sOpInd;		/* which operator indication is enhanced */
	} *tOilClassOpId;

typedef struct Sclass {
	OilDefID /* used in compiler and debugging but not in release version */
	oilName sName;			/* class denotation */
	int sNumArg;			/* number of args to class */
	tOilClassOp sClassOps;	/* description of operator */
	} *tOilClass;

#define OilNew(ptr,str) (ptr)malloc(sizeof(struct str))

#define OilMaxCost 32000

extern tOilArgSig OilNewArgSig();	/* a zero length signature */

extern tOilArgSig OilAddArgSig();	/* ( arg, sig )
		tOilType arg;
		tOilArgSig sig; */



extern tOilSetSig OilNewSetSig() ; /* no args */
extern tOilSetSig OilAddSetSig();	/* ( arg, sig )
		tOilTypeSet arg;
		tOilSetSig sig; */



extern tOilOp OilNewOp();	/* ( id, sig, cost )
        oilName id;
	int cost;
	tOilArgSig sig;    */

extern tOilOp  OilErrorOp();

extern BOOL OilAddIdentification();  /* ( id, op )
	tOilOp id
	tOilOp op; */



extern tOilType OilNewType();  /* ( id ) */

extern tOilType OilErrorType();

/* define a new type of class 'c' with element type 'as' with name 'id' */
extern tOilType OilNewTypeInClass();  /* ( c, as, id )
	tOilClass c;
	tOilArgSig as;
	oilName id */



/* validate type t1 is coercible to t2 */
extern BOOL OilIsCoercibleTo();  /* ( t1, t2 ) tOilType t1, t2;*/

/* validate that type 't2' is in the type set 's1'	*/
extern BOOL OilSetIncludes();  /* ( s1, t2 ) tOilTypeSet s1; tOilType t2;*/

/* add a new type to the set of possible result types*/
extern tOilTypeSet OilAddResultType();  /* ( t, set,cost )
	tOilType t; tOilTypeSet set; int cost; */



/* Check the sets of possible actual argument types to see if they might
	be coerced to the corresponding formal type 
extern BOOL OilCanIdSigs();  /* ( src, dest )
	tOilSetSig src;
	tOilArgSig dest; */



/* check for valid coercion*/
extern BOOL OilisValidCS();  /* ( ccs ) tOilCoercionSeq ccs; */

/* check for valid operator*/
extern BOOL OilisValidOp();  /* ( op ) tOilOp op; */

/* return coercion sequence for coercing 't1' to 't2'*/
extern tOilCoercionSeq OilCoerce();  /* ( t1, t2 )
	tOilType t1, t2;
  */

extern BOOL OilEmptyCS(); /* ( cs )
        tOilCoercionSeq cs;
  */

extern tOilOp  OilHeadCS(); /* ( cs )
        tOilCoercionSeq cs;
  */

extern tOilCoercionSeq  OilTailCS(); /* ( cs )
    tOilCoercionSeq cs;
  */

extern tOilCoercionSeq  OilErrorCS();

extern void OilAddCoercion(); /* ( cop )
	tOilOp cop;
  */




/* find all possible result types which might be indicated by 'ind'
	with arguments 'setsig' */
extern tOilTypeSet OilIdResultSet();  /* ( ind, setsig )
	tOilOpIndication ind;
	tOilSetSig setsig; */

/* find the minimum operator cost which might be indicated by 'ind'
	with arguments 'setsig' and result type 'rt' */
extern tOilOp OilIdOpTSn();  /* ( ind, setsig, rt )
	tOilType rt;
	tOilOpIndication ind;
	tOilSetSig setsig; */

extern tOilTypeSet OilTypeToSet();  /* ( t ) tOilType t; */

extern tOilType OilBalance();  /* ( ts1, ts2 )
        tOilTypeSet ts1, ts2; */

#define OilSelectTypeFromTS(ts) OilBalance(ts,ts)

extern int OilMinimumCoercionSeq();  /* ( ts1, ts2, cost )
	tOilTypeSet ts1, ts2;
	int cost; */

extern int OilMinimumCoercionCost();  /* ( ts, t, cost )
	tOilTypeSet ts;
	tOilType t;
	int cost; */



extern tOilClass OilNewClass();  /* ( id, argNum )
	oilName id;
	int argNum;
  */

extern tOilClassArgSig OilNewClassSigArg(); /* returns nil */

extern tOilClassArgSig OilAddClassSigArg();  /* ( td, st, pi, cs )
	tOilClassSigArgDesc td;
	tOilType st;
	int pi;
	tOilClassArgSig cs;
  */

extern tOilClassOp OilAddClassOp();  /* ( id, sig, cost, c )
        oilName id;
        int cost;
        tOilClassArgSig sig;
        tOilClass c;
  */

extern BOOL OilAddClassOpId();  /* ( ind, op )
	tOilOpIndication ind;
        tOilClassOp op;
  */

extern BOOL OilAddClassCoercion();  /* ( op )
        tOilClassOp op;
  */

/* Get type of argument #n of operator 'op' */
extern tOilType OilGetArgType();  /* ( op, n )
	tOilOp op; int n;
  */

extern tOilTypeSet  OilIdResultTS1(); /* ( id, as1 ) */
extern tOilTypeSet  OilIdResultTS2(); /* ( id, as1, as2 ) */
extern tOilTypeSet  OilIdResultTS3(); /* ( id, as1, as2, as3 ) */

extern tOilOp  OilIdOpTS1(); /* ( rt, id, as1 ) */
extern tOilOp  OilIdOpTS2(); /* ( rt, id, as1, as2 ) */
extern tOilOp  OilIdOpTS3(); /* ( rt, id, as1, as2, as3 ) */

extern tOilOp  OilIdOp1(); /* ( id, at1 ) */
extern tOilOp  OilIdOp2(); /* ( id, at1, at2 ) */
extern tOilOp  OilIdOp3(); /* ( id, at1, at2, at3 ) */

extern int OilTypeName(); /* ( t ) */
extern int OilOpName(); /* ( op ) */
extern int OilClassName(); /* ( class ) */

extern tOilType  OilClassInst0(); /* ( c, id ) */
extern tOilType  OilClassInst1(); /* ( c, id, at1 ) */
extern tOilType  OilClassInst2(); /* ( c, id, at1, at2 ) */


extern int OilNextName(); /* ( dummy ) */

extern tOilType	OilTypeIndex();
extern tOilOp 	OilOpIndex();
extern tOilClass OilClassIndex();


/*
  For use by C
  */
char * OilNameToString(); /* ( index )
    int index; */
#endif
