#include <stdio.h>

static char rcsid[]="$Id: paste.c,v 1.1 1991/07/02 12:40:20 tony Exp $";
/* Copyright, 1991, The Regents of the University of Colorado */

main(argc,argv)
int argc; char *argv[];
/* Concatenate corresponding lines of two files
 *    On entry-
 *       argv[1]=name of the file containing "column 1" lines
 *       argv[2]=name of the file containing "column 2" lines
 *    On exit-
 *       standard output="two-column" material
 */
{
	char col1[BUFSIZ], col2[BUFSIZ];
	FILE *f, *g, *fopen();

	if (argc != 3) {
		(void)fprintf(stderr, "Usage %s file1 file2\n", argv[0]);
		exit(1);
	}

	if ((f = fopen(argv[1], "r")) == NULL) {
		(void)fprintf(stderr, "Could not open file %s\n", argv[1]);
		exit(1);
	}

	if ((g = fopen(argv[2], "r")) == NULL) {
		(void)fprintf(stderr, "Could not open file %s\n", argv[2]);
		exit(1);
	}

	while (fgets(col1, BUFSIZ, f) != NULL) {
		if (fgets(col2, BUFSIZ, g) == NULL) {
			(void)fprintf(stderr, "%s: unexpected EOF\n", argv[2]);
			exit(1);
		}
		col1[strlen(col1)-1] = '\0';
		(void)printf("%s\t%s", col1, col2);
	}

	if (fgets(col2, BUFSIZ, g) != NULL) {
		(void)fprintf(stderr, "%s: unexpected EOF\n", argv[1]);
		exit(1);
	}

	exit(0);
}
