
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG7 *_PPTG7;
struct _SPTG7{
  _PTGProc _print;
  PTGNode _desc [7];
};

typedef struct _SPTG6 *_PPTG6;
struct _SPTG6{
  _PTGProc _print;
  PTGNode _desc [6];
};

typedef struct _SPTG5 *_PPTG5;
struct _SPTG5{
  _PTGProc _print;
  PTGNode _desc [5];
};

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGIdentifier *_PPTGIdentifier;
struct _SPTGIdentifier{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGString *_PPTGString;
struct _SPTGString{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGNum *_PPTGNum;
struct _SPTGNum{
  _PTGProc _print;
  int _t0;
};

void _PrPTGCGen(n)
_PPTG1 n;
{
  fputs ("#include \"deftbl.h\"\n", f);
  fputs ("#include \"pdl_gen.h\"\n\n", f);
  fputs ("#define PRESENT find(key, _Property, &_Item, 0)\n", f);
  fputs ("#define VALUE (_Item->PropVal)\n\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

void _PrPTGOperationSpec(n)
_PPTG7 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(_Property, ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (")\n", f);
  fputs ("int _Property;\n", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("{  ", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs ("Property _Item;\n", f);
  (* (n->_desc [6]->_print))(n->_desc[6]);
  fputs ("\n}\n\n", f);
}

void _PrPTGParen(n)
_PPTG1 n;
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

extern void PrIdent();

void _PrPTGIdentifier(n)
_PPTGIdentifier n;
{
PrIdent(f,n->_t0);
}

void _PrPTGString(n)
_PPTGString n;
{
  fprintf (f, "%s",n->_t0);
}

void _PrPTGCommaSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGParamDecl(n)
_PPTG3 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
}

void _PrPTGSModifier(n)
_PPTG1 n;
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGEModifier(n)
_PPTG1 n;
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", ... )", f);
}

void _PrPTGPTypeSpec(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGIPTypeSpec(n)
_PPTG3 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGFuncName(n)
_PPTG1 n;
{
  fputs ("(*", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGTypeDef(n)
_PPTG3 n;
{
  fputs ("typedef struct ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("Elt {\n", f);
  fputs ("\tstruct ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("Elt *next;\n", f);
  fputs ("\tint selector;\n", f);
  fputs ("\tTYPE PropVal;\n", f);
  fputs ("} *", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("Property;\n\n", f);
}

void _PrPTGFunctions(n)
_PPTG3 n;
{
  fputs ("#define TYPE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n\n", f);
  fputs ("#define ACCESS find(key, _Property, &_Item, sizeof(struct ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("Elt))\n\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("#undef ACCESS\n", f);
  fputs ("#undef TYPE\n", f);
}

void _PrPTGHGen(n)
_PPTG3 n;
{
  fputs ("#ifndef PDL_GEN_H\n", f);
  fputs ("#define PDL_GEN_H\n\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n", f);
  fputs ("#endif\n", f);
}

void _PrPTGInclude(n)
_PPTG1 n;
{
  fputs ("#include \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\"\n", f);
}

void _PrPTGExternSpec(n)
_PPTG4 n;
{
  fputs ("extern ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(/* int _Property; ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs ("*/);\n", f);
}

void _PrPTGExtParamDecl(n)
_PPTG3 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("; ", f);
}

void _PrPTGExterns(n)
_PPTG2 n;
{
  fputs ("#define TYPE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("#undef TYPE\n", f);
}

void _PrPTGMacro(n)
_PPTG7 n;
{
  fputs ("#define ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("   \\\n", f);
  fputs ("\t\t", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("(", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs (", ", f);
  (* (n->_desc [6]->_print))(n->_desc[6]);
  fputs (")\n", f);
}

void _PrPTGNum(n)
_PPTGNum n;
{
  fprintf (f, "%d",n->_t0);
}

PTGNode PTGCGen(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGCGen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGOperationSpec(_t0,_t1,_t2,_t3,_t4,_t5,_t6)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5,_t6;
{
  _PPTG7 n;

  if ((n = (_PPTG7) malloc (sizeof (struct _SPTG7)))  ==  (_PPTG7)NULL)
	MEMERR
  n->_print = _PrPTGOperationSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  n->_desc[6]=_t6;
  return ((PTGNode) n);
}

PTGNode PTGParen(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGParen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGIdentifier(_t0)
  int _t0;
{
  _PPTGIdentifier n;

  if ((n = (_PPTGIdentifier) malloc (sizeof (struct _SPTGIdentifier)))  ==  (_PPTGIdentifier)NULL)
	MEMERR
  n->_print = _PrPTGIdentifier;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGString(_t0)
  char *_t0;
{
  _PPTGString n;

  if ((n = (_PPTGString) malloc (sizeof (struct _SPTGString)))  ==  (_PPTGString)NULL)
	MEMERR
  n->_print = _PrPTGString;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGCommaSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGCommaSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGParamDecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGParamDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGSModifier(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSModifier;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGEModifier(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGEModifier;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPTypeSpec(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGPTypeSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGIPTypeSpec(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGIPTypeSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGFuncName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGFuncName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGTypeDef(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGTypeDef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGFunctions(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGFunctions;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGHGen(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGHGen;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGInclude(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGInclude;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGExternSpec(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGExternSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGExtParamDecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGExtParamDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGExterns(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGExterns;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGMacro(_t0,_t1,_t2,_t3,_t4,_t5,_t6)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5,_t6;
{
  _PPTG7 n;

  if ((n = (_PPTG7) malloc (sizeof (struct _SPTG7)))  ==  (_PPTG7)NULL)
	MEMERR
  n->_print = _PrPTGMacro;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  n->_desc[6]=_t6;
  return ((PTGNode) n);
}

PTGNode PTGNum(_t0)
  int _t0;
{
  _PPTGNum n;

  if ((n = (_PPTGNum) malloc (sizeof (struct _SPTGNum)))  ==  (_PPTGNum)NULL)
	MEMERR
  n->_print = _PrPTGNum;
  n->_t0=_t0;
  return ((PTGNode) n);
}

