#!/bin/sh
# $Id: help.cmd,v 1.12 1992/08/10 20:24:08 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

#help "Hypertext presentation of reports" :
#	USER
#		: (:.warning +docref :expand_hooks)

if test ! -s (|<(:.warning +docref :expand_hooks)|); then exit 0; fi

umask 0
cd (|<RUNDIR|)

sed -e '/^@map/,/^@end map/{
			/^@/d
			w MAP
			d
		}
		/^$/d
		/^Unknown input macro/s/^\(.*\) in <\(.*\)>/\2 0 0 \1/
		/does not exist/s/^.*<.*>.*<\(.*\)>.*/. 0 0 \1 missing/
		/^---.*:\.cmd_ref.*---$/{
			s/^.*\(<.*\) :\.cmd_ref>.*/\1>/
			h
			d
		}
		/^---.*---$/d
		/syntax error at token/d
		/^Syntax error in macro/{
			G
			s/^\(.*\) <\(..*\)>.*<\(.*\)>/\3 0 0 \1 <\2>/
		}
		/^[^./]/{
			s/^/. 0 0 /
			w FRONT
			d
		}' (|<(:.warning +docref :expand_hooks)|) \
	| (|$/Tool/skeleton/cat-n.exe|) \
	| sort +1 -2 +2n -3 +3n -4 +0n -1 \
	| sed -e 's/^[0-9 	]*'// \
	| uniq \
	> FMSG

cat FRONT FMSG >INFILE

if test -s MAP
then
	echo '@map' >(|>help|)

	sort -u +0 -1 MAP \
		| tee -a (|>help|) \
		| sed -e 's/^\([^	]*\)	\(.*\)$/s;\2;\1;/' \
		> SCRIPT

	echo '@end map' >>(|>help|)

	(|$/Tool/texinfo/hypermsg.exe|) INFILE \
		| sed -f SCRIPT \
		| cat (|$/Tool/info/help_header|) \
			- (|$/Tool/info/help_trailer|) \
		>>(|>help|)
else
	(|$/Tool/texinfo/hypermsg.exe|) INFILE \
		| cat (|$/Tool/info/help_header|) \
			- (|$/Tool/info/help_trailer|) \
		>>(|>help|)
fi

exit 0
