static char rcsid[] = "$Id: signals.c,v 1.4 1991/07/04 17:23:42 waite Exp $";

/* signals.c

   Copyright (C) 1987 Free Software Foundation, Inc.

   This file is part of GNU Info.

   GNU Info is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.  No author or distributor accepts
   responsibility to anyone for the consequences of using it or for
   whether it serves any particular purpose or works at all, unless he
   says so in writing.  Refer to the GNU Emacs General Public License
   for full details.

   Everyone is granted permission to copy, modify and redistribute
   GNU Info, but only under the conditions described in the GNU Emacs
   General Public License.   A copy of this license is supposed to
   have been given to you along with GNU Emacs so you can know your
   rights and responsibilities.  It should be in a file named COPYING.
   Among other things, the copyright notice and this notice must be
   preserved on all copies.
*/

#include <curses.h>
#include "info.h"

extern char *widest_line;
extern int terminal_rows, terminal_lines;
extern IWINDOW_LIST *window_stack;

typedef void (*SigFunction) ();

#ifdef SIGTSTP
SigFunction old_stop;		/* last value of SIGSTOP. */
SigFunction old_cont;		/* last value of SIGCONT. */
#endif

#ifdef SIGWINCH
SigFunction old_winch; 		/* last value of SIGWINCH. */
#endif


void
#ifdef _AIX
info_signal_handler (sig)
     int sig;
#else
info_signal_handler (sig, arg1, arg2)
     int sig, arg1, arg2;
#endif
{
  /* Do the right thing with this signal. */

  extern void adjust_wind(), clear_screen(), display_page();

  switch (sig)
    {

#ifdef SIGTSTP
    case SIGTSTP:
      endwin();
      signal (SIGTSTP, old_stop);
      (void)kill (getpid (), SIGSTOP);
      break;

    case SIGCONT:
      /* Try to win some more.  Reset IO state, and stuff
         like that. */

      refresh();
      signal (SIGTSTP, info_signal_handler);
      break;
#endif /* SIGTSTP */

    case SIGINT:
      endwin();
      exit (1);
      break;
    }
}

void
install_signals ()
{
#ifdef SIGTSTP
  old_stop = (SigFunction) signal (SIGTSTP, info_signal_handler);
  old_cont = (SigFunction) signal (SIGCONT, info_signal_handler);
#endif /* SIGTSTP */

#ifdef SIGWINCH
  old_winch = (SigFunction) signal (SIGWINCH, info_signal_handler);
#endif

  signal (SIGINT, info_signal_handler);
}
