/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <sys/signal.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <stdio.h>
#include "inc/GMC.h"

boolean		Signalled = FALSE;
boolean		Interrupted = FALSE;

boolean		ShowTimes = FALSE;
static time_t	TimeOfDay;

time_t		time();

Init_Timing()
{
   TimeOfDay = time((time_t*)0);
   }/*Init_Timing*/;

boolean
SystemExec(FileName)
   tp_FileName FileName;
{
   int pid, w_pid, wstatus;
   static char * null_argv[] = {"odin-script", 0};
   struct rusage child_rusage;
   float utime, stime;
   static float cum = 0.0;

   pid = vfork();
   if (pid == 0) {
      (void)execve(FileName, null_argv, EnvP);
      perror("execve");
      _exit(-1); }/*if*/;
   w_pid = 0;
   /*select*/{
      if (ShowTimes) {
	 while(w_pid != pid && w_pid != -1) {
	    w_pid = wait3(&wstatus, WUNTRACED, &child_rusage); }/*while*/;
	 utime = (float)child_rusage.ru_utime.tv_sec
	    + (float)child_rusage.ru_utime.tv_usec/1000000.0;
	 stime = (float)child_rusage.ru_stime.tv_sec
	    + (float)child_rusage.ru_stime.tv_usec/1000000.0;
	 cum += utime + stime;
	 (void)fprintf((FILE *)LogFD,
                       "\t%5de\t%5.1fc\t%5.1ft\t%5.1fu\t%5.1fs\t%3d+%3dio\n",
                       time((time_t*)0)-TimeOfDay, cum,
		       utime+stime, utime, stime,
		       child_rusage.ru_inblock, child_rusage.ru_oublock);
      }else{
	 while (w_pid != pid && w_pid != -1) w_pid = wait(&wstatus);
	 };}/*select*/;
   return (w_pid != -1 && WIFEXITED(wstatus) && (WEXITSTATUS(wstatus) == 0));
   }/*SystemExec*/;


ShowOdinTime()
{
#ifndef hpux
   struct rusage odin_rusage;
   float utime, stime;
   int ctime;

   (void)getrusage(0, &odin_rusage);
   utime = (float)odin_rusage.ru_utime.tv_sec
	 + (float)odin_rusage.ru_utime.tv_usec/1000000.0;
   stime = (float)odin_rusage.ru_stime.tv_sec
	 + (float)odin_rusage.ru_stime.tv_usec/1000000.0;
   ctime = (int)time((time_t*)0) - TimeOfDay;
   (void)fprintf((FILE *)LogFD,
      "ODIN: %dsec(%dmin)Elapsed     %.1ft   %.1fu   %.1fs   %d+%dio\n",
      ctime, (ctime+30)/60, utime+stime, utime, stime,
      odin_rusage.ru_inblock, odin_rusage.ru_oublock);
#endif
   }/*ShowOdinTime*/;


Init_Sigs()
{
   void Catch_Sig();

   (void)signal(SIGHUP, Catch_Sig);
   (void)signal(SIGINT, Catch_Sig);
   (void)signal(SIGQUIT, Catch_Sig);
   (void)signal(SIGTERM, Catch_Sig);
   }/*Init_Sigs*/;
   

void
Catch_Sig()
{
   Signalled = TRUE;
   }/*Catch_Sig*/;


Do_Sig()
{
   FORBIDDEN(!Signalled);
   Signalled = FALSE;
   Write(StdErrFD, "** Request Aborted : interrupt signal received **\n");
   Flush(StdErrFD);
   Interrupted = TRUE;
   }/*Do_Sig*/;


#ifdef NFS
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include <errno.h>

TryLock(SucceedPtr, FilDsc)
   boolean *SucceedPtr;
   tp_FilDsc FilDsc;
{
   int status;

#ifdef NFS
   /*block*/{
      static struct flock fl_data = {F_WRLCK, 0, 0, 0};
      status = fcntl(fileno((FILE *)FilDsc), F_SETLK, &fl_data); }/*block*/;
   if (status != 0) {
      /* twisted Sun doc says EAGAIN, and then returns EACCES */
      if (errno == EAGAIN || errno == EACCES) {
#else
   status = flock(fileno((FILE *)FilDsc), LOCK_EX|LOCK_NB);
   if (status != 0) {
      if (errno == EWOULDBLOCK) {
#endif
	 *SucceedPtr = FALSE;
	 return; }/*if*/;
      fatal_err("bad flock call"); }/*if*/;
   *SucceedPtr = TRUE;
   }/*TryLock*/;


Lock(FilDsc)
   tp_FilDsc FilDsc;
{
   int status;

#ifdef NFS
   /*block*/{
      static struct flock fl_data = {F_WRLCK, 0, 0, 0};
      status = fcntl(fileno((FILE *)FilDsc), F_SETLKW, &fl_data); }/*block*/;
#else
   status = flock(fileno((FILE *)FilDsc), LOCK_EX);
#endif
   if (status != 0) fatal_err("bad flock call");
   }/*Lock*/;


Unlock(FilDsc)
   tp_FilDsc FilDsc;
{
   int status;

   Flush(FilDsc);
#ifdef NFS
   /*block*/{
      static struct flock fl_data = {F_UNLCK, 0, 0, 0};
      status = fcntl(fileno((FILE *)FilDsc), F_SETLK, &fl_data); }/*block*/;
#else
   status = flock(fileno((FILE *)FilDsc), LOCK_UN);
#endif
   if (status != 0) fatal_err("bad flock call");
   }/*Unlock*/;


