# $Id: Makefile.cpp,v 1.105 1992/11/10 14:22:10 kadhim Exp $
# Copyright (c) 1992, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR	= ELISYS

# Source directories
SUBDIR	= obstack source err csm idn int fpt str adtinit fw \
	  eli skeleton gla concrete oil cagt pdl envmod datamap \
	  cola pgs parser ptg genlido liga kwd clp texinfo info

SYS	= frame.specs
SRC	= transl.c rel_err.c \
	  paste.c cpp_specs.c frame.derive
EXE	= transl.exe rel_err.exe \
	  paste.exe cpp_specs.exe
#ifdef hpux
LIBS	= -lBSD
#endif

TIDY	= *~ *.o core a.out ELI
CLEAN	= $(TIDY) $(EXE) frame frame_g frame_pg


all:	$(EXE) $(SYS) ELI frame.derive frame frame_g frame_pg
	@for i in $(SUBDIR); do echo; echo Making Tool/$$i; \
		(cd $$i; make NOTEX=$(NOTEX) DESTDIR=$(DESTDIR) CC="$(CC)"); \
		done
	DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <frame.derive
	@echo; echo Making Tool/lib; DESTDIR=$(DESTDIR) export; \
		cd lib; \
		make DESTDIR=$$DESTDIR
	@echo; echo Making Tool/examples; DESTDIR=$(DESTDIR) export; \
		cd examples; \
		make DESTDIR=$$DESTDIR

install:
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool; \
		rm -f $(DESTDIR)/Tool/$$f; \
		cp $$f $(DESTDIR)/Tool; \
		chmod 755 $(DESTDIR)/Tool/$$f; \
		done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool; \
		rm -f $(DESTDIR)/Tool/$$f; \
		cp $$f $(DESTDIR)/Tool; \
		chmod 644 $(DESTDIR)/Tool/$$f; \
		done
	@for f in frame frame_g frame_pg; do \
		rm -rf $(DESTDIR)/Tool/$$f; \
		cp -r $$f $(DESTDIR)/Tool; \
		done
	-@for i in $(SUBDIR) lib examples; do \
		if test ! -d $(DESTDIR)/Tool/$$i; \
			then umask 002; mkdir $(DESTDIR)/Tool/$$i; \
			else :; \
			fi; \
		done
	@for i in $(SUBDIR) lib examples; do echo; echo Installing Tool/$$i; \
		(cd $$i; make NOTEX=$(NOTEX) DESTDIR=$(DESTDIR) install); \
		done

executable:
	@for i in $(SUBDIR) lib examples; do echo; \
		echo Making Tool/$$i executable; (cd $$i; make executable); \
		done
	rm -rf $(TIDY) Makefile.cpp $(SRC) $(PASRM) Makefile

tidy:
	rm -rf $(TIDY)
	@for i in $(SUBDIR) lib examples; do echo; echo Tidying Tool/$$i; \
		(cd $$i; make tidy); done

clean:
	rm -rf $(CLEAN)
	@for i in $(SUBDIR) lib examples; do echo; echo Cleaning Tool/$$i; \
		(cd $$i; make clean); done

ELI:
	$(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q

.SUFFIXES:	.exe
.c.exe:
	$(CC) $(CFLAGS) -o $@ $*.c $(LIBS)

frame:
	umask 002; mkdir frame

frame_g:
	umask 002; mkdir frame_g

frame_pg:
	umask 002; mkdir frame_pg
