#!/bin/sh
# Copyright, 1990, The University of Paderborn
# $Id: colaProd.cmd,v 1.8 1992/12/21 08:05:45 cogito Exp $
# colaProd[.none] 'Generation of the concrete parser'* :
# 	USER
# 		: colaCmr
# 		: colaAbs
#		: colaBackOpt
#               : colaErrIncl
# 		+ direct

umask 0
cd (|<RUNDIR|)

ln -s (|<colaCmr|) cmr

(|$/Tool/cola/cola_connect.exe|) cmr 1> (|>ERROR|) 2>&1

if test -s (|>ERROR|)
then 
	exit 0
fi

if test -f (|<direct|)
then	(|$/Tool/cola/cola_dep.exe|) -c cmr.sem -a (|<colaAbs|) \
	`cat (|<colaBackOpt|)`  1> (|>ERROR|) 2>&1
else	(|$/Tool/cola/cola_tbl.exe|) \
		cmr.sem (|<colaAbs|) (|<colaBackOpt|) 1> (|>ERROR|) 2>&1
fi

if test -s opt.out 
then 
	mv opt.out (|>colaProd|)/colaBack.info
fi

if test -s (|>ERROR|)
then
        exit 0
fi

# Copying parser frame
if test -f (|<direct|)
then
	cp (|$/Tool/cola/Frames/help_func.h|) (|>colaProd|)/help_func.h
	cp (|$/Tool/cola/Frames/waite_carter.h|) (|>colaProd|)/waite_carter.h
else
	cp (|$/Tool/cola/Frames/parser.c|) (|>colaProd|)
	if test -s (|<colaErrIncl|)
	then
		cat (|<colaErrIncl|) (|$/Tool/cola/Frames/parser.h|) \
						> (|>colaProd|)/parser.h
	else
		cp (|$/Tool/cola/Frames/parser.h|) (|>colaProd|)
	fi
fi

# Moving generated products
if test -f (|<direct|)
then
	mv parser.c (|>colaProd|)/parser.c
	mv init.h (|>colaProd|)/init.h
	if test -s semantic_productions.h
	then mv semantic_productions.h (|>colaProd|)/semantic_productions.h
	fi
	if test -s error_body.h
	then
	    mv error_body.h (|>colaProd|)/error_body.h
	    mv error_recovery.h (|>colaProd|)/error_recovery.h
	    mv error_var.h (|>colaProd|)/error_var.h
	fi
else
	mv semprods.h (|>colaProd|)/semprods.h
	mv ptabs.h (|>colaProd|)/ptabs.h
fi

exit 0
