/*
** $Id: parser.c,v 2.5 1993/01/11 10:44:47 cogito Exp $
*/
static char rcs_id[]= "$Id: parser.c,v 2.5 1993/01/11 10:44:47 cogito Exp $";

/****************************************************************************/
/* This part adapts the parser implementation to Eli's compiler environment */
/****************************************************************************/

/*** Include Files ***/

#include "err.h"	/* Error-handler-module provided by ELI */
#include "treecon.h"	/* functions/types needed for connections */
#include "gsdescr.h"	/* types GRUNDSYMBOLDESKRIPTOR, TERMINALSYMBOL and
			 * ATTRTYPE */
#include "gla.h"	/* function glalex() */
#include "parser.h"

/*** Size of internally used static sized stacks ***/
#ifndef STACKSIZE
#define	STACKSIZE	250
#endif

/*** Default attribute value of inserted semantic terminals ***/
#ifndef	DEFAULT_ATTRVAL
#define	DEFAULT_ATTRVAL	0
#endif

/*** Types ***/

#define	TOKENTYPE	GRUNDSYMBOLDESKRIPTOR
#define	CODETYPE	TERMINALSYMBOL
#define	ATTRTYPE	ATTRTYPE

/*** TOKENTYPE-Macros ***/

#define	CODE(tok)	(T_CODE((*tok)))
#define	POS(tok)	(T_POS((*tok)))
#define	ATTR(tok)	(T_ATTR((*tok)))

/*** Function Calls ***/

/* Scanner interface: read next token from input stream */
#define	GET_TOKEN(tok)	{\
			  CODE(tok) = glalex( (char *)(&(ATTR(tok))) );\
			  POS(tok) = curpos;\
			}

/* Error module interface: producing an error message */
#define	ERR_MSG(class, text, pos)	message(class, text, 0, &(pos))

/* Function for executing semantic actions */
static	void	USER(action, Token)
unsigned short	action;
TOKENTYPE	*Token;
{
  POSITION	pos;

  pos = POS(Token);

/* Connections in "semprods.h" are using names ZAttributKeller and curpos. */
#define ZAttributKeller	Token
#define	curpos		pos
#define	OFFSET		9	/* Depends on conncode[] in "ptabs.h" */

#include "semprods.h"

#undef	ZAttributKeller
#undef  curpos

  return;
}  /* of USER() */


/****************************************************************************/
/* End of adaptable parser interface -- Start of parser implementation      */
/****************************************************************************/

typedef	unsigned short	U_SHORT;
typedef	int		BOOL;

#ifndef	FALSE
#define	FALSE	0
#endif

#ifndef	TRUE
#define	TRUE	1
#endif

/****************************************************************************/

/*** Definitions depending on the COLA generated file "ptabs.h" ***/

#include "ptabs.h"

#define	STATETYPE	U_SHORT
#define	ACTIONTYPE	U_SHORT
#define	LENGTHTYPE	U_SHORT

#define	IS_CONN(rule)	((U_SHORT)conncode[rule])

#define	CONN_CODE(rule)	((U_SHORT)conncode[rule])

#define	GET_LHS_NT(rule) ((U_SHORT)lhs[rule])

#define	LENGTH(rule)	((LENGTHTYPE)len[rule])

#define	CONTINUATION(state) ((CODETYPE)cont[state])

#ifdef  NUOFSEPAS
#define SEPASYMB(ind)	((CODETYPE)seps[ind])
#endif

#define	IS_BRACKET(term) (FALSE)

#define	IS_SKIP(term)	(FALSE)


#define	ACTIONMASK	0x0000f000

#define	OPERANDMASK	0x00000fff

/* Action codes */
#define	ERR		0
#define	SHIFT		(1<<12)
#define	SHIFT_NT	(6<<12)
#define	REDUCE		(2<<12)
#define	SHIFTRED	(4<<12)
#define	SHIFTRED_NT	(9<<12)
#define	ACCEPT		(8<<12)

#define	START_STATE	0




/****************************************************************************/
/* Implementation of the table driven parser                                */
/****************************************************************************/

/* Text for Messages */
#define	SX_TEXT	"Syntax error"
#define	SI_TEXT	"Symbol inserted"
#define	SD_TEXT	"Symbol deleted"
#define	PR_TEXT	"Parsing resumed here"
#define	PT_TEXT	"Wrong parse tables"
#define	SF_TEXT	"Parse stack overflow"
#define	AC_TEXT "Accept not expected"


/* Global stack of states and tokens */
static	STATETYPE	state[STACKSIZE];
static	TOKENTYPE	token[STACKSIZE];


/* No side effect to State or Token */
/* On exit: error (continuation) symbol */
static	CODETYPE	ErrorSymb(State, Token)
STATETYPE	*State;         /* Points to top of stack 'state' */
TOKENTYPE	*Token;		/* Points to current input token */
{
  CODETYPE	Term;

  Term = CONTINUATION(*State);

#ifdef	NUOFSEPAS
  {
    CODETYPE	SepTerm;
    int		l;
    STATETYPE	SepRuleOrState, RuleOrState;
    ACTIONTYPE	SepAction, Action;
    BOOL	Hoping;

    /* For each separator symbol do */
    for (l=0; l<NUOFSEPAS; l++)
    {
      if ( (SepTerm = SEPASYMB(l))  ==  Term )
        break;

      /* Is there a valid action with SepTerm for state '*State'? */
      SepRuleOrState = *State;
      GET_TTABENTRY(SepRuleOrState, SepAction, SepTerm);
      if ( SepAction == ERR )
	continue;

      /* Testing whether Term and SepTerm causes identical actions */
      RuleOrState = *State;
      GET_TTABENTRY(RuleOrState, Action, Term);
      if ( Action == SepAction  &&  RuleOrState == SepRuleOrState )
        continue;

      /* Would '*Token' directly be a recovery point after inserting SepTerm? */
      Hoping = TRUE;
      while ( Hoping )
      {
	switch ( SepAction )
	{
	  case SHIFT:
	  case SHIFT_NT:
		/* Testing '*Token' as recovery point */
		GET_TTABENTRY(RuleOrState, Action, CODE(Token));
		if ( Action == SHIFT  ||  Action == SHIFTRED )
		  return(SepTerm);	/* SepTerm is a good error symbol! */
		else
		  Hoping = FALSE;	/* Try next separator symbol */
		break;
	  case SHIFTRED:
	  case SHIFTRED_NT:
		State++;
	  case REDUCE:
		State -= LENGTH(SepRuleOrState);
		GET_NTABENTRY(SepRuleOrState, SepAction, 
				*State,	GET_LHS_NT(SepRuleOrState));
		break;
	  case ACCEPT:
		Hoping = FALSE;		/* Try next separator symbol */
		break;
	  default:
		ERR_MSG(DEADLY, PT_TEXT, POS(Token));
		return(Term);
	}  /* of switch */
      }  /* of while */
    }  /* of for */
  }  /* end of part #ifdef  NUOFSEPAS */
#endif

  return(Term);
}  /* of ErrorSymb() */

/* No side effect to State, Token or (global) state */
static	BOOL	IsReachable(State, Token)
STATETYPE	*State;		/* Points to top of stack 'state' */
TOKENTYPE	*Token;
{
  STATETYPE	CpState[STACKSIZE];	/* Copy of the global stack 'state' */
  STATETYPE	*travel, *TopState = CpState-1;
  BOOL		IsBracket, 
		TryNextInputToken = FALSE; 
		       /* Controls that error continuation goes
			* til EOF iff *Token is a semantic bracket
			* til next error symbol is a semantic bracket otherwise
			*/
  ACTIONTYPE	Action;
  STATETYPE	RuleOrState;
  CODETYPE	ErrTerm;

  IsBracket = IS_BRACKET(CODE(Token));

  /* Copy global stack 'state' into 'CpState' */
  for (travel=state; travel<=State; travel++)
  {
    *(++TopState) =  *travel;
  }

  Action = SHIFT_NT;
  RuleOrState = *(TopState);
  TopState--;
  while ( TRUE )
  {
      switch ( Action )
      {
	case SHIFT:
	case SHIFT_NT:
		*(++TopState) = RuleOrState;
		if ( TopState == CpState+STACKSIZE )
		{
		  ERR_MSG(DEADLY, SF_TEXT, POS(Token));
		  return(FALSE);
		}

                /* Is '*Token' a valid recovery point? */
                GET_TTABENTRY(RuleOrState, Action, CODE(Token));
                if ( Action == SHIFT  ||  Action == SHIFTRED )
		  return(TRUE);

		/* Try next input token as recovery point? */
		else if ( TryNextInputToken )
		  return(FALSE);

		/* Continue testing '*Token' as valid recovery point. */
		else
		{
		  ErrTerm = ErrorSymb(TopState, Token);
		  TryNextInputToken = !IsBracket  &&  IS_BRACKET(ErrTerm);
		  RuleOrState = *TopState;
		  GET_TTABENTRY(RuleOrState, Action, ErrTerm);
		}
		break;

	case SHIFTRED:
	case SHIFTRED_NT:
		TopState++;

	case REDUCE:
		TopState -= LENGTH(RuleOrState);
		GET_NTABENTRY(RuleOrState, Action, 
				*TopState, GET_LHS_NT(RuleOrState));
		break;

	case ACCEPT:
		return(FALSE);

	default:
		ERR_MSG(DEADLY, PT_TEXT, POS(Token));
		return(FALSE);
      }  /* of switch */
   }  /* of while */
  
}  /* of IsReachable() */


#define	DEL_TOKEN(tok)	/* ERR_MSG(NOTE, SD_TEXT, POS(tok)) */

#define	GEN_TOKEN(tok,code, pos)	{\
					  /* ERR_MSG(NOTE, SI_TEXT, pos); */\
					  CODE(tok) = code;\
					  POS(tok) = pos;\
					  ATTR(tok) = DEFAULT_ATTRVAL;\
					}

/* On exit: *Token will be the error recovery point
 *	    State will be unmodified
 */
static	void	SearchRecoveryPoint(State,Token)
STATETYPE	*State;
TOKENTYPE	*Token;
{
  BOOL	found = FALSE;

  while ( !found )
  {
    if ( CODE(Token) == PAEOF )
	found = TRUE;
    else
    {
	if ( ! IS_SKIP(CODE(Token)) )		/* Is Token an unsafe anchor? */
	  /* Try Token as anchor (=recovery point). */
	  found = IsReachable(State, Token);
    }  /* of else */

    if ( !found )				/* Token IS an unsafe anchor! */
    {
	DEL_TOKEN(Token);
	GET_TOKEN(Token);			/* Delete Token from input */
    }
  }  /* of while */
}  /* of SearchRecoveryPoint() */


void	parser()
{

register STATETYPE	*State = state;	/* Points to top of stack state */
register TOKENTYPE	*Token = token;	/* Points to top of stack token */
register STATETYPE	RuleOrState = START_STATE;
register ACTIONTYPE	Action = ERR;
register LENGTHTYPE	length;
	 TOKENTYPE	InputToken[1];	/* only used in error recovery */
	 CODETYPE	ErrTerm;	/* only used in error recovery */

#ifdef	_STATISTIK
int	_SH=0, _RED=0, _SHRED=0, _SUM=0;
#endif
L_SHIFT:
  Token++;
  GET_TOKEN(Token);

L_SHIFT_NT:
  *(++State) = RuleOrState;
  if ( State == state+STACKSIZE )
    ERR_MSG(DEADLY, SF_TEXT, POS(Token));

  GET_TTABENTRY(RuleOrState, Action, CODE(Token));

  if ( Action == REDUCE )
  {
#ifdef	_STATISTIK
    _RED++;
#endif
    goto L_REDUCE;
  }
  else if ( Action == SHIFTRED )
  {
#ifdef	_STATISTIK
    _SHRED++;
#endif
    goto L_SHIFTRED;
  }
  else if ( Action == SHIFT )
  {
#ifdef	_STATISTIK
    _SH++;
#endif
    goto L_SHIFT;
  }
  else if ( Action == ACCEPT )
  {
#ifdef	_STATISTIK
   _SUM = _RED + _SH + _SHRED;
   printf("SHIFT: %d(%2d%%), REDUCE: %d(%2d%%), _SH_RED: %d(%2d%%)\n",
	_SH, _SH*100/_SUM, _RED, _RED*100/_SUM, _SHRED, _SHRED*100/_SUM);
   printf("Summe: %d\n", _SUM);
#endif
    if ( IS_CONN(STPROD) )
    {
	USER(CONN_CODE(STPROD), Token);
    }
    return;
  } 
  else if ( Action == ERR )
  {
    goto L_ERR;
  }
  else
  {
    ERR_MSG(DEADLY, PT_TEXT, POS(Token));
    return;
  }

L_SHIFTRED:
  Token++;
  GET_TOKEN(Token);

L_SHIFTRED_NT:
  State++;

L_REDUCE:
  length = LENGTH(RuleOrState);
  State -= length;
  Token -= length;
  if ( IS_CONN(RuleOrState) )
  {
    USER(CONN_CODE(RuleOrState), Token);
  }

  GET_NTABENTRY(RuleOrState, Action, *State, GET_LHS_NT(RuleOrState));

  /* Copy current lookahead token to top of token stack */
  Token++;
  *Token = *(Token+length-1);

  if ( Action == SHIFT_NT )
  {
    goto L_SHIFT_NT;
  }
  else 
#ifdef DEBUG
  if ( Action == SHIFTRED_NT )
#endif
  {
    goto L_SHIFTRED_NT;
  }
#ifdef DEBUG
  else if ( Action == ACCEPT )
  {
    if ( IS_CONN(STPROD) )
    {
	USER(CONN_CODE(STPROD), Token);
	ERR_MSG(FATAL, AC_TEXT, POS(Token));
    }
    return;
  } 
  else
  {
    ERR_MSG(DEADLY, PT_TEXT, POS(Token));
    return;
  }
#endif

L_ERR:
  ERR_MSG(ERROR, SX_TEXT, POS(Token));
#ifdef  _ERROR_OFF
  return;	/* Stop after the first syntax error! */
#endif 

  SearchRecoveryPoint(State, Token);

  /* GotoRecoveryPoint */
  *InputToken = *Token;
  Action = SHIFT_NT;
  RuleOrState = *(State--);
  while ( TRUE )
  {
      switch ( Action )
      {
	case SHIFT:
		GEN_TOKEN(Token, ErrTerm, POS(InputToken));
		Token++;

	case SHIFT_NT:
		*(++State) = RuleOrState;
		if ( State == state+STACKSIZE )
		  ERR_MSG(DEADLY, SF_TEXT, POS(InputToken));

                /* Is recovery point reached? */
                GET_TTABENTRY(RuleOrState, Action, CODE(InputToken));
                if ( Action == SHIFT  ||  Action == SHIFTRED )
		{
		  *Token = *InputToken;
		  ERR_MSG(NOTE, PR_TEXT, POS(Token));
		  if ( Action == SHIFT )
		    goto L_SHIFT;
		  else
		    goto L_SHIFTRED;
		}

		/* Continue going to the valid recovery point. */
		RuleOrState = *State;
		ErrTerm = ErrorSymb(State, InputToken);
		GET_TTABENTRY(RuleOrState, Action, ErrTerm);
		break;

	case SHIFTRED:
		GEN_TOKEN(Token, ErrTerm, POS(InputToken));
		Token++;

	case SHIFTRED_NT:
		State++;

	case REDUCE:
		length = LENGTH(RuleOrState);
		State -= length;
		Token -= length;
		if ( IS_CONN(RuleOrState) )
		{
		  USER(CONN_CODE(RuleOrState), Token);
		}

		GET_NTABENTRY(RuleOrState, Action, 
					*State, GET_LHS_NT(RuleOrState));

		/* Copy current lookahead token to top of token stack */
		Token++;
		*Token = *(Token+length-1);

		break;

	case ACCEPT:
		ERR_MSG(NOTE, PR_TEXT, POS(InputToken));
		if ( IS_CONN(STPROD) )
		{
		  USER(CONN_CODE(STPROD), Token);
		}
		return;

	default:
		ERR_MSG(DEADLY, PT_TEXT, POS(InputToken));
		return;
      }  /* of switch */
   }  /* of while */
}  /* of parser() */


