# $Id: src.lalr.back.both.Makefile.cpp,v 1.9 1992/11/26 16:39:33 cogito Exp $
##############  This makefile constructs the library both.a    ############
##############      used by both version of the backend        ############

DESTDIR = ELISYS
DISTRIB = ELISYS

IDL =	../../../idl

# parameter for control-output of the read-module
HELP=

SRC =	comarprivdefs.c error.c errtst.c rd_absprs.c rd_adt.c
OBJ =	comarprivdefs.o error.o errtst.o rd_absprs.o rd_adt.o
HDR =	comarprivdefs.h error.h errtxt.h rd_absprs.h rd_adt.h

CFLAGS =  -I$(IDL)
CC	= cc

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a 
CLOBBER = $(CLEAN) Makefile

###########################################################################

all: both.a

install: both.a

distrib:        $(SRC) $(HDR)
	@if test ! -d $(DISTRIB)/lalr/back/both; \
		then umask 002; mkdir $(DISTRIB)/lalr/back/both; \
		else :; \
		fi
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/lalr/back/both
	cd $(DISTRIB)/lalr/back/both; chmod 0644 $(SRC) $(HDR) Makefile.cpp

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

###########################################################################

#if defined(NO_RANLIB)
both.a  :    $(OBJ)
	rm -f both.a
	ar rcus both.a $(OBJ)
#else
both.a  :    $(OBJ)
	rm -f both.a
	ar cru both.a $(OBJ)
	ranlib both.a
#endif

rd_absprs.o: rd_absprs.c rd_adt.h comarprivdefs.h error.h \
	$(IDL)/prsiface.h $(IDL)/name.h

comarprivdefs.o:   comarprivdefs.c error.h $(IDL)/comar.h

rd_adt.o:     rd_adt.c error.h

error.o:   error.c errtxt.h

errtst.o:  errtst.c
