/***************************************************************************/
/* filename : build_optim.c                        first edit  : 23.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: build_optim.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";

/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "errors.h"

#include "clearing.h"

#include "high_optim.h"

#include "low_optim.h"

#include "other_optim.h"

#include "optim_out.h"



/********************************** FUNCTIONS ******************************/



struct optim_out *Build_Optim( quick_data,user_data,extra_info )


   readtype     *quick_data;  /* interface vector to optimization          */
   struct user   *user_data;  /* structure which saves information 
                                 entered by the user                       */
   char          extra_info;  /* if extra_info == 1, then extra informa-
				 tion about begin and end of function is
				 printed out                               */


/* This functionm controls the complete optimization. It calls the other
   modules in the order, given by the user.
*/
   {
     struct inter        *changed_data;  /* interface vector between the 
                                            higher and lower optimization
                                            techniques                     */
     struct optim_out  *optim_out_data;  /* stores the optimized code in a
                                            form, which can be printed
                                            out easy                       */


     if( extra_info )
        printf("begin of function Build_Optim()\n");

     if( (changed_data = (struct inter*) malloc(
				      sizeof( struct inter )) ) == NULL )
	Error_Message( _BUILD_OPTIM,MODULE_BUILD_OPTIM,NO_SPACE_FOR_STRUCTURE,
                       ABORT," changed_data" );

     changed_data->number_of_pcc      = 0;
     changed_data->min_push           = NULL;
     changed_data->ttred_paths        = NULL;
     changed_data->ttsred_paths       = NULL;
     changed_data->ntred_paths        = NULL;
     changed_data->equal_rows         = NULL;
     changed_data->under_rows         = NULL;
     changed_data->ident_act_rows     = NULL;
     changed_data->sim_act            = NULL;
     changed_data->similar_act_rows   = NULL;
     changed_data->bit_set            = NULL;
     changed_data->stack_check_states = NULL;
     changed_data->pcc_list           = NULL;
     changed_data->longest_path       = 0;

     if( user_data->high_before_low )
	{
	  High_Optim( quick_data,changed_data,user_data,extra_info );
	  Low_Optim( quick_data,user_data,changed_data,extra_info );
	} /* end of if( user_data->h... */
     else
	{
	  Low_Optim( quick_data,user_data,changed_data,extra_info );
	  High_Optim( quick_data,changed_data,user_data,extra_info );
	} /* end of else ( if( user_data->h... ) */
     Other_Optim(quick_data,user_data,changed_data,extra_info );

     optim_out_data = Optim_Out( quick_data,changed_data,user_data,
				 extra_info );

     if( extra_info )
        printf("end of function Build_Optim()\n");

     return( optim_out_data );
   } /* end of function Build_Optim */

