/*
** $Id: contrafo.h,v 1.3 1992/09/23 14:11:29 cogito Exp $
*/

/***************************************************************************/
/* File: contrafo.h	First Edit: 17.10.88	  Last Edit: 18.11.88      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change:	30.03.89	From: Karl-Josef Prott			   */
/***************************************************************************/


#ifndef	contrafo_DEF
#define	contrafo_DEF

/***************************************************************************/
/* Imported variable used by 'cmrtl_trafo_allconnect()' .		   */
/***************************************************************************/

/* global variable defined in "cmrlib" */
extern	p_comar	CMR;		  /* init. by cmrlib_changeglobalcmrvar() */


/***************************************************************************/
/* Exported errorcodes, optioncodes and function:			   */
/***************************************************************************/

/* possible errorcodes: TRF_CONUNK, TRF_WRONGTAG, TRF_WRONGOPT */

/* optioncodes */
#define TRF_ALL	1
	/* All connections of EBNF-constructs are transformed */
#define TRF_S	2
	/* Symbol-connections at the end of 'Alternate'- and 'Option'-nodes
	 * are not(!) transformed. */
#define TRF_R	3
	/* Symbol-connections at the end of 'Plus'-, 'Star' and 
	 * 'Delrep'-nodes are not(!) transformed. */
#define TRF_SR	4
	/* Symbol-connections of all EBNF-constructs are not transformed */


  /* 'cmrtl_trafo_allconnect()' transforms all connections, which are not
   * at the end of a rule, by generating so named 'Null-Nonterminals'.
   * ( That is a nonterminal generating only the empty string. )
   * The 'epsilon-rule' of this nonterminal will contain the connection.
   * To the parameters:
   *     'c' : COMAR-structure of the grammar to manipulate
   *    'opt': one of the above defined 'optioncodes' to select the various 
   *           transformation-methods
   * return == one of the above or in "cmrlib.h" defined 'errorcodes'
   */
extern ERR cmrtl_trafo_allconnect(/*p_comar c; short opt */);


#endif		/* of contrafo_DEF */
