# $Id: src.oldcmr.Makefile.cpp,v 1.9 1992/11/25 14:01:21 cogito Exp $
#
# make old COMAR modules and old COMAR library, which don't should be used
# in new implementations

# directory to install the header files and libraries:
DESTDIR = ELISYS
DISTRIB = /tmp

IDL = ../idl
FMT = ../trafos/fmt

CFLAGS = -c -w -I$(IDL) -I$(FMT)
CC   = cc

SRC = ccomarl.c ccomar.c old_to_newcmr.c privlib.c \
      ebnf.c equality.c filter.c

OBJ = ccomarl.o ccomar.o old_to_newcmr.o privlib.o \
      ebnf.o equality.o filter.o

# Don't use in new implementations
HDR = ccomarl.h ccomar.h old_to_newcmr.h privlib.h \
      ebnf.h equality.h filter.h

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a 
CLOBBER = $(CLEAN) Makefile

###########################################################################

all:	oldcmr.a

install:	oldcmr.a

distrib:        $(SRC) $(HDR)
	@if test ! -d $(DISTRIB)/oldcmr; \
		then umask 002; mkdir $(DISTRIB)/oldcmr; \
		else :; \
		fi
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/oldcmr
	cd $(DISTRIB)/oldcmr; chmod 0644 $(SRC) $(HDR) Makefile.cpp

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

############################################################################

#if defined(NO_RANLIB)
oldcmr.a:	$(OBJ) 
	rm -f oldcmr.a
	ar qcs oldcmr.a $(OBJ)
#else
oldcmr.a:	$(OBJ) 
	rm -f oldcmr.a
	ar qc oldcmr.a $(OBJ)
	ranlib oldcmr.a
#endif

ccomarl.o: 	ccomar.h ccomarl.h

ccomar.o: 	ccomar.h $(IDL)/comar.h $(IDL)/comar_func.h

ebnf.o:	        ccomar.h ccomarl.h equality.h ebnf.h

equality.o:	ccomar.h ccomarl.h privlib.h equality.h

privlib.o:	ccomar.h ccomarl.h privlib.h

old_to_newcmr.o: $(IDL)/comar.h old_to_newcmr.h

filter.o:       $(FMT)/errandio.h filter.h $(IDL)/comar.h


###########################################################################

lint:
		lint -c -I$(IDL) -DSINGLE $(SRC) >! lintmsg



