# $Id: Makefile.cpp,v 1.24 1992/07/28 15:07:56 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

DESTDIR	= /tmp
COFLAGS	= -q

SYS	= datamap.c datamap.specs storage.head storage.h

TIDY	= core a.out *.o CACHE
CLEAN	= $(TIDY) *.exe *.a
CLOBBER	= $(CLEAN) Makefile

all:	$(SYS)

install:
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/datamap; \
		rm -f $(DESTDIR)/Tool/datamap/$$f; \
		cp $$f $(DESTDIR)/Tool/datamap; \
		chmod 644 $(DESTDIR)/Tool/datamap/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr:	$(SRCS) $(SYS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SYS) Makefile.cpp
	rm -rf $(CLEAN) Makefile

.PRECIOUS:	$(SYS)
