#ifndef STORAGE_H
#define STORAGE_H

/* $Id: storage.h,v 1.7 1993/01/05 04:56:21 waite Exp $ */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

typedef struct StorageRec{
   int size;	/* Number of bytes */
   int align;	/* Number that must divide the address */
   int top;	/* True if addressed by the last+1 location */
} *StorageRequired;

#define NoStorage ((StorageRequired)0)


extern StorageRequired NewStorage(/* int size, align, top; */);
/* Create a new storage object
 *    On entry-
 *       size=size of the new object
 *       align=required divisor of the object's address
 *       top=FALSE if the lowest address must be aligned
 *           TRUE if the last+1 address must be aligned
 ***/


extern StorageRequired CopyStorage(/* StorageRequired a; */);
/* Create a new storage object equal to an existing storage object
 *    On entry-
 *       a=storage object to be copied
 ***/


extern StorageRequired ArrayStorage(/* int n; StorageRequired a; */);
/* Create a new storage object for an array of existing storage objects
 *    On entry-
 *       n=number of array elements
 *       a=element storage object
 ***/


extern int StorageSize(/* StorageRequired a; */);
/* Obtain the size of a storage object
 *    On exit-
 *       StorageSize=size of the storage object a
 ***/


extern int StorageAlignment(/* StorageRequired a; */);
/* Obtain the alignment of a storage object
 *    On exit-
 *       StorageSize=alignment of the storage object a
 ***/


extern int Concatenate(/* StorageRequired a, b; */);
/* Extend the storage requirement for an object by concatenating another object
 *    On entry-
 *       a describes the object to be extended
 *       b describes the object to be concatentated to a
 *    On exit-
 *       a describes the storage required by the extended object
 *       Concatenate=offset of the address of b from the address of a
 ***/


extern int Overlay(/* StorageRequired a, b; */);
/* Extend the storage requirement for an object by overlaying another object
 *    On entry-
 *       a describes the object to be extended
 *       b describes the object to be overlaid on a
 *    On exit-
 *       a describes the storage required by the extended object
 *       Overlay=offset of the address of b from the address of a
 ***/
#endif
