#ifndef DEFTBL_H
#define DEFTBL_H 

/* $Id: deftbl.h,v 1.1 1991/10/31 20:02:37 waite Exp $ */
/* Property list module interface */

#include <stdio.h>

typedef struct PropElt {	/* Properties of a defined entity */
   struct PropElt *next;	   /* The next property */
   int selector;		   /* Which property */
} *Entry;

typedef struct {		/* Representation of a definition table key */
   Entry PropList;		   /* Property list pointer */
} *DefTableKey;

#define NoKey (DefTableKey)NULL	/* Distinguished defninition table key */

extern DefTableKey NewKey();
/* Establish a new definition
 *    On exit-
 *       NewKey=Unique definition table key
 ***/

extern int find(/* DefTableKey key; int p; Entry *r; unsigned add; */);
/* Obtain a relation for a specific property of a definition
 * On entry-
 *    key=definition whose property relation is to be obtained
 *    p=selector for the desired property
 * If the definition does not have the desired property then on exit-
 *    find=false
 *    if add != 0 then r points to a new entry of size add for the property
 *    else r points to the entry following the entry for the property
 * Else on exit-
 *    find=true
 *    r points to the current entry for the property
 ***/

#endif
