# $Id: Makefile.cpp,v 1.7 1992/11/27 14:14:56 cogito Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/lib

CMD		= 
AUX		= Info
SUBDIR		= Cmd Tech Prop Name Examp
AUXDIR		= Info
SYS		= README
SRC		= Makefile.cpp $(SYS) $(CMD)
ELI		= ELISYS

TIDY    = core a.out *.o *~
CLEAN   = $(TIDY)

all:    $(SRC)
	@echo "make in Tool/lib"
	@for dir in $(SUBDIR) ; do \
		(echo "make in Tool/lib/$$dir"; \
		cd $$dir; \
		$(MAKE) DESTDIR=$(DESTDIR)); \
	done

install:
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR); \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
	done
	-@for dir in $(SUBDIR); do \
		if test ! -d $(DESTDIR)/$(DIR)/$$dir; \
			then umask 002; mkdir $(DESTDIR)/$(DIR)/$$dir; \
			else :; \
		fi; \
	done
	@for dir in $(SUBDIR); do echo; echo "Install Tool/lib/$$dir"; \
		(cd $$dir; make DESTDIR=$(DESTDIR) install); \
	done

distrib:
	@echo "Distributing to $(DESTDIR)/lib"
	@if test ! -d $(DESTDIR)/$(DIR); \
		then umask 002; mkdir $(DESTDIR)/$(DIR); \
		else :; \
	fi
	@cp $(SRC) $(DESTDIR)/$(DIR); cd $(DESTDIR)/$(DIR); chmod 0644 $(SRC)
	@for dir in $(SUBDIR) $(AUXDIR); do rm -rf $(DESTDIR)/$(DIR)/$$dir; done
	@-for dir in $(SUBDIR) $(AUXDIR); do mkdir $(DESTDIR)/$(DIR)/$$dir; done
	@for dir in $(SUBDIR) $(AUXDIR); do \
		(echo "distrib to $(DESTDIR)/Tool/lib/$$dir"; \
		cd $$dir; $(MAKE) distrib DESTDIR=$(DESTDIR)); \
	done
	
executable:
	@for f in $(SUBDIR); do echo; echo Making $(DIR)/$$f executable; \
		cd $$f; make executable; cd ..; done
	rm -rf $(TIDY) $(AUX) Makefile Makefile.cpp

tidy:
	rm -rf $(TIDY)
	-@for dir in $(SUBDIR); do echo; echo Tidying Tool/lib/$$dir; \
		(cd $$dir; $(MAKE) tidy); done

clean:
	rm -rf $(CLEAN)
	-@for i in $(SUBDIR); do echo; echo Cleaning Tool/lib/$$i; cd $$i; \
		$(MAKE) clean; cd ..; done

# ========================================================
# rcs operations for the development diectory (RCS in each subdirectory):

RCSSYS=		/usr/local/gnu/rcs/bin
RCSFLAGS=	-q
RCSCMD=		co

comakefile:	RCS
	@for dir in $(SUBDIR) ; do \
		(cd $$dir; $(RCSSYS)/co $(RCSFLAGS) Makefile; \
		$(MAKE) comakefile); \
	done

rcs:	RCS
	@echo "$(RCSCMD) in ModLib"
	@for dir in $(SUBDIR) ; do \
	(echo "$(RCSCMD) in ModLib/$$dir"; cd $$dir; \
	$(MAKE) rcs RCSSYS=$(RCSSYS) RCSCMD=$(RCSCMD) RCSFLAGS='$(RCSFLAGS)'); \
	done
	-$(RCSSYS)/$(RCSCMD) $(RCSFLAGS) $(SRC)

RCS:
	@mkdir RCS
