#!/bin/sh
# $Id: ligaOptim.cmd,v 3.3 1992/03/09 08:45:18 cogito Exp $
# Copyright, 1990, The University of Paderborn

#ligaOptim <
#   optim_idl 'idl representation after liga optimization'*
#   optim_info ! 'messages from optim'
#   > 'attribute optimization'* :
#	USER
#		: repl_idl
#               : optUoption
#               : optEoption
#               : (:lido.cmpd :cpp)

umask 0
cd (|<RUNDIR|)

(|$/Tool/liga/ligaOptim.exe|) -i (|<repl_idl|) \
	-c (|<optUoption|) (|<optEoption|) \
	-o (|>optim_idl|) \
	-p (|>optim_info|)  > /dev/null 2> ERRORS

if test -s core
then
        echo '".", line 0:0 DEADLY: Tool LIGA OPTIM failed' >> ERRORS
fi

if test -s ERRORS
then
        sed -n -f (|$/Tool/liga/Cmd/mess_sort|) ERRORS
fi

if test -s ERRS
then
        echo '(''|(|$/Tool/liga/Info/optim.err|):std_err:' > (|>ERROR|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRS >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
fi

if test -s WARN
then
        echo '(''|(|$/Tool/liga/Info/optim.err|):std_err:' > (|>WARNING|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>WARNING|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' WARN >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
fi

exit 0
