#!/bin/sh
# $Id: ligaOption.cmd,v 3.5 1992/11/13 14:37:26 cogito Exp $
# Copyright, 1990, The University of Paderborn

#ligaOption <
#   exp_option 'options for LIGA expand and LIGA replincl'
#   ord_option  'options for LIGA order'*
#   optUoption  'options for LIGA optim before expand'*
#   back_option 'options for LIGA backend'*
#   option_lst ! 'liga option decorator protcol'
#   > 'LIGA option decorated evaluator'* :
#        USER
#		: (:ctl.cmpd :cpp)

umask 0
cd (|<RUNDIR|)

# Remove cpp additions from input
sed 's/^#.*$//' (|<(:ctl.cmpd :cpp)|) >input

(|$/Tool/liga/ligaOption.exe|) \
        input \
        (|>exp_option|) \
        (|>ord_option|) \
        (|>optUoption|) \
        (|>back_option|) > (|>option_lst|) 2> ERRORS

if test -s core
then
        echo '".", line 0:0 DEADLY: Tool LIGA OPTION failed' >> ERRORS
fi

if test -s ERRORS
then
        sed -n -f (|$/Tool/liga/Cmd/mess_sort|) ERRORS
fi

if test -s ERRS
then
        echo '(''|(|$/Tool/liga/Info/option.err|):std_err:' > (|>ERROR|)
        echo '(''|(|<(:ctl.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRS >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
fi

if test -s WARN
then
        echo '(''|(|$/Tool/liga/Info/option.err|):std_err:' > (|>WARNING|)
        echo '(''|(|<(:ctl.cmpd :cpp)|):cpp_err:' >> (|>WARNING|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' WARN >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
fi

exit 0
