/* $Id: expincl.c,v 2.3 1991/12/18 15:14:56 cogito Exp $ */
static char rcs_id[]= "$Id: expincl.c,v 2.3 1991/12/18 15:14:56 cogito Exp $";

/***********************************************************************\
*									*
*		Implementation of LIGA expand pass			*
*									*
*	Module:		expincl.c					*
*	File:		expincl.c					*
*	Contents:	functions to expand the INCLUDING construct	*
*	Author:		Hans Detlef Siewert				*
*	Creation date:	07 Feb 1991					*
*	Last change:	22 Apr 1991					*
*									*
\***********************************************************************/

#include <stdio.h>
#include <string.h>

#include "LIGA.h"
#include "LIGAMacros.h"

#include "ligaconsts.h"
#include "expconst.h"
#include "exp_types.h"
#include "expref.h"
#include "expidl.h"
#include "expand.h"
#include "exptrav.h"
#include "expincl.h"

/*
***** EXPANSION OF INCLUDING CONSTRUCTS
**
** To expand the INCLUDING construct this pass first calls the function
** find_includings(). It searches for all INCLUDING constructs by calling
** the recursive function incl_in_call() for all CALL rules at the top level
** of the attribution for all productions. The function is recursive because
** CALL rules could be nested. All constructs that are found are checked for
** various error conditions in the function check_incl() and added to a global
** list by calling append_incl(). Identical constructs (the lists of attributes
** to be included must match) are collected in special lists.
**  The next step is to call expand_includings(). This function runs through
** the list of INCLUDING constructs. For each construct and its identical
** constructs first all flags on productions and symbols are cleared and then
** mark_including() is called. All productions with symbols that carry
** attributes on the left hand side that should be included are marked as start
** productions. All productions containing one of the INCLUDING constructs are
** marked as target productions. For each target production mark_incl_trans() is
** called to find a path to one of the start productions. The function
** mark_incl_trans() marks the lhs symbol as transport symbol and calls itself
** recursively to mark all productions containing the symbol on the right hand
** side as transport productions. The recursion terminates at either the root
** symbol or at a start production.
**  After the productions and symbols have been marked, the function
** expand_including() is called by the function expand_includings(). This
** functions runs through the attributions of all productions and generates
** the appropriate assignments in start, transport and target productions by
** calling the functions incl_src_assign(), incl_trns_assign() and
** incl_target_assign() respectively.
**
*****
*/


/*
** GLOBAL VARIABLES
*/

IncNode	includings;	/* global list of all INCLUDING constructs	*/


/*
** LOCAL VARIABLES
*/

int	trans_assigns;	/* number of new assignments for transport	*/
int	source_assigns;	/* number of new assignments from sources	*/
int	newassigns;	/* total number of new assignments		*/


/*
** LOCAL FUNCTIONS
*/

static
#ifdef __STDC__
void show_including (IncNode incptr)
#else
void show_including(incptr)
IncNode incptr;
#endif
/* show this INCLUDING construct and it's similar constructs		*/
{
	IncNode	sameinc;

	if (!incptr)
		return;

	(void) fprintf (ProtocolFile,
		"\n    --> in production %s, line %d, col %d\n",
		dnameOfProd(prodref(incptr->prodid)),
		rowOfIncluding(incptr->incl),
		colOfIncluding(incptr->incl));
	if (sameinc= incptr->same)	/* assignment intended */
	{
		(void) fprintf (ProtocolFile,
			"\tidentical constructs:\n");
		for (; sameinc; sameinc=sameinc->same)
		{
			(void) fprintf (ProtocolFile,
				"\t\tin production %s, line %d, col %d\n",
				dnameOfProd(prodref(sameinc->prodid)),
				rowOfIncluding(sameinc->incl),
				colOfIncluding(sameinc->incl));
		} /* for */
	} /* if */
} /* show_including() */

static
#ifdef __STDC__
void mark_including (IncNode incptr)
#else
void mark_including (incptr)
IncNode incptr;
#endif
/* mark symbols and productions for expansion of INCLUDING		*/
{
	IncNode		incnode;
	SEQSymbattr	tmp;
	Symbattr	sa;
	SNode		symbs;

	/* mark source productions */
	foreachinSEQSymbattr(inclattrsOfIncluding(incptr->incl), tmp, sa)
	{
		/* mark all productions with the symbol on the lhs */
		for (symbs= symbldown(symbdefOfSymbattr(sa));
			symbs; symbs=symbs->down)
		{
			prodflag(symbs->prodid) |= start_prod;
		} /* for */
	} /* foreachinSEQSymbattr */

	markedsymbs= 0;
	markedprods= 0;
	protout (ProtocolFile, "\ttransport productions and symbols:\n");
	/* mark transport symbols and productions */
	/* for all identical constructs */
	for (incnode= incptr; incnode; incnode= incnode->same)
	{
		/* mark production as target production */
		prodflag(incnode->prodid) |= target_prod;

		/* mark symbols and productions for transport */
		mark_incl_trans (lhsOfProd(prodref(incnode->prodid)), incnode);
	} /* for */
	protout (ProtocolFile,
		"\tmarked for transport: %d symbols, %d productions\n",
		markedsymbs, markedprods);

} /* mark_including() */

static
#ifdef __STDC__
void incl_src_assign (IncNode incptr, Attribution attrib)
#else
void incl_src_assign (incptr, attrib)
IncNode incptr;
Attribution attrib;
#endif
/* create assignments from INCLUDING attribute to transport attributes	*/
{
	int		pid;
	int		lhsymb;
	SEQSymbattr	tmp1;
	Symbattr	sa;
	int		attrid;
	SEQAttrdef	tmp2;
	Attrdef		ad;
	Attrdef		tad;
	SNode		sn;
	int		sno;
	int		source_used;

	/* get dids of the production and its left hand symbol */
	pid= prodidOfAttribution(attrib);
	lhsymb= prodright(pid)->symbdid;

	/* search for source attribute */
	attrid= -1;
	foreachinSEQSymbattr (inclattrsOfIncluding(incptr->incl), tmp1, sa)
	{
		if (symbdefOfSymbattr(sa) == lhsymb)
		{
			attrid= attrdefOfSymbattr(sa);
			break;
		} /* if */
	} /* foreachinSEQSymbattr */

	if (attrid == -1)
	{
		/* this case should never occur */
		print_err (
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			"expincl.c: internal error #1", NO_ERRID);
		(void) fprintf (ProtocolFile,
			"\n*** ERROR  expincl.c: internal error #1, ");
		(void) fprintf (ProtocolFile,
			"line %d, col %d in production %s\n\n",
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			dnameOfProd(prodref(pid)));
	} /* if */

	/* search for definition of included attribute */
	foreachinSEQAttrdef (attrsOfSymb(symbref(lhsymb)), tmp2, ad)
	{
		if (didOfAttrdef(ad) == attrid)
			break;
	} /* foreachinSEQAttrdef */

	protout (ProtocolFile,
		"\tsource attribute %s.%s found in production %s:\n",
		dnameOfSymb(symbref(lhsymb)),
		nameOfAttrdef(ad),
		dnameOfProd(prodref(pid)));
	source_used= FALSE;

	/* search all transport symbols on the right hand side */
	sno= 0;
	for (sn= prodright(pid)->right; sn; sn= sn->right)
	{
	    sno++;
	    if (symbflag(sn->symbdid) == trnsp_symb)
	    {
		/* generate assignment to transport symbol */
		retrievefirstSEQAttrdef(attrsOfSymb(symbref(sn->symbdid)),tad);

		/* transport attribute was first attribute of this symbol */
		if (strcmp(nameOfAttrdef(tad),genattrOfIncluding(incptr->incl)))
		{
			print_err (
				rowOfIncluding(incptr->incl),
				colOfIncluding(incptr->incl),
				"expincl.c: internal error #2", NO_ERRID);
			(void) fprintf (ProtocolFile,
				"\n*** ERROR  expincl.c: internal error #2, ");
			(void) fprintf (ProtocolFile,
				"line %d, col %d in production %s\n\n",
				rowOfIncluding(incptr->incl),
				colOfIncluding(incptr->incl),
				dnameOfProd(prodref(pid)));
		} /* if */

		protout (ProtocolFile,
			"\t\t%s<%d>.%s := %s<1>.%s;\n",
			dnameOfSymb(symbref(sn->symbdid)), sno+1,
			nameOfAttrdef(tad), dnameOfSymb(symbref(lhsymb)),
			nameOfAttrdef(ad));
		gen_assign (attrib, 
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			sno, didOfAttrdef(tad),
			0, didOfAttrdef(ad),
			(incptr->typeid == DIDVOID || incptr->dep));
		source_assigns++;
		newassigns++;
		source_used= TRUE;
	    } /* if */
	} /* for */
	if (EXP_PROT && !source_used)
	{
		(void) fprintf (ProtocolFile,
			"\t\t*** no transport from this source context!\n");
	} /* if */
} /* incl_src_assign() */

static
#ifdef __STDC__
void incl_trns_assign (IncNode incptr, Attribution attrib)
#else
void incl_trns_assign (incptr, attrib)
IncNode incptr;
Attribution attrib;
#endif
/* create assignments for INCLUDING transport attributes		*/
{
	int		pid;
	int		lhsymb;
	Attrdef		ad;
	SNode		sn;
	int		sno;
	Attrdef		tad;

	pid= prodidOfAttribution(attrib);
	lhsymb= prodright(pid)->symbdid;

	/* transport attribute should be first attribute */
	retrievefirstSEQAttrdef (attrsOfSymb(symbref(lhsymb)), ad);

	if (strcmp(genattrOfIncluding(incptr->incl), nameOfAttrdef(ad)))
	{
		/* this case should never occur */
		print_err (
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			"expincl.c: internal error #3", NO_ERRID);
		(void) fprintf (ProtocolFile,
			"\n*** ERROR  expincl.c: internal error #3, ");
		(void) fprintf (ProtocolFile,
			"line %d, col %d in production %s\n\n",
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			dnameOfProd(prodref(pid)));
	} /* if */

	protout (ProtocolFile, "\ttransport through production %s:\n",
		dnameOfProd(prodref(pid)));

	/* search all transport symbols for transport attributes */
	sno= 0;
	for (sn= prodright(pid)->right; sn; sn= sn->right)
	{
	    sno++;
	    if (symbflag(sn->symbdid) == trnsp_symb)
	    {
		/* generate assignment to transport symbol */
		retrievefirstSEQAttrdef(attrsOfSymb(symbref(sn->symbdid)),tad);

		/* transport attribute should be first attribute */
		if (strcmp(nameOfAttrdef(tad),genattrOfIncluding(incptr->incl)))
		{
			print_err (
				rowOfIncluding(incptr->incl),
				colOfIncluding(incptr->incl),
				"expincl.c: internal error #4", NO_ERRID);
			(void) fprintf (ProtocolFile,
				"\n*** ERROR  expincl.c: internal error #4, ");
			(void) fprintf (ProtocolFile,
				"line %d, col %d in production %s\n\n",
				rowOfIncluding(incptr->incl),
				colOfIncluding(incptr->incl),
				dnameOfProd(prodref(pid)));
		} /* if */
		protout (ProtocolFile,
			"\t\t%s<%d>.%s := %s<1>.%s;\n",
			dnameOfSymb(symbref(sn->symbdid)), sno+1,
			nameOfAttrdef(tad), dnameOfSymb(symbref(lhsymb)),
			nameOfAttrdef(ad));
		gen_assign (attrib, 
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			sno, didOfAttrdef(tad),
			0, didOfAttrdef(ad),
			(incptr->typeid == DIDVOID || incptr->dep));
		trans_assigns++;
		newassigns++;
	    } /* if */
	} /* for */

} /* incl_trns_assign() */

static
#ifdef __STDC__
void incl_target_assign (IncNode incptr, Attribution attrib)
#else
void incl_target_assign (incptr, attrib)
IncNode incptr;
Attribution attrib;
#endif
/* modify INCLUDING construct to access transport attribute		*/
{
	int	pid;
	int	lhsymb;
	Attrdef	ad;
	IncNode	including;
	int	found;

	pid= prodidOfAttribution(attrib);
	lhsymb= prodright(pid)->symbdid;
	protout (ProtocolFile,
		"\ttarget context is production %s, access to %s<1>.%s\n",
		dnameOfProd(prodref(pid)),
		dnameOfSymb(symbref(lhsymb)),
		genattrOfIncluding (incptr->incl));

	/* transport attribute should be first attribute */
	retrievefirstSEQAttrdef (attrsOfSymb(symbref(lhsymb)), ad);

	if (strcmp(genattrOfIncluding(incptr->incl), nameOfAttrdef(ad)))
	{
		/* this case should never occur */
		print_err (
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			"expincl.c: internal error #5", NO_ERRID);
		(void) fprintf (ProtocolFile,
			"\n*** ERROR  expincl.c: internal error #5, ");
		(void) fprintf (ProtocolFile,
			"line %d, col %d in production %s\n\n",
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			dnameOfProd(prodref(pid)));
	} /* if */

	found= FALSE;
	/* search for including constructs */
	for (including= incptr; including; including= including->same)
	{
		if (including->prodid == pid)
		{
			found= TRUE;
			/* enter did of transport attribute */
			genattridOfIncluding(including->incl)= didOfAttrdef(ad);
		} /* if */
	} /* for */

	/* at least on construct must have been found */
	if (!found)
	{
		/* this case should never occur */
		print_err (
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			"expincl.c: internal error #6", NO_ERRID);
		(void) fprintf (ProtocolFile,
			"\n*** ERROR  expincl.c: internal error #6, ");
		(void) fprintf (ProtocolFile,
			"line %d, col %d in production %s\n\n",
			rowOfIncluding(incptr->incl),
			colOfIncluding(incptr->incl),
			dnameOfProd(prodref(pid)));
	} /* if */
} /* incl_target_assign() */

static
#ifdef __STDC__
void expand_including (IncNode incptr)
#else
void expand_including (incptr)
IncNode incptr;
#endif
/* expand INCLUDING construct by generating assignments			*/
{
	SEQAttribution	tmp;
	Attribution	attrib;

	trans_assigns= 0;
	source_assigns= 0;
	/* generate assignments */
	foreachinSEQAttribution (attrrulesOfAttrEval(IdlStruct), tmp, attrib)
	{
		if (prodflag(prodidOfAttribution(attrib)) & start_prod)
		{
			/* an attribute in this context was included */
			incl_src_assign (incptr, attrib);
		} /* if */
		if (prodflag(prodidOfAttribution(attrib)) & trans_prod)
		{
			/* transport context */
			incl_trns_assign (incptr, attrib);
		} /* if */
		if (prodflag(prodidOfAttribution(attrib)) & target_prod)
		{
			/* context containing INCLUDING construct */
			incl_target_assign (incptr, attrib);
		} /* if */
		prodflag(prodidOfAttribution(attrib))= no_pflag;
	} /* foreachinSEQAttribution */

	protout (ProtocolFile,
		"\t%d new assignments:  %d from source attributes, ",
		source_assigns + trans_assigns,
		source_assigns);
	protout (ProtocolFile, "%d for transport\n", trans_assigns);
} /* expand_including() */


/*
** GLOBAL FUNCTIONS
*/


#ifdef __STDC__
void find_includings (void)
#else
void find_includings()
#endif
/* search all INCLUDING constructs and build a list for them		*/
{
	SEQAttribution	tmp1;
	Attribution	attrib;
	SEQAttrrule	tmp2;
	Attrrule	rule;
	int		counter;

	newattrname= (char *) malloc (strlen (INCL_ATTR) + 8);
	if (!newattrname)
		deadly ("expand: out of memory\n");
	inclcount= 0;
	includings= (IncNode) NULL;
	counter= 0;
	foreachinSEQAttribution (attrrulesOfAttrEval(IdlStruct), tmp1, attrib)
	{
	    foreachinSEQAttrrule (attrrulesOfAttribution(attrib), tmp2, rule)
	    {
		if (typeof(rule) == KCall)
		{
			counter+= incl_in_call (
					AttrruleToCall(rule),
					prodidOfAttribution(attrib),
					FALSE);
		} /* if */
	    } /* foreachinSEQAttrrule */
	} /* foreachinSEQAttribution */

	switch (counter)
	{
		case 0:
			(void) fprintf(ProtocolFile, "\nNo INCLUDINGs found\n");
			break;
		case 1:
			(void) fprintf(ProtocolFile, "\nOne INCLUDING found\n");
			break;
		default:
			(void) fprintf(ProtocolFile,
				"\n%d INCLUDINGs found\n", counter);
	} /* switch */

	free (newattrname);
}/* find_includings() */

#ifdef __STDC__
void expand_includings (void)
#else
void expand_includings()
#endif
/* expand all INCLUDING constructs					*/
{
	IncNode incptr, incptr2, incptr3;

	if (!inclcount)
		return;

	newattrs= 0;
	newassigns= 0;
	protout (ProtocolFile, "\nINCLUDING expansion:");

	/* examine all including constructs in the list */
	for (incptr= includings; incptr; incptr= incptr->next)
	{
		clear_psflags();

		if (EXP_PROT)
			show_including (incptr);

		mark_including (incptr);
		expand_including (incptr);
	} /* for */

	/* release memory occupied by nodes for global list */
	for (incptr= includings; incptr; incptr= incptr2)
	{
		for (incptr2= incptr->same; incptr2; incptr2= incptr3)
		{
			incptr3= incptr2->same;
			free (incptr2);
		} /* for */
		incptr2= incptr->next;
		free (incptr);
	} /* for */
	includings= (IncNode) NULL;

	if (inclcount==1)
	{
		(void) fprintf (ProtocolFile, "One INCLUDING expanded; ");
	} /* if */
	else
	{
		(void) fprintf (ProtocolFile,
			"%d different INCLUDINGs expanded; ",
			inclcount);
	} /* else */

	switch (newattrs)
	{
	    case 0:
		(void) fprintf (ProtocolFile, "no new attributes, ");
		break;
	    case 1:
		(void) fprintf (ProtocolFile, "one new attribute, ");
		break;
	    default:
		(void) fprintf (ProtocolFile, "%d new attributes, ",
			newattrs);
	} /* switch */

	switch (newassigns)
	{
	    case 0:
		(void) fprintf (ProtocolFile, "no new assignments\n");
		break;
	    case 1:
		(void) fprintf (ProtocolFile, "one new assignment\n");
		break;
	    default:
		(void) fprintf (ProtocolFile, "%d new assignments\n",
			newassigns);
	} /* switch */
} /* expand_includings() */

/***********************\
* end of expincl.c	*
\***********************/

								/* HaDeS */

