/* $Id: SymComp.c,v 3.6 1992/11/04 15:36:39 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "HEAD.h"

#define LOWER(p)	(p == 0)
#define UPPER(p)	(p > 0)

/* global variables for substitution: */
DefTableKey	tosymkey, torulekey;
Environment	toscope;
int		tosympos, prodlhsdid, isterm, isroot;
POSITION	*tocoord, fromcoord;
SEQAttrrule	allcomps;

static
Expr TransExpr ();

static
SEQExpr TransSEQExpr (src)
	SEQExpr		src;
{	
	Expr		ex;

if (src) {
	retrievefirstSEQExpr (src, ex);
	return (AppFrontSEQExpr (
			TransExpr (ex),
			TransSEQExpr (tailSEQExpr (src)))
	);
} else	return (nullSEQExpr ());
}/*TransSEQExp*/

static
Expr TransExpr (src)
	Expr		src;
{	
switch (typeof(src)) {

case KCall:
{	Call	ca;
	SEQExpr	seq;

ca = ExprToCall (src);
seq = TransSEQExpr (paramsOfCall (ca));
ca = MkCall (nameOfCall (ca), seq, rowOfCall (ca), colOfCall (ca));
src = CallToExpr (ca);
return (src);
}

case KAttracc:
{	Attracc		ac;
	int		atid;
	DefTableKey	tokey;
	int		todid;

ac = ExprToAttracc (src);
atid = attridOfAttracc (ac);
tokey = KeyInScope (toscope, atid);
if (tokey == NoKey) 
	tokey = DeclareImplAttr (tosymkey,  atid, ATCLUNKN, &fromcoord);
todid = GetDid (tokey, DIDNON);
ac = MkAttracc (tosympos, todid,
		fromcoord.line, fromcoord.col);
src = AttraccToExpr (ac);
return (src);
};

case KChainacc: {
	Chainacc	ca;
	int		syntpos;
ca = ExprToChainacc (src);
if (symbnoOfChainacc(ca) == HEADCode) {
	syntpos = GetHEADpos (torulekey, 0);
	return (ChainaccToExpr (MkChainacc (
		syntpos, chainidOfChainacc (ca),
		fromcoord.line, fromcoord.col)));	
} else
if (symbnoOfChainacc(ca) == TAILCode) {
	syntpos = GetTAILpos (torulekey, 0);
	if (syntpos == 0) {
	message (ERROR, "TAIL inherited to production without nonterminal",
		0, &fromcoord);
	message (ERROR, "TAIL inherited to production without nonterminal",
		0, tocoord);
	}
	return (ChainaccToExpr (MkChainacc (
		syntpos, chainidOfChainacc (ca),
		fromcoord.line, fromcoord.col)));
} else	return (CpExpr(src));
}

case KConstit:
if (constattrsOfConstit (ExprToConstit (src)) == nullSEQSymbattr ()) {
	POSITION	co;
	co.line = rowOfConstit (ExprToConstit (src));
	co.col  = colOfConstit (ExprToConstit (src));
	message (ERROR,
	"yields empty remote list in some context", 0, &co);
	message (ERROR,
	"inherits computation with empty remote list", 0, tocoord);
}
if (UPPER (tosympos)) {
	Constit		c;

	c = CpConstit (ExprToConstit (src));
	subtreeOfConstit (c) = tosympos;
	return (ConstitToExpr (c));
} else	return (CpExpr(src));

case KIncluding:
if (inclattrsOfIncluding (ExprToIncluding (src)) == nullSEQSymbattr ()) {
	POSITION	co;
	co.line = rowOfIncluding (ExprToIncluding (src));
	co.col  = colOfIncluding (ExprToIncluding (src));
	message (ERROR,
	"yields empty remote list in some context", 0, &co);
	message (ERROR,
	"inherits computation with empty remote list", 0, tocoord);
}
if (UPPER (tosympos)) {
	SEQSymbattr	symats;
	Symbattr	symat;
	Attracc		ac;

	foreachinSEQSymbattr 
		(inclattrsOfIncluding (ExprToIncluding (src)), symats, symat) {
	if (prodlhsdid == symbdefOfSymbattr (symat)) {
		ac = MkAttracc (0, 
				attrdefOfSymbattr (symat), 
				fromcoord.line, fromcoord.col);
		src = AttraccToExpr (ac);
		return (src);
	}
	}/*foreach*/
}
return (CpExpr(src));

default:
	return (CpExpr(src));
}

}/*TransExpr*/

int ToBeAdded (new)
	 Attrrule	new;
/* yields true if 
	new is a plain computation OR
	new is a ChainStart 
		and the production has a nonterminal OR
	new is a HEAD chain computation 
		and the production has a nonterminal
	AND
	there is no computation for the attribute computed by new
		in the list of computations collected so far or
*/
{	SEQAttrrule	cmps;
	Attrrule	cmp;
	Call		ca, newcall;
	Expr		lhsex, newlhsex;
	ChainStart	newchst, chst;
	int 		newid, newdid, did, gotpos, newpos;
	DefTableKey	newkey;

switch (typeof (new)) {

case KCall:
newcall = AttrruleToCall (new);
if (strcmp (ASSIGNFCT, nameOfCall (newcall)) != 0)
	return (true); /* plain computation */
else {
	retrievefirstSEQExpr (paramsOfCall (newcall), newlhsex);
	if (typeof (newlhsex) == KAttracc) {
		newid = attridOfAttracc (ExprToAttracc (newlhsex));
		newkey = KeyInScope (toscope, newid);
		if (newkey == NoKey) {
		message (ERROR, 
		"inherited to a symbol that does not define this attribute",
		0, &fromcoord);
		message (ERROR, 
		"inherits an undefined attribute use", 0, tocoord);
		return (false);
		}
		newdid = GetDid (newkey, DIDNON);
		newpos = tosympos;
	} else if (typeof (newlhsex) == KChainacc) {
		newdid = chainidOfChainacc (ExprToChainacc (newlhsex));
		newpos = tosympos;
		if (HEADCode == symbnoOfChainacc (ExprToChainacc (newlhsex))) {
			newpos = GetHEADpos (torulekey, 0);
			if (0 == newpos) {
			message (WARNING, 
			"HEAD is not inherited to production without nonterminal",
			0, &fromcoord);
			message (WARNING, 
			"HEAD computation is not inherited here",
			0, tocoord);
			return (false);
			}
		}
	} else	return (false);
}

foreachinSEQAttrrule (allcomps, cmps, cmp) 
	if (typeof (cmp) == KCall) {
	ca = AttrruleToCall (cmp);
	if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0) {
		retrievefirstSEQExpr (paramsOfCall (ca), lhsex);
		if (typeof(lhsex) == KAttracc) {
			gotpos = symbnoOfAttracc(ExprToAttracc(lhsex));
			did = attridOfAttracc(ExprToAttracc(lhsex));
		} else if (typeof(lhsex) == KChainacc) {
			gotpos = symbnoOfChainacc(ExprToChainacc(lhsex));
			did = chainidOfChainacc(ExprToChainacc(lhsex));
		} else	return (false);

		if ((newdid == did) && (gotpos == newpos))
			return (false);
	}
}
break;

case KChainStart:
newchst = AttrruleToChainStart (new);
newdid = chainidOfChainStart (newchst);

if (0 == GetHEADpos (torulekey, 0)) {
	message (WARNING, 
	"CHAINSTART is not inherited to production without nonterminal",
	0, &fromcoord);
	message (WARNING, 
	"CHAINSTART is not inherited here",
	0, tocoord);
	return (false);
}

foreachinSEQAttrrule (allcomps, cmps, cmp) {
	if (typeof (cmp) == KChainStart) {
		chst = AttrruleToChainStart (cmp);
		if (chainidOfChainStart (chst) == newdid)
			return (false);
	}
}/*foreachinSEQAttrrule*/
break;

default:
return (false);

}/*switch*/
return (true);
}/*ToBeAdded*/


/*static*/
void AddSymComps (symcomps)
	SEQAttrrule	symcomps;
{	SEQAttrrule	ars;
	Attrrule	symcomp, ar;
	Call		symcall;
	Expr		ex;
	ChainStart	symcst;

foreachinSEQAttrrule (symcomps, ars, symcomp) 
switch (typeof (symcomp)) {

case KCall:
	symcall = AttrruleToCall (symcomp);
	fromcoord.line = rowOfCall (symcall);
	fromcoord.col = colOfCall (symcall);
	if (ToBeAdded (symcomp)) {
		ex = CallToExpr (symcall);
		ex = TransExpr (ex);
		ar = CallToAttrrule (ExprToCall(ex));
		allcomps = AppFrontSEQAttrrule (ar, allcomps);
	}
break;

case KChainStart:
	symcst = AttrruleToChainStart (symcomp);
	fromcoord.line = rowOfChainStart (symcst);
	fromcoord.col = colOfChainStart (symcst);
	if (ToBeAdded (symcomp))
		allcomps = 
		AppFrontSEQAttrrule (CpAttrrule (symcomp), allcomps);
break;

default:;

}/*switch, for each comp */
}/*AddSymComps*/

static
void AllSymInhComps (fromkey)
	DefTableKey	fromkey;
{	SEQAttrrule	symcomps;
	TList		inhsyms;

if (isterm || isroot) {
	symcomps = GetLowAttrib (fromkey, nullSEQAttrrule ());
	AddSymComps (symcomps);
	symcomps = GetUpAttrib (fromkey, nullSEQAttrrule ());
	AddSymComps (symcomps);
} else
if (LOWER (tosympos)) {	/* target is on lhs of production */
	symcomps = GetLowAttrib (fromkey, nullSEQAttrrule ());
	AddSymComps (symcomps);
} else {		/* target is on rhs of production */
	symcomps = GetUpAttrib (fromkey, nullSEQAttrrule ());
	AddSymComps (symcomps);
}

inhsyms = GetInhFrom (fromkey, NullList);
while (inhsyms != NullList) {
	AllSymInhComps ((DefTableKey)HeadList (inhsyms));
	inhsyms = TailList (inhsyms);
}
}/*AllSymInhComps*/

void MakeInhComps (rulekey, symkey, topos, lhsdid, coord)
	DefTableKey	rulekey, symkey;
	int		topos, lhsdid;
	POSITION *	coord;
{	TList		prodlist;
	ProdElem	pel;

tosymkey = symkey;
toscope = GetAttrScope (symkey, NoEnv);
if (toscope == NoEnv) return;

prodlhsdid = lhsdid;
tosympos = topos;
tocoord = coord;
fromcoord.line = coord->line;
fromcoord.col = coord->col;
isterm = (GetSymClass (symkey, SYMBNONT) == SYMBTERM);
isroot = GetIsRoot (symkey, false);
allcomps = GetAttrib (rulekey, nullSEQAttrrule());
torulekey = rulekey;

AllSymInhComps (symkey);

SetAttrib (rulekey, allcomps, allcomps);
}/*MakeInhComps*/
