# $Id: Makefile.cpp,v 3.8 1992/11/27 13:28:16 cogito Exp $
# 
# Makefile to compile LIGA-frontend previously generated from LIDO-AG

SHELL	= /bin/sh
CFLAGS	=

# default to a safe place for target location
DESTDIR = /tmp
DISTRIB = /tmp

IDL	= ../idl
SCEL	= ../ligascel

PFLAGS  = -w -temp=.
COFLAGS = -q

DERIVE  = frontderive

EXE	= ../ligaFe.exe

FILES	= AG.specs        GlobDef.pdl     IntfAttrib.lido ListProd.lido \
	Syntax.lido Lido.head \
	Attr.pdl        GlobDef.lido    IntfDef.lido    Old.lido \
	VoidChk.lido \
	AttrDefs.lido   GramCon.pdl     IntfExpr.lido   Support.specs \
	liga.ptg \
	AttrNames.lido  GramCon.ptg     Lido.ctl        SymComp.pdl \
	ChainProd.lido  Grammar.lido    Lido.gla        SymComp.lido \
	GenTree.lido    Intf.pdl        Lido.specs      Syntax.pdl \
	AttrDefs.c      IntfAttrib.c    Names.c         SymInh.c \
	GlobDef.c       LigaDid.c       Syntax.c 	p_mkstr.c \
	include.pdl \
	GramCon.c       List.c          SymComp.c       liga_To_func.c

HDR	= AttrDefs.h      IntfAttrib.h    Names.h       SymInh.h \
	GlobDef.h       LigaDid.h         Syntax.h  	p_mkstr.h \
	GramCon.h       List.h          SymComp.h       liga_To_func.h

EXTHDR	= $(IDL)/LIGA.h $(IDL)/LIGAMacros.h $(IDL)/global.h $(IDL)/liga_func.h\
	$(SCEL)/ligaconsts.h $(IDL)/lookup_idl.h $(SCEL)/OutStr.h
EXTSRC = $(SCEL)/OutStr.c
LIBS	= $(IDL)/IDL.a
EXT	= LIGA.h LIGAMacros.h global.h liga_func.h IDL.a ligaconsts.h

TIDY	= *.o *.a ERRS *~ *%
CLEAN	= $(TIDY) ../ligaFe.exe LIGALR COMPILER/IDL.a $(EXT)
CLOBBER = $(CLEAN) COMPILER Makefile
RCS	= $(FILES) $(HDR) $(DERIVE)

# generates the sources for the frontend

all:
	(cd COMPILER; make EXE="../$(EXE)" CC="$(CC)" PFLAGS="$(PFLAGS)")

$(EXE):
	(cd COMPILER; make EXE="../$(EXE)" CC="$(CC)" PFLAGS="$(PFLAGS)")

gen:	CACHE $(FILES) $(EXTSRC) $(LIBS) $(HDR) $(EXTHDR)
	$(DESTDIR)/bin/eli -c CACHE < $(DERIVE)
	sed -e '/\$$(OBJS)/s|\$$(OBJS)|\$$(OBJS) ../../idl/IDL.a|g' \
            COMPILER/Makefile.cpp > COMPILER/Makefile.new; \
        mv COMPILER/Makefile.new COMPILER/Makefile.cpp
	cd COMPILER; Configure

CACHE:	
	        $(DESTDIR)/bin/eli -c $(DESTDIR) -n CACHE -q

# installation

install:    $(EXE)
	rm -f $(DESTDIR)/Tool/liga/ligaFe.exe
	cp $(EXE) $(DESTDIR)/Tool/liga/ligaFe.exe
	chmod 755 $(DESTDIR)/Tool/liga/ligaFe.exe


# distribution

distrib: clean Makefile.cpp Makefile
	rm -rf $(DISTRIB)/frontend
	mkdir $(DISTRIB)/frontend
	cp Makefile.cpp $(DISTRIB)/frontend
	cd $(DISTRIB)/frontend; chmod 0644 Makefile.cpp
	cp -r COMPILER $(DISTRIB)/frontend/COMPILER
	cd $(DISTRIB)/frontend/COMPILER; chmod 0644 *

# checkout
 
checkout:
	-co $(COFLAGS) $(RCS)

# SourceDistr

SourceDistr:	Makefile.cpp
	cp -r $(ELI)/COMPILER .
	cd COMPILER; make clean

# cleaning targets

.PHONY:		tidy clean rcsclean clobber

tidy:
		rm -rf $(TIDY)

clean:
		rm -rf $(CLEAN)
		-cd COMPILER; make clean

clobber:
		rm -rf $(CLOBBER)

rcsclean:	clean
		rm -f Makefile README
		-rcsclean $(COFLAGS) $(RCS) 

save:
		-mkdir RCS
		-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
		-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
		-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
		-ci -fOriginal.1 -m/dev/null -q $(RCS)

