/* $Id: ProdUtil.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: ProdUtil.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Prod/ProdUtil.c					*
 *									*
 *	CONTENTS:	Utilities dealing with productions		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#include "Misc.h"
#include "Prod.h"

#include <X11/StringDefs.h>


/************************************************************************
 *			      ProdStateLabel				*
 ************************************************************************/

/* Returns the label indicating the current state of this production.
 */

PUBLIC String ProdStateLabel (prod)
	PRODENTRY *prod;
{
	static char ret[255];

	strcpy (ret, "");
	if (prod->state & S_CYCLIC)
		{ strcat (ret, " "); strcat (ret, Res.str_cyclic); }
	if (prod->state & S_ARRANGED)
		{ strcat (ret, " "); strcat (ret, Res.str_arranged); }
	if (prod->state & S_CHANGED)
		{ strcat (ret, " "); strcat (ret, Res.str_changed); }
	if (prod->state & S_PARTITIONED)
		{ strcat (ret, " "); strcat (ret, Res.str_part); }
	if (prod->state & S_VISIT_SEQ)
		{ strcat (ret, " "); strcat (ret, Res.str_vs); }

	if (ret[0] != '\0')     return (& ret[1]);
	else                    return ("");
}


/************************************************************************
 *			     ProdSearchCycle				*
 ************************************************************************/

/* Searches a cycle in the given production <prod>.
 */

PUBLIC Boolean ProdSearchCycle (prod, nd, ae)
	PRODENTRY	*prod;
	SLNODE		**nd;
	ATTRENTRY	**ae;
{
	SEQAttrdef	sad;
	Attrdef		ad;

	for (*nd=prod->hdright; *nd!=NULL; *nd=(*nd)->right)
	{
		SYMBENTRY *symb = & SE((*nd)->sid);

		foreachinSEQAttrdef (symb->symb_def->attrs, sad, ad)
		{
			*ae = & AE(ad->did);
			if (prod->dp[(*nd)->start_row+(*ae)->pos]
				    [(*nd)->start_row+(*ae)->pos])
				return (True);
		}
	}
	*nd = (SLNODE *) NULL;
	*ae = (ATTRENTRY *) NULL;
	return (False);
}


/************************************************************************
 *			     ProdResizeWindow				*
 ************************************************************************/

PUBLIC void ProdResizeWindow (prod)
	PRODENTRY *prod;
{
	Dimension	width, height;
	Arg		args[2];

      /* Don't try the following for non-existant windows */
	if (! prod->par) return;

      /* Force later redisplay */
	RedisplayGraphOfDid (prod->prod_def->did);

      /* Compute desired width and height and store them in <args> */
	ProdComputeWindowSize (prod, &width, &height);
	XtSetArg (args[0], XtNwidth, width);
	XtSetArg (args[1], XtNheight, height);

      /* Try to resize the windows */
	XtSetValues (prod->par->state, args, 1);
	XtSetValues (XtParent (prod->par->widget), args, 2);
	XtSetValues (prod->par->widget, args, 2);
}
