/* $Id: SymbProd.c,v 1.5 1992/11/20 15:17:33 cogito Exp $ */
static char rcs_id[]= "$Id: SymbProd.c,v 1.5 1992/11/20 15:17:33 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Symb/SymbProd.c					*
 *									*
 *	CONTENTS:	Creation of production windows from a symbol	*
 *			window						*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

       /************************ WARNING ************************ 
	*							*
 	*	This file depends on the Athena Widget Set	*
 	*	of X Version 11, Release 4			*
	*							*
	*********************************************************/

#include "Misc.h"
#include "Create.h"
#include "Prod.h"
#include "Main.h"
#include "Graph.h"
#include "Popup.h"
#include "Symb.h"

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/List.h>


/************************************************************************
 *			      Global Widgets				*
 ************************************************************************/

PRIVATE Widget	SymbProdPopup = NULL;
PRIVATE String	*SymbProdList;
PRIVATE int	SymbProdListSize;


/************************************************************************
 *			         CancelCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE void CancelCB (w, client_data, call_data)
	Widget	w;
	caddr_t client_data;
	caddr_t call_data;
{
	XtPopdown	(SymbProdPopup);
	XtDestroyWidget	(SymbProdPopup);
	XtFree ((char *)SymbProdList);
	SymbProdPopup = NULL;
}


/************************************************************************
 *			       SelectProdCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE SelectProdCB (w, client_data, call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	XawListReturnStruct	*item = (XawListReturnStruct *) call_data;
	int			pid   = lookupProdByName (item->string) -> did;

      /* Create the new production */
	ProdCreateNew (pid);
}


/************************************************************************
 *			        strcompare				*
 ************************************************************************/

PRIVATE int strcompare (s1, s2)
	char **s1, **s2;
{
	return (strcmp (*s1, *s2));
}


/************************************************************************
 *			    SymbBuildProdList 				*
 ************************************************************************/

PRIVATE void SymbBuildProdList (symb)
	SYMBENTRY *symb;
{
	SLNODE *nd;
	String	name;

      /* Count the productions */
	SymbProdListSize = 0;
	for (nd = symb->hddown; nd != NULL; nd = nd->down) SymbProdListSize ++;

      /* Allocate space for the list */
	SymbProdList = (String *) XtMalloc (sizeof(String) * (1+SymbProdListSize));

      /* Fill the list with the dname entries of the productions */
	SymbProdListSize = 0;
	for (nd = symb->hddown; nd != NULL; nd = nd->down)
	{
		name = PE(nd->pid).prod_def->dname;

		if (SymbProdListSize == 0 ||
		    strcmp (SymbProdList[SymbProdListSize-1], name))
			SymbProdList[SymbProdListSize++] = name;
	}

      /* Sort the production list */
	if (Res.sort_prod_list)
		qsort ((char *) SymbProdList, SymbProdListSize,
			sizeof (String), strcompare);
}


/************************************************************************
 *			        SymbProdCB				*
 ************************************************************************/

/*ARGSUSED*/
PUBLIC void SymbProdCB (w, client_data, call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	SYMBENTRY	*symb = & SE (DidOfGraphMenu);

	Position	x, y;
	Arg		args[10];
	int		n;
	Widget		paned, cancel, list;

      /* Close old popup */
	if (SymbProdPopup)
		CancelCB ((Widget) NULL, (caddr_t) NULL, (caddr_t) NULL);

      /* Popup shell */
	GetPopupPositions (symb->symb_def->did, &x, &y);
	n = 0;
	XtSetArg (args[n], XtNx, x); n++;
	XtSetArg (args[n], XtNy, y); n++;
	SymbProdPopup = XtCreatePopupShell ("symbolRules",
		transientShellWidgetClass, Toplevel, args, n);

      /* paned widget */
	n = 0; paned = CreatePaned ("paned", SymbProdPopup);

      /* label */
	n = 0; (void) CreateLabel ("label", paned);

      /* cancel command */
	n = 0; CreateCommand (cancel, "cancel", paned, CancelCB, NULL);

      /* production list */
	SymbBuildProdList (symb);
	n = 0;
	XtSetArg (args[n], XtNlist, SymbProdList); n++;
	XtSetArg (args[n], XtNnumberStrings, SymbProdListSize); n++;
	list = CreateList ("rules", paned);
	XtAddCallback (list, XtNcallback, SelectProdCB, (caddr_t) NULL);
	
      /* Popup the window */
	XtPopup (SymbProdPopup, XtGrabNone);
}
